; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=arm64-none-linux-gnu -mattr=+neon -fp-contract=fast                 | FileCheck %s --check-prefixes=CHECK,GENERIC
; The instruction latencies of Exynos-M1 trigger the transform we see under the Exynos check.
; RUN: llc < %s -verify-machineinstrs -mtriple=arm64-none-linux-gnu -mattr=+neon -fp-contract=fast -mcpu=exynos-m1 | FileCheck %s --check-prefixes=CHECK,EXYNOSM1
; RUN: llc < %s -verify-machineinstrs -mtriple=arm64-none-linux-gnu -mattr=+neon -fp-contract=fast -mcpu=exynos-m3 | FileCheck %s --check-prefixes=CHECK,EXYNOSM3

declare <2 x double> @llvm.aarch64.neon.fmulx.v2f64(<2 x double>, <2 x double>)

declare <4 x float> @llvm.aarch64.neon.fmulx.v4f32(<4 x float>, <4 x float>)

declare <2 x float> @llvm.aarch64.neon.fmulx.v2f32(<2 x float>, <2 x float>)

declare <4 x i32> @llvm.aarch64.neon.sqrdmulh.v4i32(<4 x i32>, <4 x i32>)

declare <2 x i32> @llvm.aarch64.neon.sqrdmulh.v2i32(<2 x i32>, <2 x i32>)

declare <8 x i16> @llvm.aarch64.neon.sqrdmulh.v8i16(<8 x i16>, <8 x i16>)

declare <4 x i16> @llvm.aarch64.neon.sqrdmulh.v4i16(<4 x i16>, <4 x i16>)

declare <4 x i32> @llvm.aarch64.neon.sqdmulh.v4i32(<4 x i32>, <4 x i32>)

declare <2 x i32> @llvm.aarch64.neon.sqdmulh.v2i32(<2 x i32>, <2 x i32>)

declare <8 x i16> @llvm.aarch64.neon.sqdmulh.v8i16(<8 x i16>, <8 x i16>)

declare <4 x i16> @llvm.aarch64.neon.sqdmulh.v4i16(<4 x i16>, <4 x i16>)

declare <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32>, <2 x i32>)

declare <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16>, <4 x i16>)

declare <2 x i64> @llvm.aarch64.neon.sqsub.v2i64(<2 x i64>, <2 x i64>)

declare <4 x i32> @llvm.aarch64.neon.sqsub.v4i32(<4 x i32>, <4 x i32>)

declare <2 x i64> @llvm.aarch64.neon.sqadd.v2i64(<2 x i64>, <2 x i64>)

declare <4 x i32> @llvm.aarch64.neon.sqadd.v4i32(<4 x i32>, <4 x i32>)

declare <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32>, <2 x i32>)

declare <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16>, <4 x i16>)

declare <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32>, <2 x i32>)

declare <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16>, <4 x i16>)

define <4 x i16> @test_vmla_lane_s16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmla_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mla v0.4h, v1.4h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = mul <4 x i16> %shuffle, %b
  %add = add <4 x i16> %mul, %a
  ret <4 x i16> %add
}

define <8 x i16> @test_vmlaq_lane_s16(<8 x i16> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlaq_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mla v0.8h, v1.8h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %mul = mul <8 x i16> %shuffle, %b
  %add = add <8 x i16> %mul, %a
  ret <8 x i16> %add
}

define <2 x i32> @test_vmla_lane_s32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmla_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mla v0.2s, v1.2s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %mul = mul <2 x i32> %shuffle, %b
  %add = add <2 x i32> %mul, %a
  ret <2 x i32> %add
}

define <4 x i32> @test_vmlaq_lane_s32(<4 x i32> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlaq_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mla v0.4s, v1.4s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %mul = mul <4 x i32> %shuffle, %b
  %add = add <4 x i32> %mul, %a
  ret <4 x i32> %add
}

define <4 x i16> @test_vmla_laneq_s16(<4 x i16> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmla_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mla v0.4h, v1.4h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %mul = mul <4 x i16> %shuffle, %b
  %add = add <4 x i16> %mul, %a
  ret <4 x i16> %add
}

define <8 x i16> @test_vmlaq_laneq_s16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlaq_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mla v0.8h, v1.8h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  %mul = mul <8 x i16> %shuffle, %b
  %add = add <8 x i16> %mul, %a
  ret <8 x i16> %add
}

define <2 x i32> @test_vmla_laneq_s32(<2 x i32> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmla_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mla v0.2s, v1.2s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %mul = mul <2 x i32> %shuffle, %b
  %add = add <2 x i32> %mul, %a
  ret <2 x i32> %add
}

define <4 x i32> @test_vmlaq_laneq_s32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlaq_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mla v0.4s, v1.4s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = mul <4 x i32> %shuffle, %b
  %add = add <4 x i32> %mul, %a
  ret <4 x i32> %add
}

define <4 x i16> @test_vmls_lane_s16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmls_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mls v0.4h, v1.4h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = mul <4 x i16> %shuffle, %b
  %sub = sub <4 x i16> %a, %mul
  ret <4 x i16> %sub
}

define <8 x i16> @test_vmlsq_lane_s16(<8 x i16> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsq_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mls v0.8h, v1.8h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %mul = mul <8 x i16> %shuffle, %b
  %sub = sub <8 x i16> %a, %mul
  ret <8 x i16> %sub
}

define <2 x i32> @test_vmls_lane_s32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmls_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mls v0.2s, v1.2s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %mul = mul <2 x i32> %shuffle, %b
  %sub = sub <2 x i32> %a, %mul
  ret <2 x i32> %sub
}

define <4 x i32> @test_vmlsq_lane_s32(<4 x i32> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsq_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mls v0.4s, v1.4s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %mul = mul <4 x i32> %shuffle, %b
  %sub = sub <4 x i32> %a, %mul
  ret <4 x i32> %sub
}

define <4 x i16> @test_vmls_laneq_s16(<4 x i16> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmls_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mls v0.4h, v1.4h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %mul = mul <4 x i16> %shuffle, %b
  %sub = sub <4 x i16> %a, %mul
  ret <4 x i16> %sub
}

define <8 x i16> @test_vmlsq_laneq_s16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsq_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mls v0.8h, v1.8h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  %mul = mul <8 x i16> %shuffle, %b
  %sub = sub <8 x i16> %a, %mul
  ret <8 x i16> %sub
}

define <2 x i32> @test_vmls_laneq_s32(<2 x i32> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmls_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mls v0.2s, v1.2s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %mul = mul <2 x i32> %shuffle, %b
  %sub = sub <2 x i32> %a, %mul
  ret <2 x i32> %sub
}

define <4 x i32> @test_vmlsq_laneq_s32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsq_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mls v0.4s, v1.4s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = mul <4 x i32> %shuffle, %b
  %sub = sub <4 x i32> %a, %mul
  ret <4 x i32> %sub
}

define <4 x i16> @test_vmul_lane_s16(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmul_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.4h, v0.4h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = mul <4 x i16> %shuffle, %a
  ret <4 x i16> %mul
}

define <8 x i16> @test_vmulq_lane_s16(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmulq_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.8h, v0.8h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %mul = mul <8 x i16> %shuffle, %a
  ret <8 x i16> %mul
}

define <2 x i32> @test_vmul_lane_s32(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmul_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.2s, v0.2s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %mul = mul <2 x i32> %shuffle, %a
  ret <2 x i32> %mul
}

define <4 x i32> @test_vmulq_lane_s32(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmulq_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.4s, v0.4s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %mul = mul <4 x i32> %shuffle, %a
  ret <4 x i32> %mul
}

define <4 x i16> @test_vmul_lane_u16(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmul_lane_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.4h, v0.4h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = mul <4 x i16> %shuffle, %a
  ret <4 x i16> %mul
}

define <8 x i16> @test_vmulq_lane_u16(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmulq_lane_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.8h, v0.8h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %mul = mul <8 x i16> %shuffle, %a
  ret <8 x i16> %mul
}

define <2 x i32> @test_vmul_lane_u32(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmul_lane_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.2s, v0.2s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %mul = mul <2 x i32> %shuffle, %a
  ret <2 x i32> %mul
}

define <4 x i32> @test_vmulq_lane_u32(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmulq_lane_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.4s, v0.4s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %mul = mul <4 x i32> %shuffle, %a
  ret <4 x i32> %mul
}

define <4 x i16> @test_vmul_laneq_s16(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmul_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.4h, v0.4h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %mul = mul <4 x i16> %shuffle, %a
  ret <4 x i16> %mul
}

define <8 x i16> @test_vmulq_laneq_s16(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmulq_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.8h, v0.8h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  %mul = mul <8 x i16> %shuffle, %a
  ret <8 x i16> %mul
}

define <2 x i32> @test_vmul_laneq_s32(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmul_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.2s, v0.2s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %mul = mul <2 x i32> %shuffle, %a
  ret <2 x i32> %mul
}

define <4 x i32> @test_vmulq_laneq_s32(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmulq_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.4s, v0.4s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = mul <4 x i32> %shuffle, %a
  ret <4 x i32> %mul
}

define <4 x i16> @test_vmul_laneq_u16(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmul_laneq_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.4h, v0.4h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %mul = mul <4 x i16> %shuffle, %a
  ret <4 x i16> %mul
}

define <8 x i16> @test_vmulq_laneq_u16(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmulq_laneq_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.8h, v0.8h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  %mul = mul <8 x i16> %shuffle, %a
  ret <8 x i16> %mul
}

define <2 x i32> @test_vmul_laneq_u32(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmul_laneq_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.2s, v0.2s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %mul = mul <2 x i32> %shuffle, %a
  ret <2 x i32> %mul
}

define <4 x i32> @test_vmulq_laneq_u32(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmulq_laneq_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.4s, v0.4s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = mul <4 x i32> %shuffle, %a
  ret <4 x i32> %mul
}

define <2 x float> @test_vfma_lane_f32(<2 x float> %a, <2 x float> %b, <2 x float> %v) {
; GENERIC-LABEL: test_vfma_lane_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmla v0.2s, v1.2s, v2.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfma_lane_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[1]
; EXYNOSM1-NEXT:    fmla v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfma_lane_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmla v0.2s, v1.2s, v2.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> <i32 1, i32 1>
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

declare <2 x float> @llvm.fma.v2f32(<2 x float>, <2 x float>, <2 x float>)

define <4 x float> @test_vfmaq_lane_f32(<4 x float> %a, <4 x float> %b, <2 x float> %v) {
; GENERIC-LABEL: test_vfmaq_lane_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmla v0.4s, v1.4s, v2.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmaq_lane_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.4s, v2.s[1]
; EXYNOSM1-NEXT:    fmla v0.4s, v1.4s, v2.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmaq_lane_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmla v0.4s, v1.4s, v2.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x float> %v, <2 x float> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane, <4 x float> %b, <4 x float> %a)
  ret <4 x float> %0
}

declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>)

define <2 x float> @test_vfma_laneq_f32(<2 x float> %a, <2 x float> %b, <4 x float> %v) {
; GENERIC-LABEL: test_vfma_laneq_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmla v0.2s, v1.2s, v2.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfma_laneq_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[3]
; EXYNOSM1-NEXT:    fmla v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfma_laneq_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmla v0.2s, v1.2s, v2.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <4 x float> %v, <4 x float> undef, <2 x i32> <i32 3, i32 3>
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <4 x float> @test_vfmaq_laneq_f32(<4 x float> %a, <4 x float> %b, <4 x float> %v) {
; GENERIC-LABEL: test_vfmaq_laneq_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmla v0.4s, v1.4s, v2.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmaq_laneq_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.4s, v2.s[3]
; EXYNOSM1-NEXT:    fmla v0.4s, v1.4s, v2.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmaq_laneq_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmla v0.4s, v1.4s, v2.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane, <4 x float> %b, <4 x float> %a)
  ret <4 x float> %0
}

define <2 x float> @test_vfms_lane_f32(<2 x float> %a, <2 x float> %b, <2 x float> %v) {
; GENERIC-LABEL: test_vfms_lane_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmls v0.2s, v1.2s, v2.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfms_lane_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[1]
; EXYNOSM1-NEXT:    fmls v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfms_lane_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmls v0.2s, v1.2s, v2.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <2 x float> <float -0.000000e+00, float -0.000000e+00>, %v
  %lane = shufflevector <2 x float> %sub, <2 x float> undef, <2 x i32> <i32 1, i32 1>
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <4 x float> @test_vfmsq_lane_f32(<4 x float> %a, <4 x float> %b, <2 x float> %v) {
; GENERIC-LABEL: test_vfmsq_lane_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmls v0.4s, v1.4s, v2.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmsq_lane_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.4s, v2.s[1]
; EXYNOSM1-NEXT:    fmls v0.4s, v1.4s, v2.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmsq_lane_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmls v0.4s, v1.4s, v2.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <2 x float> <float -0.000000e+00, float -0.000000e+00>, %v
  %lane = shufflevector <2 x float> %sub, <2 x float> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane, <4 x float> %b, <4 x float> %a)
  ret <4 x float> %0
}

define <2 x float> @test_vfms_laneq_f32(<2 x float> %a, <2 x float> %b, <4 x float> %v) {
; GENERIC-LABEL: test_vfms_laneq_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmls v0.2s, v1.2s, v2.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfms_laneq_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[3]
; EXYNOSM1-NEXT:    fmls v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfms_laneq_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmls v0.2s, v1.2s, v2.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %v
  %lane = shufflevector <4 x float> %sub, <4 x float> undef, <2 x i32> <i32 3, i32 3>
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <4 x float> @test_vfmsq_laneq_f32(<4 x float> %a, <4 x float> %b, <4 x float> %v) {
; GENERIC-LABEL: test_vfmsq_laneq_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmls v0.4s, v1.4s, v2.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmsq_laneq_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.4s, v2.s[3]
; EXYNOSM1-NEXT:    fmls v0.4s, v1.4s, v2.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmsq_laneq_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmls v0.4s, v1.4s, v2.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %v
  %lane = shufflevector <4 x float> %sub, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane, <4 x float> %b, <4 x float> %a)
  ret <4 x float> %0
}

define <2 x double> @test_vfmaq_lane_f64(<2 x double> %a, <2 x double> %b, <1 x double> %v) {
; GENERIC-LABEL: test_vfmaq_lane_f64:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmla v0.2d, v1.2d, v2.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmaq_lane_f64:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2d, v2.d[0]
; EXYNOSM1-NEXT:    fmla v0.2d, v1.2d, v2.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmaq_lane_f64:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmla v0.2d, v1.2d, v2.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <1 x double> %v, <1 x double> undef, <2 x i32> zeroinitializer
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %lane, <2 x double> %b, <2 x double> %a)
  ret <2 x double> %0
}

declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>)

define <2 x double> @test_vfmaq_laneq_f64(<2 x double> %a, <2 x double> %b, <2 x double> %v) {
; GENERIC-LABEL: test_vfmaq_laneq_f64:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmla v0.2d, v1.2d, v2.d[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmaq_laneq_f64:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.2d, v2.d[1]
; EXYNOSM1-NEXT:    fmla v0.2d, v1.2d, v2.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmaq_laneq_f64:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmla v0.2d, v1.2d, v2.d[1]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x double> %v, <2 x double> undef, <2 x i32> <i32 1, i32 1>
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %lane, <2 x double> %b, <2 x double> %a)
  ret <2 x double> %0
}

define <2 x double> @test_vfmsq_lane_f64(<2 x double> %a, <2 x double> %b, <1 x double> %v) {
; GENERIC-LABEL: test_vfmsq_lane_f64:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmls v0.2d, v1.2d, v2.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmsq_lane_f64:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2d, v2.d[0]
; EXYNOSM1-NEXT:    fmls v0.2d, v1.2d, v2.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmsq_lane_f64:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmls v0.2d, v1.2d, v2.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <1 x double> <double -0.000000e+00>, %v
  %lane = shufflevector <1 x double> %sub, <1 x double> undef, <2 x i32> zeroinitializer
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %lane, <2 x double> %b, <2 x double> %a)
  ret <2 x double> %0
}

define <2 x double> @test_vfmsq_laneq_f64(<2 x double> %a, <2 x double> %b, <2 x double> %v) {
; GENERIC-LABEL: test_vfmsq_laneq_f64:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmls v0.2d, v1.2d, v2.d[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmsq_laneq_f64:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.2d, v2.d[1]
; EXYNOSM1-NEXT:    fmls v0.2d, v1.2d, v2.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmsq_laneq_f64:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmls v0.2d, v1.2d, v2.d[1]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %v
  %lane = shufflevector <2 x double> %sub, <2 x double> undef, <2 x i32> <i32 1, i32 1>
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %lane, <2 x double> %b, <2 x double> %a)
  ret <2 x double> %0
}

define float @test_vfmas_laneq_f32(float %a, float %b, <4 x float> %v) {
; CHECK-LABEL: test_vfmas_laneq_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmla s0, s1, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %extract = extractelement <4 x float> %v, i32 3
  %0 = tail call float @llvm.fma.f32(float %b, float %extract, float %a)
  ret float %0
}

declare float @llvm.fma.f32(float, float, float)

define double @test_vfmsd_lane_f64(double %a, double %b, <1 x double> %v) {
; CHECK-LABEL: test_vfmsd_lane_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmsub d0, d1, d2, d0
; CHECK-NEXT:    ret
entry:
  %extract.rhs = extractelement <1 x double> %v, i32 0
  %extract = fsub double -0.000000e+00, %extract.rhs
  %0 = tail call double @llvm.fma.f64(double %b, double %extract, double %a)
  ret double %0
}

declare double @llvm.fma.f64(double, double, double)

define float @test_vfmss_lane_f32(float %a, float %b, <2 x float> %v) {
; CHECK-LABEL: test_vfmss_lane_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    fmls s0, s1, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %extract.rhs = extractelement <2 x float> %v, i32 1
  %extract = fsub float -0.000000e+00, %extract.rhs
  %0 = tail call float @llvm.fma.f32(float %b, float %extract, float %a)
  ret float %0
}

define float @test_vfmss_laneq_f32(float %a, float %b, <4 x float> %v) {
; CHECK-LABEL: test_vfmss_laneq_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmls s0, s1, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %extract.rhs = extractelement <4 x float> %v, i32 3
  %extract = fsub float -0.000000e+00, %extract.rhs
  %0 = tail call float @llvm.fma.f32(float %b, float %extract, float %a)
  ret float %0
}

define double @test_vfmsd_laneq_f64(double %a, double %b, <2 x double> %v) {
; CHECK-LABEL: test_vfmsd_laneq_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmls d0, d1, v2.d[1]
; CHECK-NEXT:    ret
entry:
  %extract.rhs = extractelement <2 x double> %v, i32 1
  %extract = fsub double -0.000000e+00, %extract.rhs
  %0 = tail call double @llvm.fma.f64(double %b, double %extract, double %a)
  ret double %0
}

define double @test_vfmsd_lane_f64_0(double %a, double %b, <1 x double> %v) {
; CHECK-LABEL: test_vfmsd_lane_f64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmsub d0, d1, d2, d0
; CHECK-NEXT:    ret
entry:
  %tmp0 = fsub <1 x double> <double -0.000000e+00>, %v
  %tmp1 = extractelement <1 x double> %tmp0, i32 0
  %0 = tail call double @llvm.fma.f64(double %b, double %tmp1, double %a)
  ret double %0
}

define float @test_vfmss_lane_f32_0(float %a, float %b, <2 x float> %v) {
; CHECK-LABEL: test_vfmss_lane_f32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    fmls s0, s1, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %tmp0 = fsub <2 x float> <float -0.000000e+00, float -0.000000e+00>, %v
  %tmp1 = extractelement <2 x float> %tmp0, i32 1
  %0 = tail call float @llvm.fma.f32(float %b, float %tmp1, float %a)
  ret float %0
}

define float @test_vfmss_laneq_f32_0(float %a, float %b, <4 x float> %v) {
; CHECK-LABEL: test_vfmss_laneq_f32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmls s0, s1, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %tmp0 = fsub <4 x float><float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %v
  %tmp1 = extractelement <4 x float> %tmp0, i32 3
  %0 = tail call float @llvm.fma.f32(float %b, float %tmp1, float %a)
  ret float %0
}

define double @test_vfmsd_laneq_f64_0(double %a, double %b, <2 x double> %v) {
; CHECK-LABEL: test_vfmsd_laneq_f64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmls d0, d1, v2.d[1]
; CHECK-NEXT:    ret
entry:
  %tmp0 = fsub <2 x double><double -0.000000e+00, double -0.000000e+00>, %v
  %tmp1 = extractelement <2 x double> %tmp0, i32 1
  %0 = tail call double @llvm.fma.f64(double %b, double %tmp1, double %a)
  ret double %0
}

define <4 x i32> @test_vmlal_lane_s16(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlal_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlal v0.4s, v1.4h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_lane_s32(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlal_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlal v0.2d, v1.2s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_laneq_s16(<4 x i32> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlal_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlal v0.4s, v1.4h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_laneq_s32(<2 x i64> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlal_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlal v0.2d, v1.2s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_high_lane_s16(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlal_high_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlal2 v0.4s, v1.8h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_high_lane_s32(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlal_high_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlal2 v0.2d, v1.4s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_high_laneq_s16(<4 x i32> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlal_high_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlal2 v0.4s, v1.8h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_high_laneq_s32(<2 x i64> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlal_high_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlal2 v0.2d, v1.4s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlsl_lane_s16(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsl_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlsl v0.4s, v1.4h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_lane_s32(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsl_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlsl v0.2d, v1.2s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_laneq_s16(<4 x i32> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsl_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlsl v0.4s, v1.4h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_laneq_s32(<2 x i64> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsl_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlsl v0.2d, v1.2s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_high_lane_s16(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsl_high_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlsl2 v0.4s, v1.8h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_high_lane_s32(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsl_high_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlsl2 v0.2d, v1.4s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_high_laneq_s16(<4 x i32> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsl_high_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlsl2 v0.4s, v1.8h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_high_laneq_s32(<2 x i64> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsl_high_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlsl2 v0.2d, v1.4s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlal_lane_u16(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlal_lane_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlal v0.4s, v1.4h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_lane_u32(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlal_lane_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlal v0.2d, v1.2s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_laneq_u16(<4 x i32> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlal_laneq_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlal v0.4s, v1.4h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_laneq_u32(<2 x i64> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlal_laneq_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlal v0.2d, v1.2s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_high_lane_u16(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlal_high_lane_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlal2 v0.4s, v1.8h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_high_lane_u32(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlal_high_lane_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlal2 v0.2d, v1.4s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_high_laneq_u16(<4 x i32> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlal_high_laneq_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlal2 v0.4s, v1.8h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_high_laneq_u32(<2 x i64> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlal_high_laneq_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlal2 v0.2d, v1.4s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlsl_lane_u16(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsl_lane_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlsl v0.4s, v1.4h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_lane_u32(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsl_lane_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlsl v0.2d, v1.2s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_laneq_u16(<4 x i32> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsl_laneq_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlsl v0.4s, v1.4h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_laneq_u32(<2 x i64> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsl_laneq_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlsl v0.2d, v1.2s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_high_lane_u16(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsl_high_lane_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlsl2 v0.4s, v1.8h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_high_lane_u32(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsl_high_lane_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlsl2 v0.2d, v1.4s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_high_laneq_u16(<4 x i32> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsl_high_laneq_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlsl2 v0.4s, v1.8h, v2.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_high_laneq_u32(<2 x i64> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsl_high_laneq_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlsl2 v0.2d, v1.4s, v2.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmull_lane_s16(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmull_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    smull v0.4s, v0.4h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_lane_s32(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmull_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    smull v0.2d, v0.2s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_lane_u16(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmull_lane_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    umull v0.4s, v0.4h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_lane_u32(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmull_lane_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    umull v0.2d, v0.2s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_high_lane_s16(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmull_high_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    smull2 v0.4s, v0.8h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_high_lane_s32(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmull_high_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    smull2 v0.2d, v0.4s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_high_lane_u16(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmull_high_lane_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    umull2 v0.4s, v0.8h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_high_lane_u32(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmull_high_lane_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    umull2 v0.2d, v0.4s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_laneq_s16(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmull_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smull v0.4s, v0.4h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_laneq_s32(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmull_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smull v0.2d, v0.2s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_laneq_u16(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmull_laneq_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umull v0.4s, v0.4h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_laneq_u32(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmull_laneq_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umull v0.2d, v0.2s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_high_laneq_s16(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmull_high_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smull2 v0.4s, v0.8h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_high_laneq_s32(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmull_high_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smull2 v0.2d, v0.4s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_high_laneq_u16(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmull_high_laneq_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umull2 v0.4s, v0.8h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_high_laneq_u32(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmull_high_laneq_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umull2 v0.2d, v0.4s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vqdmlal_lane_s16(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmlal_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlal v0.4s, v1.4h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqdmlal2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %vqdmlal4.i = tail call <4 x i32> @llvm.aarch64.neon.sqadd.v4i32(<4 x i32> %a, <4 x i32> %vqdmlal2.i)
  ret <4 x i32> %vqdmlal4.i
}

define <2 x i64> @test_vqdmlal_lane_s32(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmlal_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlal v0.2d, v1.2s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vqdmlal2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %vqdmlal4.i = tail call <2 x i64> @llvm.aarch64.neon.sqadd.v2i64(<2 x i64> %a, <2 x i64> %vqdmlal2.i)
  ret <2 x i64> %vqdmlal4.i
}

define <4 x i32> @test_vqdmlal_high_lane_s16(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmlal_high_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlal2 v0.4s, v1.8h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqdmlal2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %vqdmlal4.i = tail call <4 x i32> @llvm.aarch64.neon.sqadd.v4i32(<4 x i32> %a, <4 x i32> %vqdmlal2.i)
  ret <4 x i32> %vqdmlal4.i
}

define <2 x i64> @test_vqdmlal_high_lane_s32(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmlal_high_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlal2 v0.2d, v1.4s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vqdmlal2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %vqdmlal4.i = tail call <2 x i64> @llvm.aarch64.neon.sqadd.v2i64(<2 x i64> %a, <2 x i64> %vqdmlal2.i)
  ret <2 x i64> %vqdmlal4.i
}

define <4 x i32> @test_vqdmlsl_lane_s16(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmlsl_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlsl v0.4s, v1.4h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqdmlsl2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %vqdmlsl4.i = tail call <4 x i32> @llvm.aarch64.neon.sqsub.v4i32(<4 x i32> %a, <4 x i32> %vqdmlsl2.i)
  ret <4 x i32> %vqdmlsl4.i
}

define <2 x i64> @test_vqdmlsl_lane_s32(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmlsl_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlsl v0.2d, v1.2s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vqdmlsl2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %vqdmlsl4.i = tail call <2 x i64> @llvm.aarch64.neon.sqsub.v2i64(<2 x i64> %a, <2 x i64> %vqdmlsl2.i)
  ret <2 x i64> %vqdmlsl4.i
}

define <4 x i32> @test_vqdmlsl_high_lane_s16(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmlsl_high_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlsl2 v0.4s, v1.8h, v2.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqdmlsl2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %vqdmlsl4.i = tail call <4 x i32> @llvm.aarch64.neon.sqsub.v4i32(<4 x i32> %a, <4 x i32> %vqdmlsl2.i)
  ret <4 x i32> %vqdmlsl4.i
}

define <2 x i64> @test_vqdmlsl_high_lane_s32(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmlsl_high_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlsl2 v0.2d, v1.4s, v2.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vqdmlsl2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %vqdmlsl4.i = tail call <2 x i64> @llvm.aarch64.neon.sqsub.v2i64(<2 x i64> %a, <2 x i64> %vqdmlsl2.i)
  ret <2 x i64> %vqdmlsl4.i
}

define <4 x i32> @test_vqdmull_lane_s16(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmull_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull v0.4s, v0.4h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqdmull2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vqdmull2.i
}

define <2 x i64> @test_vqdmull_lane_s32(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmull_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull v0.2d, v0.2s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vqdmull2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vqdmull2.i
}

define <4 x i32> @test_vqdmull_laneq_s16(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vqdmull_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqdmull v0.4s, v0.4h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqdmull2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vqdmull2.i
}

define <2 x i64> @test_vqdmull_laneq_s32(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vqdmull_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqdmull v0.2d, v0.2s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vqdmull2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vqdmull2.i
}

define <4 x i32> @test_vqdmull_high_lane_s16(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmull_high_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull2 v0.4s, v0.8h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqdmull2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vqdmull2.i
}

define <2 x i64> @test_vqdmull_high_lane_s32(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmull_high_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull2 v0.2d, v0.4s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vqdmull2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vqdmull2.i
}

define <4 x i32> @test_vqdmull_high_laneq_s16(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vqdmull_high_laneq_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqdmull2 v0.4s, v0.8h, v1.h[7]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
  %vqdmull2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vqdmull2.i
}

define <2 x i64> @test_vqdmull_high_laneq_s32(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vqdmull_high_laneq_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqdmull2 v0.2d, v0.4s, v1.s[3]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> <i32 3, i32 3>
  %vqdmull2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vqdmull2.i
}

define <4 x i16> @test_vqdmulh_lane_s16(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmulh_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmulh v0.4h, v0.4h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqdmulh2.i = tail call <4 x i16> @llvm.aarch64.neon.sqdmulh.v4i16(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i16> %vqdmulh2.i
}

define <8 x i16> @test_vqdmulhq_lane_s16(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmulhq_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmulh v0.8h, v0.8h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %vqdmulh2.i = tail call <8 x i16> @llvm.aarch64.neon.sqdmulh.v8i16(<8 x i16> %a, <8 x i16> %shuffle)
  ret <8 x i16> %vqdmulh2.i
}

define <2 x i32> @test_vqdmulh_lane_s32(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmulh_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmulh v0.2s, v0.2s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vqdmulh2.i = tail call <2 x i32> @llvm.aarch64.neon.sqdmulh.v2i32(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i32> %vqdmulh2.i
}

define <4 x i32> @test_vqdmulhq_lane_s32(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmulhq_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmulh v0.4s, v0.4s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %vqdmulh2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmulh.v4i32(<4 x i32> %a, <4 x i32> %shuffle)
  ret <4 x i32> %vqdmulh2.i
}

define <4 x i16> @test_vqrdmulh_lane_s16(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqrdmulh_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqrdmulh v0.4h, v0.4h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vqrdmulh2.i = tail call <4 x i16> @llvm.aarch64.neon.sqrdmulh.v4i16(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i16> %vqrdmulh2.i
}

define <8 x i16> @test_vqrdmulhq_lane_s16(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqrdmulhq_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqrdmulh v0.8h, v0.8h, v1.h[3]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %vqrdmulh2.i = tail call <8 x i16> @llvm.aarch64.neon.sqrdmulh.v8i16(<8 x i16> %a, <8 x i16> %shuffle)
  ret <8 x i16> %vqrdmulh2.i
}

define <2 x i32> @test_vqrdmulh_lane_s32(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqrdmulh_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqrdmulh v0.2s, v0.2s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %vqrdmulh2.i = tail call <2 x i32> @llvm.aarch64.neon.sqrdmulh.v2i32(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i32> %vqrdmulh2.i
}

define <4 x i32> @test_vqrdmulhq_lane_s32(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqrdmulhq_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqrdmulh v0.4s, v0.4s, v1.s[1]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %vqrdmulh2.i = tail call <4 x i32> @llvm.aarch64.neon.sqrdmulh.v4i32(<4 x i32> %a, <4 x i32> %shuffle)
  ret <4 x i32> %vqrdmulh2.i
}

define <2 x float> @test_vmul_lane_f32(<2 x float> %a, <2 x float> %v) {
; GENERIC-LABEL: test_vmul_lane_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmul v0.2s, v0.2s, v1.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmul_lane_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.2s, v1.s[1]
; EXYNOSM1-NEXT:    fmul v0.2s, v0.2s, v1.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmul_lane_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmul v0.2s, v0.2s, v1.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> <i32 1, i32 1>
  %mul = fmul <2 x float> %shuffle, %a
  ret <2 x float> %mul
}

define <1 x double> @test_vmul_lane_f64(<1 x double> %a, <1 x double> %v) {
; CHECK-LABEL: test_vmul_lane_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmul d0, d0, d1
; CHECK-NEXT:    ret
entry:
  %0 = bitcast <1 x double> %a to <8 x i8>
  %1 = bitcast <8 x i8> %0 to double
  %extract = extractelement <1 x double> %v, i32 0
  %2 = fmul double %1, %extract
  %3 = insertelement <1 x double> undef, double %2, i32 0
  ret <1 x double> %3
}

define <4 x float> @test_vmulq_lane_f32(<4 x float> %a, <2 x float> %v) {
; GENERIC-LABEL: test_vmulq_lane_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmul v0.4s, v0.4s, v1.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulq_lane_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.4s, v1.s[1]
; EXYNOSM1-NEXT:    fmul v0.4s, v0.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulq_lane_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmul v0.4s, v0.4s, v1.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x float> %v, <2 x float> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %mul = fmul <4 x float> %shuffle, %a
  ret <4 x float> %mul
}

define <2 x double> @test_vmulq_lane_f64(<2 x double> %a, <1 x double> %v) {
; GENERIC-LABEL: test_vmulq_lane_f64:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmul v0.2d, v0.2d, v1.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulq_lane_f64:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.2d, v1.d[0]
; EXYNOSM1-NEXT:    fmul v0.2d, v0.2d, v1.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulq_lane_f64:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmul v0.2d, v0.2d, v1.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <1 x double> %v, <1 x double> undef, <2 x i32> zeroinitializer
  %mul = fmul <2 x double> %shuffle, %a
  ret <2 x double> %mul
}

define <2 x float> @test_vmul_laneq_f32(<2 x float> %a, <4 x float> %v) {
; GENERIC-LABEL: test_vmul_laneq_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmul v0.2s, v0.2s, v1.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmul_laneq_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.2s, v1.s[3]
; EXYNOSM1-NEXT:    fmul v0.2s, v0.2s, v1.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmul_laneq_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmul v0.2s, v0.2s, v1.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x float> %v, <4 x float> undef, <2 x i32> <i32 3, i32 3>
  %mul = fmul <2 x float> %shuffle, %a
  ret <2 x float> %mul
}

define <1 x double> @test_vmul_laneq_f64(<1 x double> %a, <2 x double> %v) {
; CHECK-LABEL: test_vmul_laneq_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmul d0, d0, v1.d[1]
; CHECK-NEXT:    ret
entry:
  %0 = bitcast <1 x double> %a to <8 x i8>
  %1 = bitcast <8 x i8> %0 to double
  %extract = extractelement <2 x double> %v, i32 1
  %2 = fmul double %1, %extract
  %3 = insertelement <1 x double> undef, double %2, i32 0
  ret <1 x double> %3
}

define <4 x float> @test_vmulq_laneq_f32(<4 x float> %a, <4 x float> %v) {
; GENERIC-LABEL: test_vmulq_laneq_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmul v0.4s, v0.4s, v1.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulq_laneq_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.4s, v1.s[3]
; EXYNOSM1-NEXT:    fmul v0.4s, v0.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulq_laneq_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmul v0.4s, v0.4s, v1.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %mul = fmul <4 x float> %shuffle, %a
  ret <4 x float> %mul
}

define <2 x double> @test_vmulq_laneq_f64(<2 x double> %a, <2 x double> %v) {
; GENERIC-LABEL: test_vmulq_laneq_f64:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmul v0.2d, v0.2d, v1.d[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulq_laneq_f64:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.2d, v1.d[1]
; EXYNOSM1-NEXT:    fmul v0.2d, v0.2d, v1.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulq_laneq_f64:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmul v0.2d, v0.2d, v1.d[1]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x double> %v, <2 x double> undef, <2 x i32> <i32 1, i32 1>
  %mul = fmul <2 x double> %shuffle, %a
  ret <2 x double> %mul
}

define <2 x float> @test_vmulx_lane_f32(<2 x float> %a, <2 x float> %v) {
; GENERIC-LABEL: test_vmulx_lane_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmulx v0.2s, v0.2s, v1.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulx_lane_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.2s, v1.s[1]
; EXYNOSM1-NEXT:    fmulx v0.2s, v0.2s, v1.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulx_lane_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmulx v0.2s, v0.2s, v1.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> <i32 1, i32 1>
  %vmulx2.i = tail call <2 x float> @llvm.aarch64.neon.fmulx.v2f32(<2 x float> %a, <2 x float> %shuffle)
  ret <2 x float> %vmulx2.i
}

define <4 x float> @test_vmulxq_lane_f32(<4 x float> %a, <2 x float> %v) {
; GENERIC-LABEL: test_vmulxq_lane_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmulx v0.4s, v0.4s, v1.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulxq_lane_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.4s, v1.s[1]
; EXYNOSM1-NEXT:    fmulx v0.4s, v0.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulxq_lane_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmulx v0.4s, v0.4s, v1.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x float> %v, <2 x float> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %vmulx2.i = tail call <4 x float> @llvm.aarch64.neon.fmulx.v4f32(<4 x float> %a, <4 x float> %shuffle)
  ret <4 x float> %vmulx2.i
}

define <2 x double> @test_vmulxq_lane_f64(<2 x double> %a, <1 x double> %v) {
; GENERIC-LABEL: test_vmulxq_lane_f64:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmulx v0.2d, v0.2d, v1.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulxq_lane_f64:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.2d, v1.d[0]
; EXYNOSM1-NEXT:    fmulx v0.2d, v0.2d, v1.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulxq_lane_f64:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmulx v0.2d, v0.2d, v1.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <1 x double> %v, <1 x double> undef, <2 x i32> zeroinitializer
  %vmulx2.i = tail call <2 x double> @llvm.aarch64.neon.fmulx.v2f64(<2 x double> %a, <2 x double> %shuffle)
  ret <2 x double> %vmulx2.i
}

define <2 x float> @test_vmulx_laneq_f32(<2 x float> %a, <4 x float> %v) {
; GENERIC-LABEL: test_vmulx_laneq_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmulx v0.2s, v0.2s, v1.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulx_laneq_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.2s, v1.s[3]
; EXYNOSM1-NEXT:    fmulx v0.2s, v0.2s, v1.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulx_laneq_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmulx v0.2s, v0.2s, v1.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x float> %v, <4 x float> undef, <2 x i32> <i32 3, i32 3>
  %vmulx2.i = tail call <2 x float> @llvm.aarch64.neon.fmulx.v2f32(<2 x float> %a, <2 x float> %shuffle)
  ret <2 x float> %vmulx2.i
}

define <4 x float> @test_vmulxq_laneq_f32(<4 x float> %a, <4 x float> %v) {
; GENERIC-LABEL: test_vmulxq_laneq_f32:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmulx v0.4s, v0.4s, v1.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulxq_laneq_f32:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.4s, v1.s[3]
; EXYNOSM1-NEXT:    fmulx v0.4s, v0.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulxq_laneq_f32:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmulx v0.4s, v0.4s, v1.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %vmulx2.i = tail call <4 x float> @llvm.aarch64.neon.fmulx.v4f32(<4 x float> %a, <4 x float> %shuffle)
  ret <4 x float> %vmulx2.i
}

define <2 x double> @test_vmulxq_laneq_f64(<2 x double> %a, <2 x double> %v) {
; GENERIC-LABEL: test_vmulxq_laneq_f64:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmulx v0.2d, v0.2d, v1.d[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulxq_laneq_f64:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.2d, v1.d[1]
; EXYNOSM1-NEXT:    fmulx v0.2d, v0.2d, v1.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulxq_laneq_f64:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmulx v0.2d, v0.2d, v1.d[1]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x double> %v, <2 x double> undef, <2 x i32> <i32 1, i32 1>
  %vmulx2.i = tail call <2 x double> @llvm.aarch64.neon.fmulx.v2f64(<2 x double> %a, <2 x double> %shuffle)
  ret <2 x double> %vmulx2.i
}

define <4 x i16> @test_vmla_lane_s16_0(<4 x i16> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmla_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mla v0.4h, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i16> %shuffle, %b
  %add = add <4 x i16> %mul, %a
  ret <4 x i16> %add
}

define <8 x i16> @test_vmlaq_lane_s16_0(<8 x i16> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlaq_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mla v0.8h, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> zeroinitializer
  %mul = mul <8 x i16> %shuffle, %b
  %add = add <8 x i16> %mul, %a
  ret <8 x i16> %add
}

define <2 x i32> @test_vmla_lane_s32_0(<2 x i32> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmla_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mla v0.2s, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %mul = mul <2 x i32> %shuffle, %b
  %add = add <2 x i32> %mul, %a
  ret <2 x i32> %add
}

define <4 x i32> @test_vmlaq_lane_s32_0(<4 x i32> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlaq_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mla v0.4s, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i32> %shuffle, %b
  %add = add <4 x i32> %mul, %a
  ret <4 x i32> %add
}

define <4 x i16> @test_vmla_laneq_s16_0(<4 x i16> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmla_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mla v0.4h, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i16> %shuffle, %b
  %add = add <4 x i16> %mul, %a
  ret <4 x i16> %add
}

define <8 x i16> @test_vmlaq_laneq_s16_0(<8 x i16> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlaq_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mla v0.8h, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <8 x i32> zeroinitializer
  %mul = mul <8 x i16> %shuffle, %b
  %add = add <8 x i16> %mul, %a
  ret <8 x i16> %add
}

define <2 x i32> @test_vmla_laneq_s32_0(<2 x i32> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmla_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mla v0.2s, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %mul = mul <2 x i32> %shuffle, %b
  %add = add <2 x i32> %mul, %a
  ret <2 x i32> %add
}

define <4 x i32> @test_vmlaq_laneq_s32_0(<4 x i32> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlaq_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mla v0.4s, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i32> %shuffle, %b
  %add = add <4 x i32> %mul, %a
  ret <4 x i32> %add
}

define <4 x i16> @test_vmls_lane_s16_0(<4 x i16> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmls_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mls v0.4h, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i16> %shuffle, %b
  %sub = sub <4 x i16> %a, %mul
  ret <4 x i16> %sub
}

define <8 x i16> @test_vmlsq_lane_s16_0(<8 x i16> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsq_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mls v0.8h, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> zeroinitializer
  %mul = mul <8 x i16> %shuffle, %b
  %sub = sub <8 x i16> %a, %mul
  ret <8 x i16> %sub
}

define <2 x i32> @test_vmls_lane_s32_0(<2 x i32> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmls_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mls v0.2s, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %mul = mul <2 x i32> %shuffle, %b
  %sub = sub <2 x i32> %a, %mul
  ret <2 x i32> %sub
}

define <4 x i32> @test_vmlsq_lane_s32_0(<4 x i32> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsq_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mls v0.4s, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i32> %shuffle, %b
  %sub = sub <4 x i32> %a, %mul
  ret <4 x i32> %sub
}

define <4 x i16> @test_vmls_laneq_s16_0(<4 x i16> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmls_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mls v0.4h, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i16> %shuffle, %b
  %sub = sub <4 x i16> %a, %mul
  ret <4 x i16> %sub
}

define <8 x i16> @test_vmlsq_laneq_s16_0(<8 x i16> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsq_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mls v0.8h, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <8 x i32> zeroinitializer
  %mul = mul <8 x i16> %shuffle, %b
  %sub = sub <8 x i16> %a, %mul
  ret <8 x i16> %sub
}

define <2 x i32> @test_vmls_laneq_s32_0(<2 x i32> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmls_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mls v0.2s, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %mul = mul <2 x i32> %shuffle, %b
  %sub = sub <2 x i32> %a, %mul
  ret <2 x i32> %sub
}

define <4 x i32> @test_vmlsq_laneq_s32_0(<4 x i32> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsq_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mls v0.4s, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i32> %shuffle, %b
  %sub = sub <4 x i32> %a, %mul
  ret <4 x i32> %sub
}

define <4 x i16> @test_vmul_lane_s16_0(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmul_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.4h, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i16> %shuffle, %a
  ret <4 x i16> %mul
}

define <8 x i16> @test_vmulq_lane_s16_0(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmulq_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.8h, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> zeroinitializer
  %mul = mul <8 x i16> %shuffle, %a
  ret <8 x i16> %mul
}

define <2 x i32> @test_vmul_lane_s32_0(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmul_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.2s, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %mul = mul <2 x i32> %shuffle, %a
  ret <2 x i32> %mul
}

define <4 x i32> @test_vmulq_lane_s32_0(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmulq_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.4s, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i32> %shuffle, %a
  ret <4 x i32> %mul
}

define <4 x i16> @test_vmul_lane_u16_0(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmul_lane_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.4h, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i16> %shuffle, %a
  ret <4 x i16> %mul
}

define <8 x i16> @test_vmulq_lane_u16_0(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmulq_lane_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.8h, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> zeroinitializer
  %mul = mul <8 x i16> %shuffle, %a
  ret <8 x i16> %mul
}

define <2 x i32> @test_vmul_lane_u32_0(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmul_lane_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.2s, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %mul = mul <2 x i32> %shuffle, %a
  ret <2 x i32> %mul
}

define <4 x i32> @test_vmulq_lane_u32_0(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmulq_lane_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mul v0.4s, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i32> %shuffle, %a
  ret <4 x i32> %mul
}

define <4 x i16> @test_vmul_laneq_s16_0(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmul_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.4h, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i16> %shuffle, %a
  ret <4 x i16> %mul
}

define <8 x i16> @test_vmulq_laneq_s16_0(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmulq_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.8h, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <8 x i32> zeroinitializer
  %mul = mul <8 x i16> %shuffle, %a
  ret <8 x i16> %mul
}

define <2 x i32> @test_vmul_laneq_s32_0(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmul_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.2s, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %mul = mul <2 x i32> %shuffle, %a
  ret <2 x i32> %mul
}

define <4 x i32> @test_vmulq_laneq_s32_0(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmulq_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.4s, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i32> %shuffle, %a
  ret <4 x i32> %mul
}

define <4 x i16> @test_vmul_laneq_u16_0(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmul_laneq_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.4h, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i16> %shuffle, %a
  ret <4 x i16> %mul
}

define <8 x i16> @test_vmulq_laneq_u16_0(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmulq_laneq_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.8h, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <8 x i32> zeroinitializer
  %mul = mul <8 x i16> %shuffle, %a
  ret <8 x i16> %mul
}

define <2 x i32> @test_vmul_laneq_u32_0(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmul_laneq_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.2s, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %mul = mul <2 x i32> %shuffle, %a
  ret <2 x i32> %mul
}

define <4 x i32> @test_vmulq_laneq_u32_0(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmulq_laneq_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mul v0.4s, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <4 x i32> zeroinitializer
  %mul = mul <4 x i32> %shuffle, %a
  ret <4 x i32> %mul
}

define <2 x float> @test_vfma_lane_f32_0(<2 x float> %a, <2 x float> %b, <2 x float> %v) {
; GENERIC-LABEL: test_vfma_lane_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmla v0.2s, v1.2s, v2.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfma_lane_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[0]
; EXYNOSM1-NEXT:    fmla v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfma_lane_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmla v0.2s, v1.2s, v2.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> zeroinitializer
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <4 x float> @test_vfmaq_lane_f32_0(<4 x float> %a, <4 x float> %b, <2 x float> %v) {
; GENERIC-LABEL: test_vfmaq_lane_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmla v0.4s, v1.4s, v2.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmaq_lane_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.4s, v2.s[0]
; EXYNOSM1-NEXT:    fmla v0.4s, v1.4s, v2.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmaq_lane_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmla v0.4s, v1.4s, v2.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x float> %v, <2 x float> undef, <4 x i32> zeroinitializer
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane, <4 x float> %b, <4 x float> %a)
  ret <4 x float> %0
}

define <2 x float> @test_vfma_laneq_f32_0(<2 x float> %a, <2 x float> %b, <4 x float> %v) {
; GENERIC-LABEL: test_vfma_laneq_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmla v0.2s, v1.2s, v2.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfma_laneq_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[0]
; EXYNOSM1-NEXT:    fmla v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfma_laneq_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmla v0.2s, v1.2s, v2.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <4 x float> %v, <4 x float> undef, <2 x i32> zeroinitializer
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <4 x float> @test_vfmaq_laneq_f32_0(<4 x float> %a, <4 x float> %b, <4 x float> %v) {
; GENERIC-LABEL: test_vfmaq_laneq_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmla v0.4s, v1.4s, v2.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmaq_laneq_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.4s, v2.s[0]
; EXYNOSM1-NEXT:    fmla v0.4s, v1.4s, v2.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmaq_laneq_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmla v0.4s, v1.4s, v2.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> zeroinitializer
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane, <4 x float> %b, <4 x float> %a)
  ret <4 x float> %0
}

define <2 x float> @test_vfms_lane_f32_0(<2 x float> %a, <2 x float> %b, <2 x float> %v) {
; GENERIC-LABEL: test_vfms_lane_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmls v0.2s, v1.2s, v2.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfms_lane_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[0]
; EXYNOSM1-NEXT:    fmls v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfms_lane_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmls v0.2s, v1.2s, v2.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <2 x float> <float -0.000000e+00, float -0.000000e+00>, %v
  %lane = shufflevector <2 x float> %sub, <2 x float> undef, <2 x i32> zeroinitializer
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <4 x float> @test_vfmsq_lane_f32_0(<4 x float> %a, <4 x float> %b, <2 x float> %v) {
; GENERIC-LABEL: test_vfmsq_lane_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmls v0.4s, v1.4s, v2.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmsq_lane_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.4s, v2.s[0]
; EXYNOSM1-NEXT:    fmls v0.4s, v1.4s, v2.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmsq_lane_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmls v0.4s, v1.4s, v2.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <2 x float> <float -0.000000e+00, float -0.000000e+00>, %v
  %lane = shufflevector <2 x float> %sub, <2 x float> undef, <4 x i32> zeroinitializer
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane, <4 x float> %b, <4 x float> %a)
  ret <4 x float> %0
}

define <2 x float> @test_vfms_laneq_f32_0(<2 x float> %a, <2 x float> %b, <4 x float> %v) {
; GENERIC-LABEL: test_vfms_laneq_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmls v0.2s, v1.2s, v2.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfms_laneq_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[0]
; EXYNOSM1-NEXT:    fmls v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfms_laneq_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmls v0.2s, v1.2s, v2.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %v
  %lane = shufflevector <4 x float> %sub, <4 x float> undef, <2 x i32> zeroinitializer
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <4 x float> @test_vfmsq_laneq_f32_0(<4 x float> %a, <4 x float> %b, <4 x float> %v) {
; GENERIC-LABEL: test_vfmsq_laneq_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmls v0.4s, v1.4s, v2.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmsq_laneq_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.4s, v2.s[0]
; EXYNOSM1-NEXT:    fmls v0.4s, v1.4s, v2.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmsq_laneq_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmls v0.4s, v1.4s, v2.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %v
  %lane = shufflevector <4 x float> %sub, <4 x float> undef, <4 x i32> zeroinitializer
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane, <4 x float> %b, <4 x float> %a)
  ret <4 x float> %0
}

define <2 x double> @test_vfmaq_laneq_f64_0(<2 x double> %a, <2 x double> %b, <2 x double> %v) {
; GENERIC-LABEL: test_vfmaq_laneq_f64_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmla v0.2d, v1.2d, v2.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmaq_laneq_f64_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.2d, v2.d[0]
; EXYNOSM1-NEXT:    fmla v0.2d, v1.2d, v2.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmaq_laneq_f64_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmla v0.2d, v1.2d, v2.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x double> %v, <2 x double> undef, <2 x i32> zeroinitializer
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %lane, <2 x double> %b, <2 x double> %a)
  ret <2 x double> %0
}

define <2 x double> @test_vfmsq_laneq_f64_0(<2 x double> %a, <2 x double> %b, <2 x double> %v) {
; GENERIC-LABEL: test_vfmsq_laneq_f64_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmls v0.2d, v1.2d, v2.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfmsq_laneq_f64_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v2.2d, v2.d[0]
; EXYNOSM1-NEXT:    fmls v0.2d, v1.2d, v2.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfmsq_laneq_f64_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmls v0.2d, v1.2d, v2.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %sub = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %v
  %lane = shufflevector <2 x double> %sub, <2 x double> undef, <2 x i32> zeroinitializer
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %lane, <2 x double> %b, <2 x double> %a)
  ret <2 x double> %0
}

define <4 x i32> @test_vmlal_lane_s16_0(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlal_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlal v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_lane_s32_0(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlal_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlal v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_laneq_s16_0(<4 x i32> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlal_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlal v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_laneq_s32_0(<2 x i64> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlal_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlal v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_high_lane_s16_0(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlal_high_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlal2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_high_lane_s32_0(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlal_high_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlal2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_high_laneq_s16_0(<4 x i32> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlal_high_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlal2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_high_laneq_s32_0(<2 x i64> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlal_high_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlal2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlsl_lane_s16_0(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsl_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlsl v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_lane_s32_0(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsl_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlsl v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_laneq_s16_0(<4 x i32> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsl_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlsl v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_laneq_s32_0(<2 x i64> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsl_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlsl v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_high_lane_s16_0(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsl_high_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlsl2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_high_lane_s32_0(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsl_high_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    smlsl2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_high_laneq_s16_0(<4 x i32> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsl_high_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlsl2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_high_laneq_s32_0(<2 x i64> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsl_high_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smlsl2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlal_lane_u16_0(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlal_lane_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlal v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_lane_u32_0(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlal_lane_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlal v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_laneq_u16_0(<4 x i32> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlal_laneq_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlal v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_laneq_u32_0(<2 x i64> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlal_laneq_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlal v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_high_lane_u16_0(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlal_high_lane_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlal2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_high_lane_u32_0(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlal_high_lane_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlal2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlal_high_laneq_u16_0(<4 x i32> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlal_high_laneq_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlal2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %add = add <4 x i32> %vmull2.i, %a
  ret <4 x i32> %add
}

define <2 x i64> @test_vmlal_high_laneq_u32_0(<2 x i64> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlal_high_laneq_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlal2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %add = add <2 x i64> %vmull2.i, %a
  ret <2 x i64> %add
}

define <4 x i32> @test_vmlsl_lane_u16_0(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsl_lane_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlsl v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_lane_u32_0(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsl_lane_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlsl v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_laneq_u16_0(<4 x i32> %a, <4 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsl_laneq_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlsl v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_laneq_u32_0(<2 x i64> %a, <2 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsl_laneq_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlsl v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_high_lane_u16_0(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vmlsl_high_lane_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlsl2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_high_lane_u32_0(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vmlsl_high_lane_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    umlsl2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmlsl_high_laneq_u16_0(<4 x i32> %a, <8 x i16> %b, <8 x i16> %v) {
; CHECK-LABEL: test_vmlsl_high_laneq_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlsl2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %sub = sub <4 x i32> %a, %vmull2.i
  ret <4 x i32> %sub
}

define <2 x i64> @test_vmlsl_high_laneq_u32_0(<2 x i64> %a, <4 x i32> %b, <4 x i32> %v) {
; CHECK-LABEL: test_vmlsl_high_laneq_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umlsl2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %sub = sub <2 x i64> %a, %vmull2.i
  ret <2 x i64> %sub
}

define <4 x i32> @test_vmull_lane_s16_0(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmull_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    smull v0.4s, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_lane_s32_0(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmull_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    smull v0.2d, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_lane_u16_0(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmull_lane_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    umull v0.4s, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_lane_u32_0(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmull_lane_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    umull v0.2d, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_high_lane_s16_0(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmull_high_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    smull2 v0.4s, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_high_lane_s32_0(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmull_high_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    smull2 v0.2d, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_high_lane_u16_0(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vmull_high_lane_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    umull2 v0.4s, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_high_lane_u32_0(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vmull_high_lane_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    umull2 v0.2d, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_laneq_s16_0(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmull_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smull v0.4s, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_laneq_s32_0(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmull_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smull v0.2d, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_laneq_u16_0(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmull_laneq_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umull v0.4s, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_laneq_u32_0(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmull_laneq_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umull v0.2d, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_high_laneq_s16_0(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmull_high_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smull2 v0.4s, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_high_laneq_s32_0(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmull_high_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smull2 v0.2d, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.smull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vmull_high_laneq_u16_0(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vmull_high_laneq_u16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umull2 v0.4s, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vmull2.i = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vmull2.i
}

define <2 x i64> @test_vmull_high_laneq_u32_0(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vmull_high_laneq_u32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umull2 v0.2d, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vmull2.i = tail call <2 x i64> @llvm.aarch64.neon.umull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vmull2.i
}

define <4 x i32> @test_vqdmlal_lane_s16_0(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmlal_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlal v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vqdmlal2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %vqdmlal4.i = tail call <4 x i32> @llvm.aarch64.neon.sqadd.v4i32(<4 x i32> %a, <4 x i32> %vqdmlal2.i)
  ret <4 x i32> %vqdmlal4.i
}

define <2 x i64> @test_vqdmlal_lane_s32_0(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmlal_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlal v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vqdmlal2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %vqdmlal4.i = tail call <2 x i64> @llvm.aarch64.neon.sqadd.v2i64(<2 x i64> %a, <2 x i64> %vqdmlal2.i)
  ret <2 x i64> %vqdmlal4.i
}

define <4 x i32> @test_vqdmlal_high_lane_s16_0(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmlal_high_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlal2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vqdmlal2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %vqdmlal4.i = tail call <4 x i32> @llvm.aarch64.neon.sqadd.v4i32(<4 x i32> %a, <4 x i32> %vqdmlal2.i)
  ret <4 x i32> %vqdmlal4.i
}

define <2 x i64> @test_vqdmlal_high_lane_s32_0(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmlal_high_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlal2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vqdmlal2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %vqdmlal4.i = tail call <2 x i64> @llvm.aarch64.neon.sqadd.v2i64(<2 x i64> %a, <2 x i64> %vqdmlal2.i)
  ret <2 x i64> %vqdmlal4.i
}

define <4 x i32> @test_vqdmlsl_lane_s16_0(<4 x i32> %a, <4 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmlsl_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlsl v0.4s, v1.4h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vqdmlsl2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %b, <4 x i16> %shuffle)
  %vqdmlsl4.i = tail call <4 x i32> @llvm.aarch64.neon.sqsub.v4i32(<4 x i32> %a, <4 x i32> %vqdmlsl2.i)
  ret <4 x i32> %vqdmlsl4.i
}

define <2 x i64> @test_vqdmlsl_lane_s32_0(<2 x i64> %a, <2 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmlsl_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlsl v0.2d, v1.2s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vqdmlsl2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %b, <2 x i32> %shuffle)
  %vqdmlsl4.i = tail call <2 x i64> @llvm.aarch64.neon.sqsub.v2i64(<2 x i64> %a, <2 x i64> %vqdmlsl2.i)
  ret <2 x i64> %vqdmlsl4.i
}

define <4 x i32> @test_vqdmlsl_high_lane_s16_0(<4 x i32> %a, <8 x i16> %b, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmlsl_high_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlsl2 v0.4s, v1.8h, v2.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %b, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vqdmlsl2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  %vqdmlsl4.i = tail call <4 x i32> @llvm.aarch64.neon.sqsub.v4i32(<4 x i32> %a, <4 x i32> %vqdmlsl2.i)
  ret <4 x i32> %vqdmlsl4.i
}

define <2 x i64> @test_vqdmlsl_high_lane_s32_0(<2 x i64> %a, <4 x i32> %b, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmlsl_high_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    sqdmlsl2 v0.2d, v1.4s, v2.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %b, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vqdmlsl2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  %vqdmlsl4.i = tail call <2 x i64> @llvm.aarch64.neon.sqsub.v2i64(<2 x i64> %a, <2 x i64> %vqdmlsl2.i)
  ret <2 x i64> %vqdmlsl4.i
}

define <4 x i32> @test_vqdmull_lane_s16_0(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmull_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull v0.4s, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vqdmull2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vqdmull2.i
}

define <2 x i64> @test_vqdmull_lane_s32_0(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmull_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull v0.2d, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vqdmull2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vqdmull2.i
}

define <4 x i32> @test_vqdmull_laneq_s16_0(<4 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vqdmull_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqdmull v0.4s, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vqdmull2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i32> %vqdmull2.i
}

define <2 x i64> @test_vqdmull_laneq_s32_0(<2 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vqdmull_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqdmull v0.2d, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vqdmull2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i64> %vqdmull2.i
}

define <4 x i32> @test_vqdmull_high_lane_s16_0(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmull_high_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull2 v0.4s, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vqdmull2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vqdmull2.i
}

define <2 x i64> @test_vqdmull_high_lane_s32_0(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmull_high_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull2 v0.2d, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vqdmull2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vqdmull2.i
}

define <4 x i32> @test_vqdmull_high_laneq_s16_0(<8 x i16> %a, <8 x i16> %v) {
; CHECK-LABEL: test_vqdmull_high_laneq_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqdmull2 v0.4s, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle = shufflevector <8 x i16> %v, <8 x i16> undef, <4 x i32> zeroinitializer
  %vqdmull2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %shuffle.i, <4 x i16> %shuffle)
  ret <4 x i32> %vqdmull2.i
}

define <2 x i64> @test_vqdmull_high_laneq_s32_0(<4 x i32> %a, <4 x i32> %v) {
; CHECK-LABEL: test_vqdmull_high_laneq_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqdmull2 v0.2d, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle.i = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %shuffle = shufflevector <4 x i32> %v, <4 x i32> undef, <2 x i32> zeroinitializer
  %vqdmull2.i = tail call <2 x i64> @llvm.aarch64.neon.sqdmull.v2i64(<2 x i32> %shuffle.i, <2 x i32> %shuffle)
  ret <2 x i64> %vqdmull2.i
}

define <4 x i16> @test_vqdmulh_lane_s16_0(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmulh_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmulh v0.4h, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vqdmulh2.i = tail call <4 x i16> @llvm.aarch64.neon.sqdmulh.v4i16(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i16> %vqdmulh2.i
}

define <8 x i16> @test_vqdmulhq_lane_s16_0(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqdmulhq_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmulh v0.8h, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> zeroinitializer
  %vqdmulh2.i = tail call <8 x i16> @llvm.aarch64.neon.sqdmulh.v8i16(<8 x i16> %a, <8 x i16> %shuffle)
  ret <8 x i16> %vqdmulh2.i
}

define <2 x i32> @test_vqdmulh_lane_s32_0(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmulh_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmulh v0.2s, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vqdmulh2.i = tail call <2 x i32> @llvm.aarch64.neon.sqdmulh.v2i32(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i32> %vqdmulh2.i
}

define <4 x i32> @test_vqdmulhq_lane_s32_0(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqdmulhq_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmulh v0.4s, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> zeroinitializer
  %vqdmulh2.i = tail call <4 x i32> @llvm.aarch64.neon.sqdmulh.v4i32(<4 x i32> %a, <4 x i32> %shuffle)
  ret <4 x i32> %vqdmulh2.i
}

define <4 x i16> @test_vqrdmulh_lane_s16_0(<4 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqrdmulh_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqrdmulh v0.4h, v0.4h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <4 x i32> zeroinitializer
  %vqrdmulh2.i = tail call <4 x i16> @llvm.aarch64.neon.sqrdmulh.v4i16(<4 x i16> %a, <4 x i16> %shuffle)
  ret <4 x i16> %vqrdmulh2.i
}

define <8 x i16> @test_vqrdmulhq_lane_s16_0(<8 x i16> %a, <4 x i16> %v) {
; CHECK-LABEL: test_vqrdmulhq_lane_s16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqrdmulh v0.8h, v0.8h, v1.h[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x i16> %v, <4 x i16> undef, <8 x i32> zeroinitializer
  %vqrdmulh2.i = tail call <8 x i16> @llvm.aarch64.neon.sqrdmulh.v8i16(<8 x i16> %a, <8 x i16> %shuffle)
  ret <8 x i16> %vqrdmulh2.i
}

define <2 x i32> @test_vqrdmulh_lane_s32_0(<2 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqrdmulh_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqrdmulh v0.2s, v0.2s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <2 x i32> zeroinitializer
  %vqrdmulh2.i = tail call <2 x i32> @llvm.aarch64.neon.sqrdmulh.v2i32(<2 x i32> %a, <2 x i32> %shuffle)
  ret <2 x i32> %vqrdmulh2.i
}

define <4 x i32> @test_vqrdmulhq_lane_s32_0(<4 x i32> %a, <2 x i32> %v) {
; CHECK-LABEL: test_vqrdmulhq_lane_s32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqrdmulh v0.4s, v0.4s, v1.s[0]
; CHECK-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x i32> %v, <2 x i32> undef, <4 x i32> zeroinitializer
  %vqrdmulh2.i = tail call <4 x i32> @llvm.aarch64.neon.sqrdmulh.v4i32(<4 x i32> %a, <4 x i32> %shuffle)
  ret <4 x i32> %vqrdmulh2.i
}

define <2 x float> @test_vmul_lane_f32_0(<2 x float> %a, <2 x float> %v) {
; GENERIC-LABEL: test_vmul_lane_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmul v0.2s, v0.2s, v1.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmul_lane_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.2s, v1.s[0]
; EXYNOSM1-NEXT:    fmul v0.2s, v0.2s, v1.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmul_lane_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmul v0.2s, v0.2s, v1.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> zeroinitializer
  %mul = fmul <2 x float> %shuffle, %a
  ret <2 x float> %mul
}

define <4 x float> @test_vmulq_lane_f32_0(<4 x float> %a, <2 x float> %v) {
; GENERIC-LABEL: test_vmulq_lane_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmul v0.4s, v0.4s, v1.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulq_lane_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.4s, v1.s[0]
; EXYNOSM1-NEXT:    fmul v0.4s, v0.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulq_lane_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmul v0.4s, v0.4s, v1.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x float> %v, <2 x float> undef, <4 x i32> zeroinitializer
  %mul = fmul <4 x float> %shuffle, %a
  ret <4 x float> %mul
}

define <2 x float> @test_vmul_laneq_f32_0(<2 x float> %a, <4 x float> %v) {
; GENERIC-LABEL: test_vmul_laneq_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmul v0.2s, v0.2s, v1.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmul_laneq_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.2s, v1.s[0]
; EXYNOSM1-NEXT:    fmul v0.2s, v0.2s, v1.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmul_laneq_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmul v0.2s, v0.2s, v1.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x float> %v, <4 x float> undef, <2 x i32> zeroinitializer
  %mul = fmul <2 x float> %shuffle, %a
  ret <2 x float> %mul
}

define <1 x double> @test_vmul_laneq_f64_0(<1 x double> %a, <2 x double> %v) {
; CHECK-LABEL: test_vmul_laneq_f64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmul d0, d0, v1.d[0]
; CHECK-NEXT:    ret
entry:
  %0 = bitcast <1 x double> %a to <8 x i8>
  %1 = bitcast <8 x i8> %0 to double
  %extract = extractelement <2 x double> %v, i32 0
  %2 = fmul double %1, %extract
  %3 = insertelement <1 x double> undef, double %2, i32 0
  ret <1 x double> %3
}

define <4 x float> @test_vmulq_laneq_f32_0(<4 x float> %a, <4 x float> %v) {
; GENERIC-LABEL: test_vmulq_laneq_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmul v0.4s, v0.4s, v1.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulq_laneq_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.4s, v1.s[0]
; EXYNOSM1-NEXT:    fmul v0.4s, v0.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulq_laneq_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmul v0.4s, v0.4s, v1.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> zeroinitializer
  %mul = fmul <4 x float> %shuffle, %a
  ret <4 x float> %mul
}

define <2 x double> @test_vmulq_laneq_f64_0(<2 x double> %a, <2 x double> %v) {
; GENERIC-LABEL: test_vmulq_laneq_f64_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmul v0.2d, v0.2d, v1.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulq_laneq_f64_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.2d, v1.d[0]
; EXYNOSM1-NEXT:    fmul v0.2d, v0.2d, v1.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulq_laneq_f64_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmul v0.2d, v0.2d, v1.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x double> %v, <2 x double> undef, <2 x i32> zeroinitializer
  %mul = fmul <2 x double> %shuffle, %a
  ret <2 x double> %mul
}

define <2 x float> @test_vmulx_lane_f32_0(<2 x float> %a, <2 x float> %v) {
; GENERIC-LABEL: test_vmulx_lane_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmulx v0.2s, v0.2s, v1.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulx_lane_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.2s, v1.s[0]
; EXYNOSM1-NEXT:    fmulx v0.2s, v0.2s, v1.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulx_lane_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmulx v0.2s, v0.2s, v1.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> zeroinitializer
  %vmulx2.i = tail call <2 x float> @llvm.aarch64.neon.fmulx.v2f32(<2 x float> %a, <2 x float> %shuffle)
  ret <2 x float> %vmulx2.i
}

define <4 x float> @test_vmulxq_lane_f32_0(<4 x float> %a, <2 x float> %v) {
; GENERIC-LABEL: test_vmulxq_lane_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmulx v0.4s, v0.4s, v1.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulxq_lane_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.4s, v1.s[0]
; EXYNOSM1-NEXT:    fmulx v0.4s, v0.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulxq_lane_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmulx v0.4s, v0.4s, v1.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x float> %v, <2 x float> undef, <4 x i32> zeroinitializer
  %vmulx2.i = tail call <4 x float> @llvm.aarch64.neon.fmulx.v4f32(<4 x float> %a, <4 x float> %shuffle)
  ret <4 x float> %vmulx2.i
}

define <2 x double> @test_vmulxq_lane_f64_0(<2 x double> %a, <1 x double> %v) {
; GENERIC-LABEL: test_vmulxq_lane_f64_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d1 killed $d1 def $q1
; GENERIC-NEXT:    fmulx v0.2d, v0.2d, v1.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulxq_lane_f64_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM1-NEXT:    dup v1.2d, v1.d[0]
; EXYNOSM1-NEXT:    fmulx v0.2d, v0.2d, v1.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulxq_lane_f64_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d1 killed $d1 def $q1
; EXYNOSM3-NEXT:    fmulx v0.2d, v0.2d, v1.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <1 x double> %v, <1 x double> undef, <2 x i32> zeroinitializer
  %vmulx2.i = tail call <2 x double> @llvm.aarch64.neon.fmulx.v2f64(<2 x double> %a, <2 x double> %shuffle)
  ret <2 x double> %vmulx2.i
}

define <2 x float> @test_vmulx_laneq_f32_0(<2 x float> %a, <4 x float> %v) {
; GENERIC-LABEL: test_vmulx_laneq_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmulx v0.2s, v0.2s, v1.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulx_laneq_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.2s, v1.s[0]
; EXYNOSM1-NEXT:    fmulx v0.2s, v0.2s, v1.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulx_laneq_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmulx v0.2s, v0.2s, v1.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x float> %v, <4 x float> undef, <2 x i32> zeroinitializer
  %vmulx2.i = tail call <2 x float> @llvm.aarch64.neon.fmulx.v2f32(<2 x float> %a, <2 x float> %shuffle)
  ret <2 x float> %vmulx2.i
}

define <4 x float> @test_vmulxq_laneq_f32_0(<4 x float> %a, <4 x float> %v) {
; GENERIC-LABEL: test_vmulxq_laneq_f32_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmulx v0.4s, v0.4s, v1.s[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulxq_laneq_f32_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.4s, v1.s[0]
; EXYNOSM1-NEXT:    fmulx v0.4s, v0.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulxq_laneq_f32_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmulx v0.4s, v0.4s, v1.s[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> zeroinitializer
  %vmulx2.i = tail call <4 x float> @llvm.aarch64.neon.fmulx.v4f32(<4 x float> %a, <4 x float> %shuffle)
  ret <4 x float> %vmulx2.i
}

define <2 x double> @test_vmulxq_laneq_f64_0(<2 x double> %a, <2 x double> %v) {
; GENERIC-LABEL: test_vmulxq_laneq_f64_0:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmulx v0.2d, v0.2d, v1.d[0]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vmulxq_laneq_f64_0:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v1.2d, v1.d[0]
; EXYNOSM1-NEXT:    fmulx v0.2d, v0.2d, v1.2d
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vmulxq_laneq_f64_0:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmulx v0.2d, v0.2d, v1.d[0]
; EXYNOSM3-NEXT:    ret
entry:
  %shuffle = shufflevector <2 x double> %v, <2 x double> undef, <2 x i32> zeroinitializer
  %vmulx2.i = tail call <2 x double> @llvm.aarch64.neon.fmulx.v2f64(<2 x double> %a, <2 x double> %shuffle)
  ret <2 x double> %vmulx2.i
}

define <4 x float> @optimize_dup(<4 x float> %a, <4 x float> %b, <4 x float> %c, <4 x float> %v) {
; GENERIC-LABEL: optimize_dup:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmla v0.4s, v1.4s, v3.s[3]
; GENERIC-NEXT:    fmls v0.4s, v2.4s, v3.s[3]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: optimize_dup:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v3.4s, v3.s[3]
; EXYNOSM1-NEXT:    fmla v0.4s, v1.4s, v3.4s
; EXYNOSM1-NEXT:    fmls v0.4s, v2.4s, v3.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: optimize_dup:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmla v0.4s, v1.4s, v3.s[3]
; EXYNOSM3-NEXT:    fmls v0.4s, v2.4s, v3.s[3]
; EXYNOSM3-NEXT:    ret
entry:
  %lane1 = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane1, <4 x float> %b, <4 x float> %a)
  %lane2 = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
	%1 = fmul <4 x float> %lane2, %c
	%s = fsub <4 x float> %0, %1
  ret <4 x float> %s
}

define <4 x float> @no_optimize_dup(<4 x float> %a, <4 x float> %b, <4 x float> %c, <4 x float> %v) {
; GENERIC-LABEL: no_optimize_dup:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    fmla v0.4s, v1.4s, v3.s[3]
; GENERIC-NEXT:    fmls v0.4s, v2.4s, v3.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: no_optimize_dup:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    dup v4.4s, v3.s[3]
; EXYNOSM1-NEXT:    fmla v0.4s, v1.4s, v4.4s
; EXYNOSM1-NEXT:    dup v1.4s, v3.s[1]
; EXYNOSM1-NEXT:    fmls v0.4s, v2.4s, v1.4s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: no_optimize_dup:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    fmla v0.4s, v1.4s, v3.s[3]
; EXYNOSM3-NEXT:    fmls v0.4s, v2.4s, v3.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %lane1 = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %lane1, <4 x float> %b, <4 x float> %a)
  %lane2 = shufflevector <4 x float> %v, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
	%1 = fmul <4 x float> %lane2, %c
	%s = fsub <4 x float> %0, %1
  ret <4 x float> %s
}

define <2 x float> @test_vfma_lane_simdinstr_opt_pass_caching_a57(<2 x float> %a, <2 x float> %b, <2 x float> %v) "target-cpu"="cortex-a57" {
; GENERIC-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_a57:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmla v0.2s, v1.2s, v2.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_a57:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[1]
; EXYNOSM1-NEXT:    fmla v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_a57:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmla v0.2s, v1.2s, v2.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> <i32 1, i32 1>
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <2 x float> @test_vfma_lane_simdinstr_opt_pass_caching_m1(<2 x float> %a, <2 x float> %b, <2 x float> %v) "target-cpu"="exynos-m1" {
; GENERIC-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_m1:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    dup v2.2s, v2.s[1]
; GENERIC-NEXT:    fmla v0.2s, v1.2s, v2.2s
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_m1:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[1]
; EXYNOSM1-NEXT:    fmla v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_m1:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmla v0.2s, v1.2s, v2.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> <i32 1, i32 1>
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}

define <2 x float> @test_vfma_lane_simdinstr_opt_pass_caching_m3(<2 x float> %a, <2 x float> %b, <2 x float> %v) "target-cpu"="exynos-m3" {
; GENERIC-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_m3:
; GENERIC:       // %bb.0: // %entry
; GENERIC-NEXT:    // kill: def $d2 killed $d2 def $q2
; GENERIC-NEXT:    fmla v0.2s, v1.2s, v2.s[1]
; GENERIC-NEXT:    ret
;
; EXYNOSM1-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_m3:
; EXYNOSM1:       // %bb.0: // %entry
; EXYNOSM1-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM1-NEXT:    dup v2.2s, v2.s[1]
; EXYNOSM1-NEXT:    fmla v0.2s, v1.2s, v2.2s
; EXYNOSM1-NEXT:    ret
;
; EXYNOSM3-LABEL: test_vfma_lane_simdinstr_opt_pass_caching_m3:
; EXYNOSM3:       // %bb.0: // %entry
; EXYNOSM3-NEXT:    // kill: def $d2 killed $d2 def $q2
; EXYNOSM3-NEXT:    fmla v0.2s, v1.2s, v2.s[1]
; EXYNOSM3-NEXT:    ret
entry:
  %lane = shufflevector <2 x float> %v, <2 x float> undef, <2 x i32> <i32 1, i32 1>
  %0 = tail call <2 x float> @llvm.fma.v2f32(<2 x float> %lane, <2 x float> %b, <2 x float> %a)
  ret <2 x float> %0
}
