; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -aggressive-instcombine -S | FileCheck %s
; RUN: opt < %s -passes=aggressive-instcombine -S | FileCheck %s

define dso_local i16 @cmp_select_sext_const(i8 %a) {
; CHECK-LABEL: @cmp_select_sext_const(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV]], 109
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 109, i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
entry:
  %conv = sext i8 %a to i32
  %cmp = icmp slt i32 %conv, 109
  %cond = select i1 %cmp, i32 109, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define dso_local i16 @cmp_select_sext(i8 %a, i8 %b) {
; CHECK-LABEL: @cmp_select_sext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CONV2:%.*]] = sext i8 [[B:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV]], [[CONV2]]
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 [[CONV2]], i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
entry:
  %conv = sext i8 %a to i32
  %conv2 = sext i8 %b to i32
  %cmp = icmp slt i32 %conv, %conv2
  %cond = select i1 %cmp, i32 %conv2, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define dso_local i16 @cmp_select_zext(i8 %a, i8 %b) {
; CHECK-LABEL: @cmp_select_zext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[B:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV]], [[CONV2]]
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 [[CONV2]], i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
entry:
  %conv = zext i8 %a to i32
  %conv2 = zext i8 %b to i32
  %cmp = icmp slt i32 %conv, %conv2
  %cond = select i1 %cmp, i32 %conv2, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define dso_local i16 @cmp_select_zext_sext(i8 %a, i8 %b) {
; CHECK-LABEL: @cmp_select_zext_sext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CONV2:%.*]] = sext i8 [[B:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV]], [[CONV2]]
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 [[CONV2]], i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
entry:
  %conv = zext i8 %a to i32
  %conv2 = sext i8 %b to i32
  %cmp = icmp slt i32 %conv, %conv2
  %cond = select i1 %cmp, i32 %conv2, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define dso_local i16 @cmp_select_zext_sext_diffOrigTy(i8 %a, i16 %b) {
; CHECK-LABEL: @cmp_select_zext_sext_diffOrigTy(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CONV2:%.*]] = sext i16 [[B:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV]], [[CONV2]]
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 [[CONV2]], i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
entry:
  %conv = zext i8 %a to i32
  %conv2 = sext i16 %b to i32
  %cmp = icmp slt i32 %conv, %conv2
  %cond = select i1 %cmp, i32 %conv2, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define dso_local i16 @my_abs_sext(i8 %a) {
; CHECK-LABEL: @my_abs_sext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV]], 0
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 0, [[CONV]]
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 [[SUB]], i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
entry:
  %conv = sext i8 %a to i32
  %cmp = icmp slt i32 %conv, 0
  %sub = sub nsw i32 0, %conv
  %cond = select i1 %cmp, i32 %sub, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define dso_local i16 @my_abs_zext(i8 %a) {
; CHECK-LABEL: @my_abs_zext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV]], 0
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 0, [[CONV]]
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 [[SUB]], i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
entry:
  %conv = zext i8 %a to i32
  %cmp = icmp slt i32 %conv, 0
  %sub = sub nsw i32 0, %conv
  %cond = select i1 %cmp, i32 %sub, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define dso_local i16 @select_sext(i8 %a, i1 %cond) {
; CHECK-LABEL: @select_sext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[A:%.*]] to i16
; CHECK-NEXT:    [[SUB:%.*]] = sub i16 0, [[CONV]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND:%.*]], i16 [[SUB]], i16 [[CONV]]
; CHECK-NEXT:    ret i16 [[SEL]]
;
entry:
  %conv = sext i8 %a to i32
  %sub = sub nsw i32 0, %conv
  %sel = select i1 %cond, i32 %sub, i32 %conv
  %conv4 = trunc i32 %sel to i16
  ret i16 %conv4
}

define dso_local i16 @select_zext(i8 %a, i1 %cond) {
; CHECK-LABEL: @select_zext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[A:%.*]] to i16
; CHECK-NEXT:    [[SUB:%.*]] = sub i16 0, [[CONV]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND:%.*]], i16 [[SUB]], i16 [[CONV]]
; CHECK-NEXT:    ret i16 [[SEL]]
;
entry:
  %conv = zext i8 %a to i32
  %sub = sub nsw i32 0, %conv
  %sel = select i1 %cond, i32 %sub, i32 %conv
  %conv4 = trunc i32 %sel to i16
  ret i16 %conv4
}

define i16 @cmp_select_signed_const_i16Const_noTransformation(i8 %a) {
; CHECK-LABEL: @cmp_select_signed_const_i16Const_noTransformation(
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV]], 32768
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 32768, i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
  %conv = sext i8 %a to i32
  %cmp = icmp slt i32 %conv, 32768
  %cond = select i1 %cmp, i32 32768, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define i16 @cmp_select_unsigned_const_i16Const(i8 %a) {
; CHECK-LABEL: @cmp_select_unsigned_const_i16Const(
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[CONV]], 32768
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 32768, i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
  %conv = zext i8 %a to i32
  %cmp = icmp ult i32 %conv, 32768
  %cond = select i1 %cmp, i32 32768, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

define i16 @cmp_select_unsigned_const_i16Const_noTransformation(i8 %a) {
; CHECK-LABEL: @cmp_select_unsigned_const_i16Const_noTransformation(
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[CONV]], 65536
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i32 65536, i32 [[CONV]]
; CHECK-NEXT:    [[CONV4:%.*]] = trunc i32 [[COND]] to i16
; CHECK-NEXT:    ret i16 [[CONV4]]
;
  %conv = zext i8 %a to i32
  %cmp = icmp ult i32 %conv, 65536
  %cond = select i1 %cmp, i32 65536, i32 %conv
  %conv4 = trunc i32 %cond to i16
  ret i16 %conv4
}

