/////////////////////////////////////////////////////////////////////////////
// Name:        wx/language.h
// Purpose:     wxLanguage enum
// Author:      Vadim Zeitlin
// Created:     2010-04-23
// Copyright:   (c) 1998 Vadim Zeitlin <zeitlin@dptmaths.ens-cachan.fr>
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

// WARNING: Parts of this file are generated. See misc/languages/README for
// details.

#ifndef _WX_LANGUAGE_H_
#define _WX_LANGUAGE_H_

#include "wx/defs.h"

#if wxUSE_INTL

// ----------------------------------------------------------------------------
// wxLanguage: defines all supported languages
// ----------------------------------------------------------------------------

// --- --- --- generated code begins here --- --- ---

/**
    The languages supported by wxLocale.

    This enum is generated by misc/languages/genlang.py
    When making changes, please put them into misc/languages/langtabl.txt
*/
enum wxLanguage
{
    /// User's default/preferred language as got from OS.
    wxLANGUAGE_DEFAULT,

    /// Unknown language, returned if wxLocale::GetSystemLanguage fails.
    wxLANGUAGE_UNKNOWN,

    wxLANGUAGE_ABKHAZIAN,
    wxLANGUAGE_AFAR,
    wxLANGUAGE_AFAR_DJIBOUTI,
    wxLANGUAGE_AFAR_ERITREA,
    wxLANGUAGE_AFAR_ETHIOPIA,
    wxLANGUAGE_AFRIKAANS,
    wxLANGUAGE_AFRIKAANS_NAMIBIA,
    wxLANGUAGE_AFRIKAANS_SOUTH_AFRICA,
    wxLANGUAGE_AGHEM,
    wxLANGUAGE_AGHEM_CAMEROON,
    wxLANGUAGE_AKAN,
    wxLANGUAGE_AKAN_GHANA,
    wxLANGUAGE_ALBANIAN,
    wxLANGUAGE_ALBANIAN_ALBANIA,
    wxLANGUAGE_ALBANIAN_KOSOVO,
    wxLANGUAGE_ALBANIAN_NORTH_MACEDONIA,
    wxLANGUAGE_ALSATIAN_FRANCE,
    wxLANGUAGE_AMHARIC,
    wxLANGUAGE_AMHARIC_ETHIOPIA,
    wxLANGUAGE_ARABIC,
    wxLANGUAGE_ARABIC_ALGERIA,
    wxLANGUAGE_ARABIC_BAHRAIN,
    wxLANGUAGE_ARABIC_CHAD,
    wxLANGUAGE_ARABIC_COMOROS,
    wxLANGUAGE_ARABIC_DJIBOUTI,
    wxLANGUAGE_ARABIC_EGYPT,
    wxLANGUAGE_ARABIC_ERITREA,
    wxLANGUAGE_ARABIC_IRAQ,
    wxLANGUAGE_ARABIC_ISRAEL,
    wxLANGUAGE_ARABIC_JORDAN,
    wxLANGUAGE_ARABIC_KUWAIT,
    wxLANGUAGE_ARABIC_LEBANON,
    wxLANGUAGE_ARABIC_LIBYA,
    wxLANGUAGE_ARABIC_MAURITANIA,
    wxLANGUAGE_ARABIC_MOROCCO,
    wxLANGUAGE_ARABIC_OMAN,
    wxLANGUAGE_ARABIC_PALESTINIAN_AUTHORITY,
    wxLANGUAGE_ARABIC_QATAR,
    wxLANGUAGE_ARABIC_SAUDI_ARABIA,
    wxLANGUAGE_ARABIC_SOMALIA,
    wxLANGUAGE_ARABIC_SOUTH_SUDAN,
    wxLANGUAGE_ARABIC_SUDAN,
    wxLANGUAGE_ARABIC_SYRIA,
    wxLANGUAGE_ARABIC_TUNISIA,
    wxLANGUAGE_ARABIC_UAE,
    wxLANGUAGE_ARABIC_WORLD,
    wxLANGUAGE_ARABIC_YEMEN,
    wxLANGUAGE_ARMENIAN,
    wxLANGUAGE_ARMENIAN_ARMENIA,
    wxLANGUAGE_ASSAMESE,
    wxLANGUAGE_ASSAMESE_INDIA,
    wxLANGUAGE_ASTURIAN,
    wxLANGUAGE_ASTURIAN_SPAIN,
    wxLANGUAGE_ASU,
    wxLANGUAGE_ASU_TANZANIA,
    wxLANGUAGE_AYMARA,
    wxLANGUAGE_AZERBAIJANI,
    wxLANGUAGE_AZERBAIJANI_CYRILLIC,
    wxLANGUAGE_AZERBAIJANI_CYRILLIC_AZERBAIJAN,
    wxLANGUAGE_AZERBAIJANI_LATIN,
    wxLANGUAGE_AZERBAIJANI_LATIN_AZERBAIJAN,
    wxLANGUAGE_BAFIA,
    wxLANGUAGE_BAFIA_CAMEROON,
    wxLANGUAGE_BAMANANKAN,
    wxLANGUAGE_BAMANANKAN_LATIN,
    wxLANGUAGE_BAMANANKAN_LATIN_MALI,
    wxLANGUAGE_BANGLA,
    wxLANGUAGE_BANGLA_BANGLADESH,
    wxLANGUAGE_BANGLA_INDIA,
    wxLANGUAGE_BASAA,
    wxLANGUAGE_BASAA_CAMEROON,
    wxLANGUAGE_BASHKIR,
    wxLANGUAGE_BASHKIR_RUSSIA,
    wxLANGUAGE_BASQUE,
    wxLANGUAGE_BASQUE_SPAIN,
    wxLANGUAGE_BELARUSIAN,
    wxLANGUAGE_BELARUSIAN_BELARUS,
    wxLANGUAGE_BEMBA,
    wxLANGUAGE_BEMBA_ZAMBIA,
    wxLANGUAGE_BENA,
    wxLANGUAGE_BENA_TANZANIA,
    wxLANGUAGE_BIHARI,
    wxLANGUAGE_BISLAMA,
    wxLANGUAGE_BLIN,
    wxLANGUAGE_BLIN_ERITREA,
    wxLANGUAGE_BODO,
    wxLANGUAGE_BODO_INDIA,
    wxLANGUAGE_BOSNIAN,
    wxLANGUAGE_BOSNIAN_CYRILLIC,
    wxLANGUAGE_BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA,
    wxLANGUAGE_BOSNIAN_LATIN,
    wxLANGUAGE_BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA,
    wxLANGUAGE_BRETON,
    wxLANGUAGE_BRETON_FRANCE,
    wxLANGUAGE_BULGARIAN,
    wxLANGUAGE_BULGARIAN_BULGARIA,
    wxLANGUAGE_BURMESE,
    wxLANGUAGE_BURMESE_MYANMAR,
    wxLANGUAGE_CATALAN,
    wxLANGUAGE_CATALAN_ANDORRA,
    wxLANGUAGE_CATALAN_FRANCE,
    wxLANGUAGE_CATALAN_ITALY,
    wxLANGUAGE_CATALAN_SPAIN,
    wxLANGUAGE_CEBUANO,
    wxLANGUAGE_CEBUANO_LATIN,
    wxLANGUAGE_CEBUANO_LATIN_PHILIPPINES,
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT,
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC,
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC_MOROCCO,
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN,
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_ALGERIA,
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_MOROCCO,
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH,
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH_MOROCCO,
    wxLANGUAGE_CENTRAL_KURDISH,
    wxLANGUAGE_CENTRAL_KURDISH_IRAQ,
    wxLANGUAGE_CHAKMA,
    wxLANGUAGE_CHAKMA_CHAKMA,
    wxLANGUAGE_CHAKMA_CHAKMA_BANGLADESH,
    wxLANGUAGE_CHAKMA_CHAKMA_INDIA,
    wxLANGUAGE_CHECHEN,
    wxLANGUAGE_CHECHEN_RUSSIA,
    wxLANGUAGE_CHEROKEE,
    wxLANGUAGE_CHEROKEE_CHEROKEE,
    wxLANGUAGE_CHEROKEE_US,
    wxLANGUAGE_CHIGA,
    wxLANGUAGE_CHIGA_UGANDA,
    wxLANGUAGE_CHINESE,
    wxLANGUAGE_CHINESE_CHINA,
    wxLANGUAGE_CHINESE_HONGKONG,
    wxLANGUAGE_CHINESE_MACAO,
    wxLANGUAGE_CHINESE_SIMPLIFIED_EXPLICIT,
    wxLANGUAGE_CHINESE_SIMPLIFIED_HONGKONG,
    wxLANGUAGE_CHINESE_SIMPLIFIED_MACAO,
    wxLANGUAGE_CHINESE_SINGAPORE,
    wxLANGUAGE_CHINESE_TAIWAN,
    wxLANGUAGE_CHINESE_TRADITIONAL_EXPLICIT,
    wxLANGUAGE_CHURCH_SLAVIC,
    wxLANGUAGE_CHURCH_SLAVIC_RUSSIA,
    wxLANGUAGE_COLOGNIAN,
    wxLANGUAGE_COLOGNIAN_GERMANY,
    wxLANGUAGE_CORNISH,
    wxLANGUAGE_CORNISH_UK,
    wxLANGUAGE_CORSICAN,
    wxLANGUAGE_CORSICAN_FRANCE,
    wxLANGUAGE_CROATIAN,
    wxLANGUAGE_CROATIAN_BOSNIA_AND_HERZEGOVINA,
    wxLANGUAGE_CROATIAN_CROATIA,
    wxLANGUAGE_CZECH,
    wxLANGUAGE_CZECH_CZECHIA,
    wxLANGUAGE_DANISH,
    wxLANGUAGE_DANISH_DENMARK,
    wxLANGUAGE_DANISH_GREENLAND,
    wxLANGUAGE_DARI,
    wxLANGUAGE_DARI_AFGHANISTAN,
    wxLANGUAGE_DIVEHI,
    wxLANGUAGE_DIVEHI_MALDIVES,
    wxLANGUAGE_DUALA,
    wxLANGUAGE_DUALA_CAMEROON,
    wxLANGUAGE_DUTCH,
    wxLANGUAGE_DUTCH_ARUBA,
    wxLANGUAGE_DUTCH_BELGIAN,
    wxLANGUAGE_DUTCH_BONAIRE_SINT_EUSTATIUS_AND_SABA,
    wxLANGUAGE_DUTCH_CURACAO,
    wxLANGUAGE_DUTCH_NETHERLANDS,
    wxLANGUAGE_DUTCH_SINT_MAARTEN,
    wxLANGUAGE_DUTCH_SURINAME,
    wxLANGUAGE_DZONGKHA,
    wxLANGUAGE_DZONGKHA_BHUTAN,
    wxLANGUAGE_EDO,
    wxLANGUAGE_EDO_NIGERIA,
    wxLANGUAGE_EMBU,
    wxLANGUAGE_EMBU_KENYA,
    wxLANGUAGE_ENGLISH,
    wxLANGUAGE_ENGLISH_AMERICAN_SAMOA,
    wxLANGUAGE_ENGLISH_ANGUILLA,
    wxLANGUAGE_ENGLISH_ANTIGUA_AND_BARBUDA,
    wxLANGUAGE_ENGLISH_AUSTRALIA,
    wxLANGUAGE_ENGLISH_AUSTRIA,
    wxLANGUAGE_ENGLISH_BAHAMAS,
    wxLANGUAGE_ENGLISH_BARBADOS,
    wxLANGUAGE_ENGLISH_BELGIUM,
    wxLANGUAGE_ENGLISH_BELIZE,
    wxLANGUAGE_ENGLISH_BERMUDA,
    wxLANGUAGE_ENGLISH_BOTSWANA,
    wxLANGUAGE_ENGLISH_BRITISH_INDIAN_OCEAN_TERRITORY,
    wxLANGUAGE_ENGLISH_BRITISH_VIRGIN_ISLANDS,
    wxLANGUAGE_ENGLISH_BURUNDI,
    wxLANGUAGE_ENGLISH_CAMEROON,
    wxLANGUAGE_ENGLISH_CANADA,
    wxLANGUAGE_ENGLISH_CARIBBEAN,
    wxLANGUAGE_ENGLISH_CARIBBEAN_CB,
    wxLANGUAGE_ENGLISH_CAYMAN_ISLANDS,
    wxLANGUAGE_ENGLISH_CHRISTMAS_ISLAND,
    wxLANGUAGE_ENGLISH_COCOS_KEELING_ISLANDS,
    wxLANGUAGE_ENGLISH_COOK_ISLANDS,
    wxLANGUAGE_ENGLISH_CYPRUS,
    wxLANGUAGE_ENGLISH_DENMARK,
    wxLANGUAGE_ENGLISH_DOMINICA,
    wxLANGUAGE_ENGLISH_EIRE,
    wxLANGUAGE_ENGLISH_ERITREA,
    wxLANGUAGE_ENGLISH_ESWATINI,
    wxLANGUAGE_ENGLISH_EUROPE,
    wxLANGUAGE_ENGLISH_FALKLAND_ISLANDS,
    wxLANGUAGE_ENGLISH_FIJI,
    wxLANGUAGE_ENGLISH_FINLAND,
    wxLANGUAGE_ENGLISH_GAMBIA,
    wxLANGUAGE_ENGLISH_GERMANY,
    wxLANGUAGE_ENGLISH_GHANA,
    wxLANGUAGE_ENGLISH_GIBRALTAR,
    wxLANGUAGE_ENGLISH_GRENADA,
    wxLANGUAGE_ENGLISH_GUAM,
    wxLANGUAGE_ENGLISH_GUERNSEY,
    wxLANGUAGE_ENGLISH_GUYANA,
    wxLANGUAGE_ENGLISH_HONG_KONG_SAR,
    wxLANGUAGE_ENGLISH_INDIA,
    wxLANGUAGE_ENGLISH_INDONESIA,
    wxLANGUAGE_ENGLISH_ISLE_OF_MAN,
    wxLANGUAGE_ENGLISH_ISRAEL,
    wxLANGUAGE_ENGLISH_JAMAICA,
    wxLANGUAGE_ENGLISH_JERSEY,
    wxLANGUAGE_ENGLISH_KENYA,
    wxLANGUAGE_ENGLISH_KIRIBATI,
    wxLANGUAGE_ENGLISH_LESOTHO,
    wxLANGUAGE_ENGLISH_LIBERIA,
    wxLANGUAGE_ENGLISH_MACAO_SAR,
    wxLANGUAGE_ENGLISH_MADAGASCAR,
    wxLANGUAGE_ENGLISH_MALAWI,
    wxLANGUAGE_ENGLISH_MALAYSIA,
    wxLANGUAGE_ENGLISH_MALTA,
    wxLANGUAGE_ENGLISH_MARSHALL_ISLANDS,
    wxLANGUAGE_ENGLISH_MAURITIUS,
    wxLANGUAGE_ENGLISH_MICRONESIA,
    wxLANGUAGE_ENGLISH_MONTSERRAT,
    wxLANGUAGE_ENGLISH_NAMIBIA,
    wxLANGUAGE_ENGLISH_NAURU,
    wxLANGUAGE_ENGLISH_NETHERLANDS,
    wxLANGUAGE_ENGLISH_NEW_ZEALAND,
    wxLANGUAGE_ENGLISH_NIGERIA,
    wxLANGUAGE_ENGLISH_NIUE,
    wxLANGUAGE_ENGLISH_NORFOLK_ISLAND,
    wxLANGUAGE_ENGLISH_NORTHERN_MARIANA_ISLANDS,
    wxLANGUAGE_ENGLISH_PAKISTAN,
    wxLANGUAGE_ENGLISH_PALAU,
    wxLANGUAGE_ENGLISH_PAPUA_NEW_GUINEA,
    wxLANGUAGE_ENGLISH_PHILIPPINES,
    wxLANGUAGE_ENGLISH_PITCAIRN_ISLANDS,
    wxLANGUAGE_ENGLISH_PUERTO_RICO,
    wxLANGUAGE_ENGLISH_RWANDA,
    wxLANGUAGE_ENGLISH_SAMOA,
    wxLANGUAGE_ENGLISH_SEYCHELLES,
    wxLANGUAGE_ENGLISH_SIERRA_LEONE,
    wxLANGUAGE_ENGLISH_SINGAPORE,
    wxLANGUAGE_ENGLISH_SINT_MAARTEN,
    wxLANGUAGE_ENGLISH_SLOVENIA,
    wxLANGUAGE_ENGLISH_SOLOMON_ISLANDS,
    wxLANGUAGE_ENGLISH_SOUTH_AFRICA,
    wxLANGUAGE_ENGLISH_SOUTH_SUDAN,
    wxLANGUAGE_ENGLISH_ST_HELENA_ASCENSION_TRISTAN_DA_CUNHA,
    wxLANGUAGE_ENGLISH_ST_KITTS_AND_NEVIS,
    wxLANGUAGE_ENGLISH_ST_LUCIA,
    wxLANGUAGE_ENGLISH_ST_VINCENT_AND_GRENADINES,
    wxLANGUAGE_ENGLISH_SUDAN,
    wxLANGUAGE_ENGLISH_SWEDEN,
    wxLANGUAGE_ENGLISH_SWITZERLAND,
    wxLANGUAGE_ENGLISH_TANZANIA,
    wxLANGUAGE_ENGLISH_TOKELAU,
    wxLANGUAGE_ENGLISH_TONGA,
    wxLANGUAGE_ENGLISH_TRINIDAD,
    wxLANGUAGE_ENGLISH_TURKS_AND_CAICOS_ISLANDS,
    wxLANGUAGE_ENGLISH_TUVALU,
    wxLANGUAGE_ENGLISH_UGANDA,
    wxLANGUAGE_ENGLISH_UK,
    wxLANGUAGE_ENGLISH_UNITED_ARAB_EMIRATES,
    wxLANGUAGE_ENGLISH_US,
    wxLANGUAGE_ENGLISH_US_OUTLYING_ISLANDS,
    wxLANGUAGE_ENGLISH_US_VIRGIN_ISLANDS,
    wxLANGUAGE_ENGLISH_VANUATU,
    wxLANGUAGE_ENGLISH_WORLD,
    wxLANGUAGE_ENGLISH_ZAMBIA,
    wxLANGUAGE_ENGLISH_ZIMBABWE,
    wxLANGUAGE_ESPERANTO,
    wxLANGUAGE_ESPERANTO_WORLD,
    wxLANGUAGE_ESTONIAN,
    wxLANGUAGE_ESTONIAN_ESTONIA,
    wxLANGUAGE_EWE,
    wxLANGUAGE_EWE_GHANA,
    wxLANGUAGE_EWE_TOGO,
    wxLANGUAGE_EWONDO,
    wxLANGUAGE_EWONDO_CAMEROON,
    wxLANGUAGE_FAEROESE,
    wxLANGUAGE_FAEROESE_DENMARK,
    wxLANGUAGE_FAEROESE_FAROE_ISLANDS,
    wxLANGUAGE_FARSI,
    wxLANGUAGE_FIJI,
    wxLANGUAGE_FILIPINO,
    wxLANGUAGE_FILIPINO_PHILIPPINES,
    wxLANGUAGE_FINNISH,
    wxLANGUAGE_FINNISH_FINLAND,
    wxLANGUAGE_FRENCH,
    wxLANGUAGE_FRENCH_ALGERIA,
    wxLANGUAGE_FRENCH_BELGIAN,
    wxLANGUAGE_FRENCH_BENIN,
    wxLANGUAGE_FRENCH_BURKINA_FASO,
    wxLANGUAGE_FRENCH_BURUNDI,
    wxLANGUAGE_FRENCH_CAMEROON,
    wxLANGUAGE_FRENCH_CANADIAN,
    wxLANGUAGE_FRENCH_CARIBBEAN,
    wxLANGUAGE_FRENCH_CENTRAL_AFRICAN_REPUBLIC,
    wxLANGUAGE_FRENCH_CHAD,
    wxLANGUAGE_FRENCH_COMOROS,
    wxLANGUAGE_FRENCH_CONGO,
    wxLANGUAGE_FRENCH_CONGO_DRC,
    wxLANGUAGE_FRENCH_COTE_DIVOIRE,
    wxLANGUAGE_FRENCH_DJIBOUTI,
    wxLANGUAGE_FRENCH_EQUATORIAL_GUINEA,
    wxLANGUAGE_FRENCH_FRANCE,
    wxLANGUAGE_FRENCH_FRENCH_GUIANA,
    wxLANGUAGE_FRENCH_FRENCH_POLYNESIA,
    wxLANGUAGE_FRENCH_GABON,
    wxLANGUAGE_FRENCH_GUADELOUPE,
    wxLANGUAGE_FRENCH_GUINEA,
    wxLANGUAGE_FRENCH_HAITI,
    wxLANGUAGE_FRENCH_LUXEMBOURG,
    wxLANGUAGE_FRENCH_MADAGASCAR,
    wxLANGUAGE_FRENCH_MALI,
    wxLANGUAGE_FRENCH_MARTINIQUE,
    wxLANGUAGE_FRENCH_MAURITANIA,
    wxLANGUAGE_FRENCH_MAURITIUS,
    wxLANGUAGE_FRENCH_MAYOTTE,
    wxLANGUAGE_FRENCH_MONACO,
    wxLANGUAGE_FRENCH_MOROCCO,
    wxLANGUAGE_FRENCH_NEW_CALEDONIA,
    wxLANGUAGE_FRENCH_NIGER,
    wxLANGUAGE_FRENCH_REUNION,
    wxLANGUAGE_FRENCH_RWANDA,
    wxLANGUAGE_FRENCH_SENEGAL,
    wxLANGUAGE_FRENCH_SEYCHELLES,
    wxLANGUAGE_FRENCH_ST_BARTHELEMY,
    wxLANGUAGE_FRENCH_ST_MARTIN,
    wxLANGUAGE_FRENCH_ST_PIERRE_AND_MIQUELON,
    wxLANGUAGE_FRENCH_SWISS,
    wxLANGUAGE_FRENCH_SYRIA,
    wxLANGUAGE_FRENCH_TOGO,
    wxLANGUAGE_FRENCH_TUNISIA,
    wxLANGUAGE_FRENCH_VANUATU,
    wxLANGUAGE_FRENCH_WALLIS_AND_FUTUNA,
    wxLANGUAGE_FRISIAN,
    wxLANGUAGE_FRISIAN_NETHERLANDS,
    wxLANGUAGE_FRIULIAN,
    wxLANGUAGE_FRIULIAN_ITALY,
    wxLANGUAGE_FULAH,
    wxLANGUAGE_FULAH_LATIN,
    wxLANGUAGE_FULAH_LATIN_BURKINA_FASO,
    wxLANGUAGE_FULAH_LATIN_CAMEROON,
    wxLANGUAGE_FULAH_LATIN_GAMBIA,
    wxLANGUAGE_FULAH_LATIN_GHANA,
    wxLANGUAGE_FULAH_LATIN_GUINEA,
    wxLANGUAGE_FULAH_LATIN_GUINEA_BISSAU,
    wxLANGUAGE_FULAH_LATIN_LIBERIA,
    wxLANGUAGE_FULAH_LATIN_MAURITANIA,
    wxLANGUAGE_FULAH_LATIN_NIGER,
    wxLANGUAGE_FULAH_LATIN_NIGERIA,
    wxLANGUAGE_FULAH_LATIN_SENEGAL,
    wxLANGUAGE_FULAH_LATIN_SIERRA_LEONE,
    wxLANGUAGE_GALICIAN,
    wxLANGUAGE_GALICIAN_SPAIN,
    wxLANGUAGE_GANDA,
    wxLANGUAGE_GANDA_UGANDA,
    wxLANGUAGE_GEORGIAN,
    wxLANGUAGE_GEORGIAN_GEORGIA,
    wxLANGUAGE_GERMAN,
    wxLANGUAGE_GERMAN_AUSTRIAN,
    wxLANGUAGE_GERMAN_BELGIUM,
    wxLANGUAGE_GERMAN_GERMANY,
    wxLANGUAGE_GERMAN_ITALY,
    wxLANGUAGE_GERMAN_LIECHTENSTEIN,
    wxLANGUAGE_GERMAN_LUXEMBOURG,
    wxLANGUAGE_GERMAN_SWISS,
    wxLANGUAGE_GREEK,
    wxLANGUAGE_GREEK_CYPRUS,
    wxLANGUAGE_GREEK_GREECE,
    wxLANGUAGE_GREENLANDIC,
    wxLANGUAGE_GUARANI,
    wxLANGUAGE_GUARANI_PARAGUAY,
    wxLANGUAGE_GUJARATI,
    wxLANGUAGE_GUJARATI_INDIA,
    wxLANGUAGE_GUSII,
    wxLANGUAGE_GUSII_KENYA,
    wxLANGUAGE_HAUSA,
    wxLANGUAGE_HAUSA_LATIN,
    wxLANGUAGE_HAUSA_LATIN_GHANA,
    wxLANGUAGE_HAUSA_LATIN_NIGER,
    wxLANGUAGE_HAUSA_LATIN_NIGERIA,
    wxLANGUAGE_HAWAIIAN,
    wxLANGUAGE_HAWAIIAN_US,
    wxLANGUAGE_HEBREW,
    wxLANGUAGE_HEBREW_ISRAEL,
    wxLANGUAGE_HINDI,
    wxLANGUAGE_HINDI_INDIA,
    wxLANGUAGE_HUNGARIAN,
    wxLANGUAGE_HUNGARIAN_HUNGARY,
    wxLANGUAGE_IBIBIO,
    wxLANGUAGE_IBIBIO_NIGERIA,
    wxLANGUAGE_ICELANDIC,
    wxLANGUAGE_ICELANDIC_ICELAND,
    wxLANGUAGE_IGBO,
    wxLANGUAGE_IGBO_NIGERIA,
    wxLANGUAGE_INDONESIAN,
    wxLANGUAGE_INDONESIAN_INDONESIA,
    wxLANGUAGE_INTERLINGUA,
    wxLANGUAGE_INTERLINGUA_WORLD,
    wxLANGUAGE_INTERLINGUE,
    wxLANGUAGE_INUKTITUT,
    wxLANGUAGE_INUKTITUT_LATIN,
    wxLANGUAGE_INUKTITUT_LATIN_CANADA,
    wxLANGUAGE_INUKTITUT_SYLLABICS,
    wxLANGUAGE_INUKTITUT_SYLLABICS_CANADA,
    wxLANGUAGE_INUPIAK,
    wxLANGUAGE_IRISH,
    wxLANGUAGE_IRISH_IRELAND,
    wxLANGUAGE_ITALIAN,
    wxLANGUAGE_ITALIAN_ITALY,
    wxLANGUAGE_ITALIAN_SAN_MARINO,
    wxLANGUAGE_ITALIAN_SWISS,
    wxLANGUAGE_ITALIAN_VATICAN_CITY,
    wxLANGUAGE_JAPANESE,
    wxLANGUAGE_JAPANESE_JAPAN,
    wxLANGUAGE_JAVANESE,
    wxLANGUAGE_JAVANESE_INDONESIA,
    wxLANGUAGE_JAVANESE_JAVANESE,
    wxLANGUAGE_JAVANESE_JAVANESE_INDONESIA,
    wxLANGUAGE_JOLA_FONYI,
    wxLANGUAGE_JOLA_FONYI_SENEGAL,
    wxLANGUAGE_KABUVERDIANU,
    wxLANGUAGE_KABUVERDIANU_CABO_VERDE,
    wxLANGUAGE_KABYLE,
    wxLANGUAGE_KABYLE_ALGERIA,
    wxLANGUAGE_KAKO,
    wxLANGUAGE_KAKO_CAMEROON,
    wxLANGUAGE_KALAALLISUT,
    wxLANGUAGE_KALENJIN,
    wxLANGUAGE_KALENJIN_KENYA,
    wxLANGUAGE_KAMBA,
    wxLANGUAGE_KAMBA_KENYA,
    wxLANGUAGE_KANNADA,
    wxLANGUAGE_KANNADA_INDIA,
    wxLANGUAGE_KANURI,
    wxLANGUAGE_KANURI_LATIN,
    wxLANGUAGE_KANURI_NIGERIA,
    wxLANGUAGE_KASHMIRI,
    wxLANGUAGE_KASHMIRI_DEVANAGARI,
    wxLANGUAGE_KASHMIRI_DEVANAGARI_INDIA,
    wxLANGUAGE_KASHMIRI_INDIA,
    wxLANGUAGE_KASHMIRI_PERSO_ARABIC,
    wxLANGUAGE_KASHMIRI_PERSO_ARABIC_INDIA,
    wxLANGUAGE_KAZAKH,
    wxLANGUAGE_KAZAKH_KAZAKHSTAN,
    wxLANGUAGE_KHMER,
    wxLANGUAGE_KHMER_CAMBODIA,
    wxLANGUAGE_KICHE,
    wxLANGUAGE_KICHE_GUATEMALA,
    wxLANGUAGE_KICHE_LATIN,
    wxLANGUAGE_KIKUYU,
    wxLANGUAGE_KIKUYU_KENYA,
    wxLANGUAGE_KINYARWANDA,
    wxLANGUAGE_KINYARWANDA_RWANDA,
    wxLANGUAGE_KIRGHIZ,
    wxLANGUAGE_KIRGHIZ_KYRGYZSTAN,
    wxLANGUAGE_KIRUNDI,
    wxLANGUAGE_KIRUNDI_BURUNDI,
    wxLANGUAGE_KONKANI,
    wxLANGUAGE_KONKANI_INDIA,
    wxLANGUAGE_KOREAN,
    wxLANGUAGE_KOREAN_KOREA,
    wxLANGUAGE_KOREAN_NORTH_KOREA,
    wxLANGUAGE_KOYRABORO_SENNI,
    wxLANGUAGE_KOYRABORO_SENNI_MALI,
    wxLANGUAGE_KOYRA_CHIINI,
    wxLANGUAGE_KOYRA_CHIINI_MALI,
    wxLANGUAGE_KURDISH,
    wxLANGUAGE_KURDISH_PERSO_ARABIC_IRAN,
    wxLANGUAGE_KWASIO,
    wxLANGUAGE_KWASIO_CAMEROON,
    wxLANGUAGE_LAKOTA,
    wxLANGUAGE_LAKOTA_US,
    wxLANGUAGE_LANGI,
    wxLANGUAGE_LANGI_TANZANIA,
    wxLANGUAGE_LAOTHIAN,
    wxLANGUAGE_LAOTHIAN_LAOS,
    wxLANGUAGE_LATIN,
    wxLANGUAGE_LATIN_WORLD,
    wxLANGUAGE_LATVIAN,
    wxLANGUAGE_LATVIAN_LATVIA,
    wxLANGUAGE_LINGALA,
    wxLANGUAGE_LINGALA_ANGOLA,
    wxLANGUAGE_LINGALA_CENTRAL_AFRICAN_REPUBLIC,
    wxLANGUAGE_LINGALA_CONGO,
    wxLANGUAGE_LINGALA_CONGO_DRC,
    wxLANGUAGE_LITHUANIAN,
    wxLANGUAGE_LITHUANIAN_LITHUANIA,
    wxLANGUAGE_LOWER_SORBIAN,
    wxLANGUAGE_LOWER_SORBIAN_GERMANY,
    wxLANGUAGE_LOW_GERMAN,
    wxLANGUAGE_LOW_GERMAN_GERMANY,
    wxLANGUAGE_LOW_GERMAN_NETHERLANDS,
    wxLANGUAGE_LUBA_KATANGA,
    wxLANGUAGE_LUBA_KATANGA_CONGO_DRC,
    wxLANGUAGE_LUO,
    wxLANGUAGE_LUO_KENYA,
    wxLANGUAGE_LUXEMBOURGISH,
    wxLANGUAGE_LUXEMBOURGISH_LUXEMBOURG,
    wxLANGUAGE_LUYIA,
    wxLANGUAGE_LUYIA_KENYA,
    wxLANGUAGE_MACEDONIAN,
    wxLANGUAGE_MACEDONIAN_NORTH_MACEDONIA,
    wxLANGUAGE_MACHAME,
    wxLANGUAGE_MACHAME_TANZANIA,
    wxLANGUAGE_MAKHUWA_MEETTO,
    wxLANGUAGE_MAKHUWA_MEETTO_MOZAMBIQUE,
    wxLANGUAGE_MAKONDE,
    wxLANGUAGE_MAKONDE_TANZANIA,
    wxLANGUAGE_MALAGASY,
    wxLANGUAGE_MALAGASY_MADAGASCAR,
    wxLANGUAGE_MALAY,
    wxLANGUAGE_MALAYALAM,
    wxLANGUAGE_MALAYALAM_INDIA,
    wxLANGUAGE_MALAY_BRUNEI,
    wxLANGUAGE_MALAY_MALAYSIA,
    wxLANGUAGE_MALAY_SINGAPORE,
    wxLANGUAGE_MALTESE,
    wxLANGUAGE_MALTESE_MALTA,
    wxLANGUAGE_MANIPURI,
    wxLANGUAGE_MANIPURI_INDIA,
    wxLANGUAGE_MANX,
    wxLANGUAGE_MANX_ISLE_OF_MAN,
    wxLANGUAGE_MAORI,
    wxLANGUAGE_MAORI_NEW_ZEALAND,
    wxLANGUAGE_MAPUCHE,
    wxLANGUAGE_MAPUCHE_CHILE,
    wxLANGUAGE_MARATHI,
    wxLANGUAGE_MARATHI_INDIA,
    wxLANGUAGE_MASAI,
    wxLANGUAGE_MASAI_KENYA,
    wxLANGUAGE_MASAI_TANZANIA,
    wxLANGUAGE_MAZANDERANI,
    wxLANGUAGE_MAZANDERANI_IRAN,
    wxLANGUAGE_MERU,
    wxLANGUAGE_MERU_KENYA,
    wxLANGUAGE_META,
    wxLANGUAGE_META_CAMEROON,
    wxLANGUAGE_MOHAWK,
    wxLANGUAGE_MOHAWK_CANADA,
    wxLANGUAGE_MOLDAVIAN,
    wxLANGUAGE_MONGOLIAN,
    wxLANGUAGE_MONGOLIAN_CYRILLIC,
    wxLANGUAGE_MONGOLIAN_MONGOLIA,
    wxLANGUAGE_MONGOLIAN_TRADITIONAL,
    wxLANGUAGE_MONGOLIAN_TRADITIONAL_CHINA,
    wxLANGUAGE_MONGOLIAN_TRADITIONAL_MONGOLIA,
    wxLANGUAGE_MORISYEN,
    wxLANGUAGE_MORISYEN_MAURITIUS,
    wxLANGUAGE_MUNDANG,
    wxLANGUAGE_MUNDANG_CAMEROON,
    wxLANGUAGE_NAMA,
    wxLANGUAGE_NAMA_NAMIBIA,
    wxLANGUAGE_NAURU,
    wxLANGUAGE_NEPALI,
    wxLANGUAGE_NEPALI_INDIA,
    wxLANGUAGE_NEPALI_NEPAL,
    wxLANGUAGE_NGIEMBOON,
    wxLANGUAGE_NGIEMBOON_CAMEROON,
    wxLANGUAGE_NGOMBA,
    wxLANGUAGE_NGOMBA_CAMEROON,
    wxLANGUAGE_NKO,
    wxLANGUAGE_NKO_GUINEA,
    wxLANGUAGE_NORTHERN_LURI,
    wxLANGUAGE_NORTHERN_LURI_IRAN,
    wxLANGUAGE_NORTHERN_LURI_IRAQ,
    wxLANGUAGE_NORTH_NDEBELE,
    wxLANGUAGE_NORTH_NDEBELE_ZIMBABWE,
    wxLANGUAGE_NORWEGIAN,
    wxLANGUAGE_NORWEGIAN_BOKMAL,
    wxLANGUAGE_NORWEGIAN_BOKMAL_NORWAY,
    wxLANGUAGE_NORWEGIAN_BOKMAL_SVALBARD_AND_JAN_MAYEN,
    wxLANGUAGE_NORWEGIAN_NYNORSK,
    wxLANGUAGE_NORWEGIAN_NYNORSK_NORWAY,
    wxLANGUAGE_NUER,
    wxLANGUAGE_NUER_SOUTH_SUDAN,
    wxLANGUAGE_NYANKOLE,
    wxLANGUAGE_NYANKOLE_UGANDA,
    wxLANGUAGE_OCCITAN,
    wxLANGUAGE_OCCITAN_FRANCE,
    wxLANGUAGE_ODIA,
    wxLANGUAGE_ODIA_INDIA,
    wxLANGUAGE_OROMO,
    wxLANGUAGE_OROMO_ETHIOPIA,
    wxLANGUAGE_OROMO_KENYA,
    wxLANGUAGE_OSSETIC,
    wxLANGUAGE_OSSETIC_GEORGIA,
    wxLANGUAGE_OSSETIC_RUSSIA,
    wxLANGUAGE_PAPIAMENTO,
    wxLANGUAGE_PAPIAMENTO_CARIBBEAN,
    wxLANGUAGE_PASHTO,
    wxLANGUAGE_PASHTO_AFGHANISTAN,
    wxLANGUAGE_PASHTO_PAKISTAN,
    wxLANGUAGE_PERSIAN_IRAN,
    wxLANGUAGE_POLISH,
    wxLANGUAGE_POLISH_POLAND,
    wxLANGUAGE_PORTUGUESE,
    wxLANGUAGE_PORTUGUESE_ANGOLA,
    wxLANGUAGE_PORTUGUESE_BRAZILIAN,
    wxLANGUAGE_PORTUGUESE_CABO_VERDE,
    wxLANGUAGE_PORTUGUESE_EQUATORIAL_GUINEA,
    wxLANGUAGE_PORTUGUESE_GUINEA_BISSAU,
    wxLANGUAGE_PORTUGUESE_LUXEMBOURG,
    wxLANGUAGE_PORTUGUESE_MACAO_SAR,
    wxLANGUAGE_PORTUGUESE_MOZAMBIQUE,
    wxLANGUAGE_PORTUGUESE_PORTUGAL,
    wxLANGUAGE_PORTUGUESE_SAO_TOME_AND_PRINCIPE,
    wxLANGUAGE_PORTUGUESE_SWITZERLAND,
    wxLANGUAGE_PORTUGUESE_TIMOR_LESTE,
    wxLANGUAGE_PRUSSIAN,
    wxLANGUAGE_PRUSSIAN_WORLD,
    wxLANGUAGE_PUNJABI,
    wxLANGUAGE_PUNJABI_ARABIC,
    wxLANGUAGE_PUNJABI_GURMUKHI,
    wxLANGUAGE_PUNJABI_INDIA,
    wxLANGUAGE_PUNJABI_PAKISTAN,
    wxLANGUAGE_QUECHUA,
    wxLANGUAGE_QUECHUA_BOLIVIA,
    wxLANGUAGE_QUECHUA_ECUADOR,
    wxLANGUAGE_QUECHUA_MACRO,
    wxLANGUAGE_QUECHUA_PERU,
    wxLANGUAGE_RHAETO_ROMANCE,
    wxLANGUAGE_RHAETO_ROMANCE_SWITZERLAND,
    wxLANGUAGE_ROMANIAN,
    wxLANGUAGE_ROMANIAN_MOLDOVA,
    wxLANGUAGE_ROMANIAN_ROMANIA,
    wxLANGUAGE_ROMBO,
    wxLANGUAGE_ROMBO_TANZANIA,
    wxLANGUAGE_RUSSIAN,
    wxLANGUAGE_RUSSIAN_BELARUS,
    wxLANGUAGE_RUSSIAN_KAZAKHSTAN,
    wxLANGUAGE_RUSSIAN_KYRGYZSTAN,
    wxLANGUAGE_RUSSIAN_MOLDOVA,
    wxLANGUAGE_RUSSIAN_RUSSIA,
    wxLANGUAGE_RUSSIAN_UKRAINE,
    wxLANGUAGE_RWA,
    wxLANGUAGE_RWA_TANZANIA,
    wxLANGUAGE_SAHO,
    wxLANGUAGE_SAHO_ERITREA,
    wxLANGUAGE_SAKHA,
    wxLANGUAGE_SAKHA_RUSSIA,
    wxLANGUAGE_SAMBURU,
    wxLANGUAGE_SAMBURU_KENYA,
    wxLANGUAGE_SAMI,
    wxLANGUAGE_SAMI_FINLAND,
    wxLANGUAGE_SAMI_INARI,
    wxLANGUAGE_SAMI_INARI_FINLAND,
    wxLANGUAGE_SAMI_LULE,
    wxLANGUAGE_SAMI_LULE_NORWAY,
    wxLANGUAGE_SAMI_LULE_SWEDEN,
    wxLANGUAGE_SAMI_NORWAY,
    wxLANGUAGE_SAMI_SKOLT,
    wxLANGUAGE_SAMI_SKOLT_FINLAND,
    wxLANGUAGE_SAMI_SOUTHERN,
    wxLANGUAGE_SAMI_SOUTHERN_NORWAY,
    wxLANGUAGE_SAMI_SOUTHERN_SWEDEN,
    wxLANGUAGE_SAMI_SWEDEN,
    wxLANGUAGE_SAMOAN,
    wxLANGUAGE_SANGHO,
    wxLANGUAGE_SANGHO_CENTRAL_AFRICAN_REPUBLIC,
    wxLANGUAGE_SANGU,
    wxLANGUAGE_SANGU_TANZANIA,
    wxLANGUAGE_SANSKRIT,
    wxLANGUAGE_SANSKRIT_INDIA,
    wxLANGUAGE_SCOTS_GAELIC,
    wxLANGUAGE_SCOTS_GAELIC_UK,
    wxLANGUAGE_SENA,
    wxLANGUAGE_SENA_MOZAMBIQUE,
    wxLANGUAGE_SERBIAN,
    wxLANGUAGE_SERBIAN_CYRILLIC,
    wxLANGUAGE_SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA,
    wxLANGUAGE_SERBIAN_CYRILLIC_KOSOVO,
    wxLANGUAGE_SERBIAN_CYRILLIC_MONTENEGRO,
    wxLANGUAGE_SERBIAN_CYRILLIC_SERBIA,
    wxLANGUAGE_SERBIAN_CYRILLIC_YU,
    wxLANGUAGE_SERBIAN_LATIN,
    wxLANGUAGE_SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA,
    wxLANGUAGE_SERBIAN_LATIN_KOSOVO,
    wxLANGUAGE_SERBIAN_LATIN_MONTENEGRO,
    wxLANGUAGE_SERBIAN_LATIN_SERBIA,
    wxLANGUAGE_SERBIAN_LATIN_YU,
    wxLANGUAGE_SERBIAN_SERBIA,
    wxLANGUAGE_SERBIAN_YU,
    wxLANGUAGE_SERBO_CROATIAN,
    wxLANGUAGE_SESOTHO,
    wxLANGUAGE_SESOTHO_LESOTHO,
    wxLANGUAGE_SESOTHO_SA_LEBOA,
    wxLANGUAGE_SESOTHO_SA_LEBOA_SOUTH_AFRICA,
    wxLANGUAGE_SESOTHO_SOUTH_AFRICA,
    wxLANGUAGE_SETSWANA,
    wxLANGUAGE_SETSWANA_BOTSWANA,
    wxLANGUAGE_SETSWANA_SOUTH_AFRICA,
    wxLANGUAGE_SHAMBALA,
    wxLANGUAGE_SHAMBALA_TANZANIA,
    wxLANGUAGE_SHONA,
    wxLANGUAGE_SHONA_LATIN,
    wxLANGUAGE_SHONA_LATIN_ZIMBABWE,
    wxLANGUAGE_SINDHI,
    wxLANGUAGE_SINDHI_ARABIC,
    wxLANGUAGE_SINDHI_DEVANAGARI,
    wxLANGUAGE_SINDHI_DEVANAGARI_INDIA,
    wxLANGUAGE_SINDHI_PAKISTAN,
    wxLANGUAGE_SINHALESE,
    wxLANGUAGE_SINHALESE_SRI_LANKA,
    wxLANGUAGE_SISWATI,
    wxLANGUAGE_SISWATI_ESWATINI,
    wxLANGUAGE_SISWATI_SOUTH_AFRICA,
    wxLANGUAGE_SLOVAK,
    wxLANGUAGE_SLOVAK_SLOVAKIA,
    wxLANGUAGE_SLOVENIAN,
    wxLANGUAGE_SLOVENIAN_SLOVENIA,
    wxLANGUAGE_SOGA,
    wxLANGUAGE_SOGA_UGANDA,
    wxLANGUAGE_SOMALI,
    wxLANGUAGE_SOMALI_DJIBOUTI,
    wxLANGUAGE_SOMALI_ETHIOPIA,
    wxLANGUAGE_SOMALI_KENYA,
    wxLANGUAGE_SOMALI_SOMALIA,
    wxLANGUAGE_SOUTH_NDEBELE,
    wxLANGUAGE_SOUTH_NDEBELE_SOUTH_AFRICA,
    wxLANGUAGE_SPANISH,
    wxLANGUAGE_SPANISH_ARGENTINA,
    wxLANGUAGE_SPANISH_BELIZE,
    wxLANGUAGE_SPANISH_BOLIVIA,
    wxLANGUAGE_SPANISH_BRAZIL,
    wxLANGUAGE_SPANISH_CHILE,
    wxLANGUAGE_SPANISH_COLOMBIA,
    wxLANGUAGE_SPANISH_COSTA_RICA,
    wxLANGUAGE_SPANISH_CUBA,
    wxLANGUAGE_SPANISH_DOMINICAN_REPUBLIC,
    wxLANGUAGE_SPANISH_ECUADOR,
    wxLANGUAGE_SPANISH_EL_SALVADOR,
    wxLANGUAGE_SPANISH_EQUATORIAL_GUINEA,
    wxLANGUAGE_SPANISH_GUATEMALA,
    wxLANGUAGE_SPANISH_HONDURAS,
    wxLANGUAGE_SPANISH_LATIN_AMERICA,
    wxLANGUAGE_SPANISH_MEXICAN,
    wxLANGUAGE_SPANISH_NICARAGUA,
    wxLANGUAGE_SPANISH_PANAMA,
    wxLANGUAGE_SPANISH_PARAGUAY,
    wxLANGUAGE_SPANISH_PERU,
    wxLANGUAGE_SPANISH_PHILIPPINES,
    wxLANGUAGE_SPANISH_PUERTO_RICO,
    wxLANGUAGE_SPANISH_SPAIN,
    wxLANGUAGE_SPANISH_URUGUAY,
    wxLANGUAGE_SPANISH_US,
    wxLANGUAGE_SPANISH_VENEZUELA,
    wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT,
    wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH,
    wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH_MOROCCO,
    wxLANGUAGE_SUNDANESE,
    wxLANGUAGE_SWAHILI,
    wxLANGUAGE_SWAHILI_CONGO_DRC,
    wxLANGUAGE_SWAHILI_KENYA,
    wxLANGUAGE_SWAHILI_TANZANIA,
    wxLANGUAGE_SWAHILI_UGANDA,
    wxLANGUAGE_SWEDISH,
    wxLANGUAGE_SWEDISH_ALAND_ISLANDS,
    wxLANGUAGE_SWEDISH_FINLAND,
    wxLANGUAGE_SWEDISH_SWEDEN,
    wxLANGUAGE_SWISS_GERMAN,
    wxLANGUAGE_SWISS_GERMAN_LIECHTENSTEIN,
    wxLANGUAGE_SWISS_GERMAN_SWITZERLAND,
    wxLANGUAGE_SYRIAC,
    wxLANGUAGE_SYRIAC_SYRIA,
    wxLANGUAGE_TACHELHIT,
    wxLANGUAGE_TACHELHIT_LATIN,
    wxLANGUAGE_TACHELHIT_LATIN_MOROCCO,
    wxLANGUAGE_TACHELHIT_TIFINAGH,
    wxLANGUAGE_TACHELHIT_TIFINAGH_MOROCCO,
    wxLANGUAGE_TAGALOG,
    wxLANGUAGE_TAITA,
    wxLANGUAGE_TAITA_KENYA,
    wxLANGUAGE_TAJIK,
    wxLANGUAGE_TAJIK_CYRILLIC,
    wxLANGUAGE_TAJIK_CYRILLIC_TAJIKISTAN,
    wxLANGUAGE_TAMIL,
    wxLANGUAGE_TAMIL_INDIA,
    wxLANGUAGE_TAMIL_MALAYSIA,
    wxLANGUAGE_TAMIL_SINGAPORE,
    wxLANGUAGE_TAMIL_SRI_LANKA,
    wxLANGUAGE_TASAWAQ,
    wxLANGUAGE_TASAWAQ_NIGER,
    wxLANGUAGE_TATAR,
    wxLANGUAGE_TATAR_RUSSIA,
    wxLANGUAGE_TELUGU,
    wxLANGUAGE_TELUGU_INDIA,
    wxLANGUAGE_TESO,
    wxLANGUAGE_TESO_KENYA,
    wxLANGUAGE_TESO_UGANDA,
    wxLANGUAGE_THAI,
    wxLANGUAGE_THAI_THAILAND,
    wxLANGUAGE_TIBETAN,
    wxLANGUAGE_TIBETAN_CHINA,
    wxLANGUAGE_TIBETAN_INDIA,
    wxLANGUAGE_TIGRE,
    wxLANGUAGE_TIGRE_ERITREA,
    wxLANGUAGE_TIGRINYA,
    wxLANGUAGE_TIGRINYA_ERITREA,
    wxLANGUAGE_TIGRINYA_ETHIOPIA,
    wxLANGUAGE_TONGA,
    wxLANGUAGE_TONGA_TONGA,
    wxLANGUAGE_TSONGA,
    wxLANGUAGE_TSONGA_SOUTH_AFRICA,
    wxLANGUAGE_TURKISH,
    wxLANGUAGE_TURKISH_CYPRUS,
    wxLANGUAGE_TURKISH_TURKEY,
    wxLANGUAGE_TURKMEN,
    wxLANGUAGE_TURKMEN_TURKMENISTAN,
    wxLANGUAGE_TWI,
    wxLANGUAGE_UIGHUR,
    wxLANGUAGE_UIGHUR_CHINA,
    wxLANGUAGE_UKRAINIAN,
    wxLANGUAGE_UKRAINIAN_UKRAINE,
    wxLANGUAGE_UPPER_SORBIAN,
    wxLANGUAGE_UPPER_SORBIAN_GERMANY,
    wxLANGUAGE_URDU,
    wxLANGUAGE_URDU_INDIA,
    wxLANGUAGE_URDU_PAKISTAN,
    wxLANGUAGE_UZBEK,
    wxLANGUAGE_UZBEK_CYRILLIC,
    wxLANGUAGE_UZBEK_CYRILLIC_UZBEKISTAN,
    wxLANGUAGE_UZBEK_LATIN,
    wxLANGUAGE_UZBEK_LATIN_UZBEKISTAN,
    wxLANGUAGE_UZBEK_PERSO_ARABIC,
    wxLANGUAGE_UZBEK_PERSO_ARABIC_AFGHANISTAN,
    wxLANGUAGE_VAI,
    wxLANGUAGE_VAI_LATIN,
    wxLANGUAGE_VAI_LATIN_LIBERIA,
    wxLANGUAGE_VAI_VAI,
    wxLANGUAGE_VAI_VAI_LIBERIA,
    wxLANGUAGE_VALENCIAN,
    wxLANGUAGE_VENDA,
    wxLANGUAGE_VENDA_SOUTH_AFRICA,
    wxLANGUAGE_VIETNAMESE,
    wxLANGUAGE_VIETNAMESE_VIETNAM,
    wxLANGUAGE_VOLAPUK,
    wxLANGUAGE_VOLAPUK_WORLD,
    wxLANGUAGE_VUNJO,
    wxLANGUAGE_VUNJO_TANZANIA,
    wxLANGUAGE_WALSER,
    wxLANGUAGE_WALSER_SWITZERLAND,
    wxLANGUAGE_WELSH,
    wxLANGUAGE_WELSH_UK,
    wxLANGUAGE_WOLAYTTA,
    wxLANGUAGE_WOLAYTTA_ETHIOPIA,
    wxLANGUAGE_WOLOF,
    wxLANGUAGE_WOLOF_SENEGAL,
    wxLANGUAGE_XHOSA,
    wxLANGUAGE_XHOSA_SOUTH_AFRICA,
    wxLANGUAGE_YANGBEN,
    wxLANGUAGE_YANGBEN_CAMEROON,
    wxLANGUAGE_YI,
    wxLANGUAGE_YIDDISH,
    wxLANGUAGE_YIDDISH_WORLD,
    wxLANGUAGE_YI_CHINA,
    wxLANGUAGE_YORUBA,
    wxLANGUAGE_YORUBA_BENIN,
    wxLANGUAGE_YORUBA_NIGERIA,
    wxLANGUAGE_ZARMA,
    wxLANGUAGE_ZARMA_NIGER,
    wxLANGUAGE_ZHUANG,
    wxLANGUAGE_ZULU,
    wxLANGUAGE_ZULU_SOUTH_AFRICA,

    /// For custom, user-defined languages.
    wxLANGUAGE_USER_DEFINED,

    /// Synonyms.
    wxLANGUAGE_AZERI = wxLANGUAGE_AZERBAIJANI,
    wxLANGUAGE_AZERI_CYRILLIC = wxLANGUAGE_AZERBAIJANI_CYRILLIC,
    wxLANGUAGE_AZERI_LATIN = wxLANGUAGE_AZERBAIJANI_LATIN,
    wxLANGUAGE_BENGALI = wxLANGUAGE_BANGLA,
    wxLANGUAGE_BENGALI_BANGLADESH = wxLANGUAGE_BANGLA_BANGLADESH,
    wxLANGUAGE_BENGALI_INDIA = wxLANGUAGE_BANGLA_INDIA,
    wxLANGUAGE_BHUTANI = wxLANGUAGE_DZONGKHA,
    wxLANGUAGE_CHINESE_SIMPLIFIED = wxLANGUAGE_CHINESE_CHINA,
    wxLANGUAGE_CHINESE_TRADITIONAL = wxLANGUAGE_CHINESE_TAIWAN,
    wxLANGUAGE_CHINESE_MACAU = wxLANGUAGE_CHINESE_MACAO,
    wxLANGUAGE_KERNEWEK = wxLANGUAGE_CORNISH,
    wxLANGUAGE_MALAY_BRUNEI_DARUSSALAM = wxLANGUAGE_MALAY_BRUNEI,
    wxLANGUAGE_ORIYA = wxLANGUAGE_ODIA,
    wxLANGUAGE_ORIYA_INDIA = wxLANGUAGE_ODIA_INDIA,
    wxLANGUAGE_SPANISH_MODERN = wxLANGUAGE_SPANISH,

    /// Obsolete synonym.
    wxLANGUAGE_CAMBODIAN = wxLANGUAGE_KHMER
};

// --- --- --- generated code ends here --- --- ---

#endif // wxUSE_INTL

#endif // _WX_LANGUAGE_H_
