# README

Before contributing, please read [the contributing document](https://github.com/webcamoid/webcamoid/blob/master/CONTRIBUTING.md), and the [coding style and conventions](https://github.com/webcamoid/webcamoid/wiki/Coding-style-and-conventions) guide.  
Search the [pull request list](https://github.com/webcamoid/webcamoid/pulls) for similar pulls before opening a new one.  
Check your code doesn't throw any warning or error message while compiling, and doesn't give any warning in Clang static analyzer. Make sure your code is GCC, Clang, MinGW and MSVC compliant (use AppVeyor and Github Actions for that).  
Check your code using GDB, Valgrind and similar tools to remove all possible memory leaks and segfaults.  

# Pull request

## Type of change

Is your pull request a bug fix, new feature, code refactor, breaking change, etc.?  
If your change is too big consider [discussing it](https://github.com/webcamoid/webcamoid/issues) before pulling.

## Summary

Describe your pull request the best as you can.

## Related Issue

Is this pull request related to some [issue](https://github.com/webcamoid/webcamoid/issues)? Cite the issue as #NNN, where NNN is the number of issue.

## More info

Provide screenshots, logs, etc. if required.

## Added dependencies

Does your pull request add more dependencies to the project? This may require some discussion. Minimal dependencies is a requirement.

## Target Environment

Is this pull request specific to a target operating system?

* Operating System information: (name) (numeric version and codename if applied) (architecture)
