---
myst:
  html_meta:
    keywords: LaTeX, fichiers, TDS, installer LaTeX, TeX Directory structure, installation, 
              répertoire pour LaTeX
---

# Quelle arborescence faut-il utiliser ?

Dans presque tous les cas, les nouveaux éléments que vous installez doivent aller 
dans l'arborescence "locale" de votre installation (La)TeX. *Ne pas* utiliser cette arborescence
est évoqué plus bas dans cette page.

Sur un système Unix (ou similaire) utilisant TeX Live ou teTeX, le répertoire racine 
sera nommé quelque chose comme `/usr/share/texmf-local/` ou `/usr/local/share/texmf/`.
Vous pouvez demander au système de vous indiquer où se situe cette arborescence locale 
avec la commande suivante :

```bash
kpsewhich -var-value TEXMFLOCAL
```

Dans une installation MiKTeX, l'emplacement sera en fait généralement 
ce que vous avez spécifié vous-même lorsque vous avez installé MiKTeX, 
mais vous devrez peut-être en créer un. La fenêtre "Paramètres" de MiKTeX (`Démarrer` → 
`Programmes` → `MiKTeX` → `Paramètres`) comporte un onglet "Racines". 
Cet onglet donne une liste des chemins des arborescences de la TDS 
(elles ne sont généralement pas appelées "texmf"-quelque chose). 
S'il n'y en a pas avec "local" dans son nom, créez-en un approprié (voir ci-dessous) 
et enregistrez-le à l'aide du bouton "Ajouter" de la fenêtre.

:::{todo} Vérifier les noms des onglets du paragraphe précédent.
:::

Votre arborescence locale doit se trouver à un endroit sur lequel vous avez les droits. 
Les systèmes restrictifs fournissent souvent un répertoire "personnel pour chaque utilisateur, 
(parfois monté en tant que lecteur réseau). Il s'agit d'un choix naturel 
pour l'arbre local de l'utilisateur. MikTeX propose ainsi de s'installer par défaut, 
sous Windows, dans votre [répertoire utilisateur](https://miktex.org/howto/install-miktex).
D'autres environnements (souvent académiques) supposent que l'utilisateur va fournir 
une clé USB et lui attribuera une lettre de lecteur définie, ce qui est un autre bon candidat
pour l'arborescence locale. Notez qu'une telle arborescence est indistinguable de celle d'une 
[arborescence "home"](installation_privee).

Vous ne souhaiterez peut-être pas utiliser l'arborescence "locale" :

- si l'extension, ou autre, est "personnelle" (par exemple, un élément commercial 
  qui vous a été attribué sous licence, ou quelque chose que vous développez vous-même), 
  elle doit aller dans votre [arborescence privée](installation_privee).
- si vous *savez* que l'extension que vous installez remplace une copie 
  sur l'arborescence TEXMF de votre distribution (La)TeX, il est, dans ce cas, 
  plutôt raisonnable de remplacer la copie existante dans l'arborescence TEXMF.

Si le système est mis à jour ou réinstallé, une copie faite dans l'arborescence TEXMF 
sera probablement écrasée ou supprimée. Même si cela peut-être souhaité, 
cela reste un motif recommandant d'utiliser une arborescence 
qui ne fait *pas* partie du système installé.

La raison pour laquelle on peut placer les mises à niveau dans l'arborescence principale 
de la distribution est d'éviter toute confusion. Supposons que vous placiez votre fichier 
dans l'arborescence locale, puis que vous installiez une nouvelle version de la distribution.
Vous pourriez aboutir à la situation suivante :

- la distribution est livrée avec la version N de l'extension ;
- vous installez la version N+1 de l'extension sur l'arborescence locale ; 
- et la distribution mise à jour fournit la version N+2 de l'extension.

Dans une telle situation, vous pourriez vous retrouver à utiliser la version N+11 
(depuis l'arborescence locale) *après* l'installation de la nouvelle distribution.

Si vous effectuez l'installation dans l'arborescence locale, 
le seul moyen d'éviter de tels problèmes est de purger soigneusement l'arborescence locale
lors de l'installation d'une nouvelle distribution. 
C'est fastidieux si vous gérez une grande installation.

:::{sources}
[Which tree to use](faquk:FAQ-what-TDS)
:::