/*
  Copyright (c) 2007 Paolo Capriotti <p.capriotti@gmail.com>
            (c) 2007 Maurizio Monge <maurizio.monge@kdemail.net>
	    (c) 2007 Yann Dirson <ydirson@altern.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/


#ifndef HLVARIANT__MINISHOGI__VARIANT_H
#define HLVARIANT__MINISHOGI__VARIANT_H

#include "../shogi/piece.h"
#include "../shogi/shogiban.h"
#include "../chess/move.h"
#include "../crazyhouse/move.h"
#include "gamestate.h"
#include "../shogi/legalitycheck.h"
#include "../shogi/serializer.h"
#include "../crazyhouse/movefactory.h"
#include "../animator.h"
#include "../dropanimator.h"
#include "../shogi/shogiactions.h"

namespace HLVariant {
namespace MiniShogi {

struct TAGUA_EXPORT Variant {
  typedef Crazyhouse::MoveMixin<Chess::Move, Shogi::Piece> TheMove;
  typedef GameState<Shogi::ShogiBan<5, 5, Shogi::Piece>, TheMove> TheGameState;
  typedef Shogi::LegalityCheck<TheGameState> TheLegalityCheck;
  typedef Shogi::Serializer<TheLegalityCheck> TheSerializer;
  typedef DropAnimatorMixin<SimpleAnimator<Variant> > TheAnimator;
  typedef Crazyhouse::MoveFactory<TheGameState> TheMoveFactory;
  typedef Variant TheMoveGenerator; // to make VariantData happy
  
  static const bool hasICS = false;
  static const bool m_simple_moves = false;
  static const bool m_hidden = false;
  static const char *m_name;
  static const char *m_theme_proxy;

  static int moveListLayout() { return 0; }

  OptList positionOptions() const { return OptList(); }
  void setupMove(NormalUserMove& m) const;
  ActionCollection* actions();
private:
  Shogi::ShogiActions m_actions;
};

} // namespace MiniShogi
} // namespace HLVariant

#endif // HLVARIANT__MINISHOGI__VARIANT_H
