package src;

import javax.naming.directory.InitialDirContext;

import sun.rmi.runtime.GetThreadPoolAction;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.graphics.Image;


public class MainFrame {

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="14,12"
	private ToolBar editor_toolBar = null;
	private Po2Tab converter ;
	private Text status_text = null;
	private FileDialog OpenDlg, SaveDlg;
	private Text textArea = null;
	private static final String SYS_SPARATOR = System.getProperty("file.separator");  //  @jve:decl-index=0:
	/**
	 * This method initializes editor_toolBar	
	 *
	 */
	private void createEditor_toolBar() {
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = GridData.FILL;
		gridData1.verticalAlignment = GridData.FILL;
		editor_toolBar = new ToolBar(sShell, SWT.LEFT_TO_RIGHT);
		editor_toolBar.setLayout(new GridLayout());
		editor_toolBar.setLayoutData(gridData1);
		ToolItem open_toolItem = new ToolItem(editor_toolBar, SWT.PUSH);
		open_toolItem.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/res/open_32.png")));
		open_toolItem.setText("Convert a File");
		ToolItem directory_toolItem = new ToolItem(editor_toolBar, SWT.PUSH);
		directory_toolItem.setText("Convert Full Path");
		directory_toolItem.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/res/dir_32.png")));
		directory_toolItem
				.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						ConvertFullPath();
					}
					public void widgetDefaultSelected(
							org.eclipse.swt.events.SelectionEvent e) {
					}
				});
		ToolItem save_toolItem = new ToolItem(editor_toolBar, SWT.PUSH);
		save_toolItem.setText("Save As");
		save_toolItem.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/res/save_32.png")));
		save_toolItem
				.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						SaveAs();
					}
					public void widgetDefaultSelected(
							org.eclipse.swt.events.SelectionEvent e) {
					}
				});
		open_toolItem
				.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						ConvertAFile();
					}
					public void widgetDefaultSelected(
							org.eclipse.swt.events.SelectionEvent e) {
					}
				});
		
		ToolItem about_toolItem = new ToolItem(editor_toolBar, SWT.PUSH);
		about_toolItem.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/res/about_32.png")));
		about_toolItem.setText("About");
		about_toolItem
				.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						
						System.out.println("AboutFrame");
					}
					public void widgetDefaultSelected(
							org.eclipse.swt.events.SelectionEvent e) {
					}
				});
		ToolItem close_toolItem = new ToolItem(editor_toolBar, SWT.PUSH);
		close_toolItem.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/res/close_32.png")));
		close_toolItem.setText("Exit");
		close_toolItem
				.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						System.exit(0);
					}
					public void widgetDefaultSelected(
							org.eclipse.swt.events.SelectionEvent e) {
					}
				});
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		/* Before this is run, be sure to set up the launch configuration (Arguments->VM Arguments)
		 * for the correct SWT library path in order to run with the SWT dlls. 
		 * The dlls are located in the SWT plugin jar.  
		 * For example, on Windows the Eclipse SWT 3.1 plugin jar is:
		 *       installation_directory\plugins\org.eclipse.swt.win32_3.1.0.jar
		 */	
		Display display = Display.getDefault();
		MainFrame thisClass = new MainFrame();
		thisClass.createSShell();
		thisClass.sShell.open();

		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		GridData gridData11 = new GridData();
		gridData11.horizontalAlignment = GridData.FILL;
		gridData11.grabExcessVerticalSpace = true;
		gridData11.grabExcessHorizontalSpace = true;
		gridData11.verticalAlignment = GridData.FILL;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.horizontalSpacing = 5;
		gridLayout.makeColumnsEqualWidth = false;
		sShell = new Shell(SWT.LEFT_TO_RIGHT | SWT.SHELL_TRIM);
		sShell.setText("Convert Po2Tab");
		sShell.setLayout(gridLayout);
		createEditor_toolBar();
		sShell.setSize(new Point(460, 339));
		textArea = new Text(sShell, SWT.MULTI | SWT.V_SCROLL | SWT.BORDER | SWT.READ_ONLY | SWT.LEFT);
		textArea.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
		textArea.setLayoutData(gridData11);
		status_text = new Text(sShell, SWT.BORDER | SWT.READ_ONLY);
		status_text.setText("");
		status_text.setLayoutData(gridData);
		status_text.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
			sShell.setText("Convert Po2Tab");
	}
	
	public void ConvertAFile() {
		OpenDlg = new FileDialog(sShell,SWT.OPEN);
		String exStr[] = {"*.po"};
		OpenDlg.setFilterExtensions(exStr);
		try {
			converter = new Po2Tab(OpenDlg.open());
			converter.OpenFromFile();
			status_text.setText(OpenDlg.getFilterPath()+SYS_SPARATOR+OpenDlg.getFileName());
			System.out.println(converter.getFileLenght());
			textArea.setText(converter.getString());
			converter.SaveToFile();
		} catch (Exception e1) {
			e1.printStackTrace();
		}
	}
	
	public void ConvertFullPath() {
		DirectoryDialog dd = new DirectoryDialog(sShell,SWT.NONE);
		String Path = dd.open();
		Path += SYS_SPARATOR +"*.po";
		System.out.println("comming soon");
	}
	
	public void SaveAs() {
		SaveDlg = new FileDialog(sShell,SWT.SAVE);
		String exStr[] = {"*.tab"};
		SaveDlg.setFilterExtensions(exStr);
		try {
			SaveDlg.setFileName(OpenDlg.getFileName().replace(".po", ""));
			converter.SaveToFile(SaveDlg.open());
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		
	}
}
