# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from DoorAccessControl.idl.

use strict;

package Raritan::RPC::smartlock::DoorAccessControl;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "smartlock.DoorAccessControl:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::smartlock::DoorAccessControl::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_INVALID_SETTINGS => 1;

use constant ERR_NO_SUCH_ID => 2;

use constant ERR_MAX_RULES_REACHED => 3;

use Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule;

sub getDoorAccessRules($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDoorAccessRules', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule::decode($agent, $rsp->{'_ret_'}->[$i0]->{'value'});
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}

use Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule;

sub setAllDoorAccessRules($$$) {
    my ($self, $rules, $invalidRuleIds) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'rules'} = [];
    foreach my $key0 (keys %{$rules}) {
        my $value0 = $rules->{$key0};
        my $elem0 = {};
        $elem0->{'key'} = 1 * $key0;
        $elem0->{'value'} = Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule::encode($value0);
        push(@{$args->{'rules'}}, $elem0);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setAllDoorAccessRules', $args);
    $$invalidRuleIds = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'invalidRuleIds'}}; $i0++) {
        $$invalidRuleIds->[$i0] = $rsp->{'invalidRuleIds'}->[$i0];
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule;

sub addDoorAccessRule($$$) {
    my ($self, $rule, $ruleId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'rule'} = Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule::encode($rule);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addDoorAccessRule', $args);
    $$ruleId = $rsp->{'ruleId'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule;

sub modifyDoorAccessRule($$$) {
    my ($self, $id, $modifiedRule) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'id'} = 1 * $id;
    $args->{'modifiedRule'} = Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule::encode($modifiedRule);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'modifyDoorAccessRule', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub deleteDoorAccessRule($$) {
    my ($self, $id) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'id'} = 1 * $id;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'deleteDoorAccessRule', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('smartlock.DoorAccessControl', 1, 0, 0, 'Raritan::RPC::smartlock::DoorAccessControl');
1;
