% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retweets.R
\name{get_retweets}
\alias{get_retweets}
\alias{get_retweeters}
\title{Get the most recent retweets/retweeters}
\usage{
get_retweets(status_id, n = 100, parse = TRUE, token = NULL, ...)

get_retweeters(status_id, n = 100, parse = TRUE, token = NULL)
}
\arguments{
\item{status_id}{Tweet/status id.}

\item{n}{Number of results to retrieve. Must be <= 100.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{token}{Use this to override authentication for
a single API call. In many cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{...}{Other arguments used as parameters in the query sent to
Twitter's rest API, for example, \code{trim_user = TRUE}.}
}
\value{
Tweets data of the most recent retweets/retweeters of a given status.
}
\description{
\code{get_retweets()} returns the 100 most recent retweets of a tweet;
\code{get_retweeters()} returns the 100 most recent users who retweeted them.
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/post-and-engage/api-reference/get-statuses-retweets-id}

\url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/post-and-engage/api-reference/get-statuses-retweeters-ids}
}
