% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{as.htmlwidget.formattable}
\alias{as.htmlwidget.formattable}
\title{Convert formattable to an htmlwidget}
\usage{
\method{as.htmlwidget}{formattable}(x, width = "100\%", height = NULL, ...)
}
\arguments{
\item{x}{a \code{formattable} object to convert}

\item{width}{a valid \code{CSS} width}

\item{height}{a valid \code{CSS} height}

\item{...}{reserved for more parameters}
}
\value{
a \code{htmlwidget} object
}
\description{
formattable was originally designed to work in \code{rmarkdown} environments.
Conversion of a formattable to a htmlwidget will allow use in other contexts
such as console, RStudio Viewer, and Shiny.
}
\examples{
\dontrun{
library(formattable)
# mtcars (mpg background in gradient: the higher, the redder)
as.htmlwidget(
  formattable(mtcars, list(mpg = formatter("span",
   style = x ~ style(display = "block",
   "border-radius" = "4px",
   "padding-right" = "4px",
   color = "white",
   "background-color" = rgb(x/max(x), 0, 0))))
  )
)

# since an htmlwidget, composes well with other tags
library(htmltools)

browsable(
  tagList(
    tags$div( class="jumbotron"
              ,tags$h1( class = "text-center"
                        ,tags$span(class = "glyphicon glyphicon-fire")
                        ,"experimental as.htmlwidget at work"
              )
    )
    ,tags$div( class = "row"
               ,tags$div( class = "col-sm-2"
                          ,tags$p(class="bg-primary", "Hi, I am formattable htmlwidget.")
               )
               ,tags$div( class = "col-sm-6"
                          ,as.htmlwidget( formattable( mtcars ) )
               )
    )
  )
)
}
}
