% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5S.R
\name{H5Sselect_hyperslab}
\alias{H5Sselect_hyperslab}
\title{Perform operation between an existing selection and an another
hyperslab definition.}
\usage{
H5Sselect_hyperslab(
  h5space,
  op = h5default("H5S_SELECT"),
  start = NULL,
  stride = NULL,
  count = NULL,
  block = NULL
)
}
\arguments{
\item{h5space}{\linkS4class{H5IdComponent} object representing a dataspace.}

\item{op}{Character string defined the operation used to join the two
dataspaces.  See \code{h5const("H5S_SELECT")} for the list of available options.}

\item{start, stride, count, block}{Integer vectors, each with length equal
to the rank of the dataspace.  These parameters define the new hyperslab
to select.}
}
\description{
Combines a hyperslab selection specified by \code{start}, \code{stride}, \code{count} and
\code{block} arguments with the current selection for the dataspace
represented by \code{h5space}.
}
\details{
\code{H5Sselect_hyperslab} is similar to, but subtly different from,
\code{\link[=H5Scombine_hyperslab]{H5Scombine_hyperslab()}}.  The former modifies the selection of the
dataspace provided in the \code{h5space} argument, while the later returns a
new dataspace with the combined selection.
}
\examples{

## create a 1 dimensional dataspace
sid_1 <- H5Screate_simple(dims = 20)

## select a single block of 5 points in sid_1
## this is equivalent to [11:16] in R syntax
H5Sselect_hyperslab(sid_1, start = 11, stride = 1, 
                    block = 5, count = 1)
                    
## confirm we have selected 5 in our original dataspace
H5Sget_select_npoints(sid_1)

## combine the existing selection with a new
## selection consisting of 2 blocks each of 1 point
## equivalent to [c(3,5)] in R syntax
H5Sselect_hyperslab(sid_1, op = "H5S_SELECT_OR",
                     start = 3, stride = 2, 
                     block = 1, count = 2)

## The dataspace now has 7 points selected
H5Sget_select_npoints(sid_1)

## tidy up
H5Sclose(sid_1)

}
