% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefisto.R
\name{plot_smoothness}
\alias{plot_smoothness}
\title{Barplot showing the smoothness per factor}
\usage{
plot_smoothness(object, factors = "all", color = "cadetblue")
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object using MEFISTO.}

\item{factors}{character vector with the factors names, or numeric vector indicating the indices of the factors to use}

\item{color}{for the smooth part of the bar}
}
\value{
Returns a \code{ggplot2} object
}
\description{
Barplot indicating a smoothness score (between 0 (non-smooth) and 1 (smooth)) per factor
}
\details{
The smoothness score is given by the scale parameter for the underlying Gaussian process of each factor.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "MEFISTO_model.hdf5", package = "MOFA2")
model <- load_model(file)
smoothness_bars <- plot_smoothness(model)
}
