# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class SendMessageRequest(msrest.serialization.Model):
    """Represents the properties of a send message request.

    All required parameters must be populated in order to send to Azure.

    :param from_property: Required. The sender's phone number in E.164 format that is owned by the
     authenticated account.
    :type from_property: str
    :param to: Required. The recipients' phone number in E.164 format. In this version, only one
     recipient in the list is supported.
    :type to: list[str]
    :param message: Required. The contents of the message that will be sent to the recipient. The
     allowable content is defined by RFC 5724.
    :type message: str
    :param send_sms_options: Optional configuration for sending SMS messages.
    :type send_sms_options: ~azure.communication.sms.models.SendSmsOptions
    """

    _validation = {
        'from_property': {'required': True},
        'to': {'required': True},
        'message': {'required': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'from_property': {'key': 'from', 'type': 'str'},
        'to': {'key': 'to', 'type': '[str]'},
        'message': {'key': 'message', 'type': 'str'},
        'send_sms_options': {'key': 'sendSmsOptions', 'type': 'SendSmsOptions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SendMessageRequest, self).__init__(**kwargs)
        self.from_property = kwargs['from_property']
        self.to = kwargs['to']
        self.message = kwargs['message']
        self.send_sms_options = kwargs.get('send_sms_options', None)


class SendSmsOptions(msrest.serialization.Model):
    """Optional configuration for sending SMS messages.

    :param enable_delivery_report: Enable this flag to receive a delivery report for this message
     on the Azure Resource EventGrid.
    :type enable_delivery_report: bool
    """

    _attribute_map = {
        'enable_delivery_report': {'key': 'enableDeliveryReport', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SendSmsOptions, self).__init__(**kwargs)
        self.enable_delivery_report = kwargs.get('enable_delivery_report', None)


class SendSmsResponse(msrest.serialization.Model):
    """Response for a successful send Sms request.

    :param message_id: The identifier of the outgoing SMS message.
    :type message_id: str
    """

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SendSmsResponse, self).__init__(**kwargs)
        self.message_id = kwargs.get('message_id', None)
