---
title: PICOTOOL-LOAD
section: 1
header: User Commands
---
# NAME

picotool\-load \- Load the program / memory range stored in a file onto the device\.

# SYNOPSIS

picotool load \[\-\-ignore\-partitions\] \[\-\-family \<family\_id\>\] \[\-p \<partition\>\] \[\-n\] \[\-N\] \[\-u\] \[\-v\] \[\-x\] \<filename\> \[\-t \<type\>\] \[\-o \<offset\>\] \[device\-selection\]


# OPTIONS

Post load actions

**\-\-ignore\-partitions**
: When writing flash data, ignore the partition table and write toabsolute space

**\-\-family**
: Specify the family ID of the file to load

\<*family\_id*\>
: family ID to use for load

**\-p**, **\-\-partition**
: Specify the partition to load into

\<*partition*\>
: partition to load into

**\-n**, **\-\-no\-overwrite**
: When writing flash data, do not overwrite an existing program inflash\. If picotool cannot determine the size/presence of the programin flash, the command fails

**\-N**, **\-\-no\-overwrite\-unsafe**
: When writing flash data, do not overwrite an existing program inflash\. If picotool cannot determine the size/presence of the programin flash, the load continues anyway

**\-u**, **\-\-update**
: Skip writing flash sectors that already contain identical data

**\-v**, **\-\-verify**
: Verify the data was written correctly

**\-x**, **\-\-execute**
: Attempt to execute the downloaded file as a program after the load

File to load from

\<*filename*\>
: The file name

**\-t** \<*type*\>
: Specify file type \(uf2 \| elf \| bin\) explicitly, ignoring fileextension

BIN file options

**\-o**, **\-\-offset**
: Specify the load address for a BIN file

\<*offset*\>
: Load offset \(memory address; default 0x10000000\)

Target device selection

**\-\-bus** \<*bus*\>
: Filter devices by USB bus number

**\-\-address** \<*addr*\>
: Filter devices by USB device address

**\-\-vid** \<*vid*\>
: Filter by vendor id

**\-\-pid** \<*pid*\>
: Filter by product id

**\-\-ser** \<*ser*\>
: Filter by serial number

**\-f**, **\-\-force**
: Force a device not in BOOTSEL mode but running compatible code toreset so the command can be executed\. After executing the command\(unless the command itself is a 'reboot'\) the device will berebooted back to application mode

**\-F**, **\-\-force\-no\-reboot**
: Force a device not in BOOTSEL mode but running compatible code toreset so the command can be executed\. After executing the command\(unless the command itself is a 'reboot'\) the device will be leftconnected and accessible to picotool, but without the USB drivemounted

