// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Language;
use crate::Matrix;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoAlignment")]
pub enum Alignment {
    #[doc(alias = "PANGO_ALIGN_LEFT")]
    Left,
    #[doc(alias = "PANGO_ALIGN_CENTER")]
    Center,
    #[doc(alias = "PANGO_ALIGN_RIGHT")]
    Right,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Alignment {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Alignment::{}",
            match *self {
                Self::Left => "Left",
                Self::Center => "Center",
                Self::Right => "Right",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Alignment {
    type GlibType = ffi::PangoAlignment;

    fn into_glib(self) -> ffi::PangoAlignment {
        match self {
            Self::Left => ffi::PANGO_ALIGN_LEFT,
            Self::Center => ffi::PANGO_ALIGN_CENTER,
            Self::Right => ffi::PANGO_ALIGN_RIGHT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoAlignment> for Alignment {
    unsafe fn from_glib(value: ffi::PangoAlignment) -> Self {
        match value {
            ffi::PANGO_ALIGN_LEFT => Self::Left,
            ffi::PANGO_ALIGN_CENTER => Self::Center,
            ffi::PANGO_ALIGN_RIGHT => Self::Right,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Alignment {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_alignment_get_type()) }
    }
}

impl glib::value::ValueType for Alignment {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Alignment {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Alignment {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoAttrType")]
pub enum AttrType {
    #[doc(alias = "PANGO_ATTR_INVALID")]
    Invalid,
    #[doc(alias = "PANGO_ATTR_LANGUAGE")]
    Language,
    #[doc(alias = "PANGO_ATTR_FAMILY")]
    Family,
    #[doc(alias = "PANGO_ATTR_STYLE")]
    Style,
    #[doc(alias = "PANGO_ATTR_WEIGHT")]
    Weight,
    #[doc(alias = "PANGO_ATTR_VARIANT")]
    Variant,
    #[doc(alias = "PANGO_ATTR_STRETCH")]
    Stretch,
    #[doc(alias = "PANGO_ATTR_SIZE")]
    Size,
    #[doc(alias = "PANGO_ATTR_FONT_DESC")]
    FontDesc,
    #[doc(alias = "PANGO_ATTR_FOREGROUND")]
    Foreground,
    #[doc(alias = "PANGO_ATTR_BACKGROUND")]
    Background,
    #[doc(alias = "PANGO_ATTR_UNDERLINE")]
    Underline,
    #[doc(alias = "PANGO_ATTR_STRIKETHROUGH")]
    Strikethrough,
    #[doc(alias = "PANGO_ATTR_RISE")]
    Rise,
    #[doc(alias = "PANGO_ATTR_SHAPE")]
    Shape,
    #[doc(alias = "PANGO_ATTR_SCALE")]
    Scale,
    #[doc(alias = "PANGO_ATTR_FALLBACK")]
    Fallback,
    #[doc(alias = "PANGO_ATTR_LETTER_SPACING")]
    LetterSpacing,
    #[doc(alias = "PANGO_ATTR_UNDERLINE_COLOR")]
    UnderlineColor,
    #[doc(alias = "PANGO_ATTR_STRIKETHROUGH_COLOR")]
    StrikethroughColor,
    #[doc(alias = "PANGO_ATTR_ABSOLUTE_SIZE")]
    AbsoluteSize,
    #[doc(alias = "PANGO_ATTR_GRAVITY")]
    Gravity,
    #[doc(alias = "PANGO_ATTR_GRAVITY_HINT")]
    GravityHint,
    #[doc(alias = "PANGO_ATTR_FONT_FEATURES")]
    FontFeatures,
    #[doc(alias = "PANGO_ATTR_FOREGROUND_ALPHA")]
    ForegroundAlpha,
    #[doc(alias = "PANGO_ATTR_BACKGROUND_ALPHA")]
    BackgroundAlpha,
    #[doc(alias = "PANGO_ATTR_ALLOW_BREAKS")]
    AllowBreaks,
    #[doc(alias = "PANGO_ATTR_SHOW")]
    Show,
    #[doc(alias = "PANGO_ATTR_INSERT_HYPHENS")]
    InsertHyphens,
    #[doc(alias = "PANGO_ATTR_OVERLINE")]
    Overline,
    #[doc(alias = "PANGO_ATTR_OVERLINE_COLOR")]
    OverlineColor,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_ATTR_LINE_HEIGHT")]
    LineHeight,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_ATTR_ABSOLUTE_LINE_HEIGHT")]
    AbsoluteLineHeight,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_ATTR_TEXT_TRANSFORM")]
    TextTransform,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_ATTR_WORD")]
    Word,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_ATTR_SENTENCE")]
    Sentence,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_ATTR_BASELINE_SHIFT")]
    BaselineShift,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_ATTR_FONT_SCALE")]
    FontScale,
    #[doc(hidden)]
    __Unknown(i32),
}

impl AttrType {
    #[doc(alias = "pango_attr_type_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::pango_attr_type_get_name(self.into_glib())) }
    }
}

impl fmt::Display for AttrType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AttrType::{}",
            match *self {
                Self::Invalid => "Invalid",
                Self::Language => "Language",
                Self::Family => "Family",
                Self::Style => "Style",
                Self::Weight => "Weight",
                Self::Variant => "Variant",
                Self::Stretch => "Stretch",
                Self::Size => "Size",
                Self::FontDesc => "FontDesc",
                Self::Foreground => "Foreground",
                Self::Background => "Background",
                Self::Underline => "Underline",
                Self::Strikethrough => "Strikethrough",
                Self::Rise => "Rise",
                Self::Shape => "Shape",
                Self::Scale => "Scale",
                Self::Fallback => "Fallback",
                Self::LetterSpacing => "LetterSpacing",
                Self::UnderlineColor => "UnderlineColor",
                Self::StrikethroughColor => "StrikethroughColor",
                Self::AbsoluteSize => "AbsoluteSize",
                Self::Gravity => "Gravity",
                Self::GravityHint => "GravityHint",
                Self::FontFeatures => "FontFeatures",
                Self::ForegroundAlpha => "ForegroundAlpha",
                Self::BackgroundAlpha => "BackgroundAlpha",
                Self::AllowBreaks => "AllowBreaks",
                Self::Show => "Show",
                Self::InsertHyphens => "InsertHyphens",
                Self::Overline => "Overline",
                Self::OverlineColor => "OverlineColor",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::LineHeight => "LineHeight",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::AbsoluteLineHeight => "AbsoluteLineHeight",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::TextTransform => "TextTransform",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::Word => "Word",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::Sentence => "Sentence",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::BaselineShift => "BaselineShift",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::FontScale => "FontScale",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AttrType {
    type GlibType = ffi::PangoAttrType;

    fn into_glib(self) -> ffi::PangoAttrType {
        match self {
            Self::Invalid => ffi::PANGO_ATTR_INVALID,
            Self::Language => ffi::PANGO_ATTR_LANGUAGE,
            Self::Family => ffi::PANGO_ATTR_FAMILY,
            Self::Style => ffi::PANGO_ATTR_STYLE,
            Self::Weight => ffi::PANGO_ATTR_WEIGHT,
            Self::Variant => ffi::PANGO_ATTR_VARIANT,
            Self::Stretch => ffi::PANGO_ATTR_STRETCH,
            Self::Size => ffi::PANGO_ATTR_SIZE,
            Self::FontDesc => ffi::PANGO_ATTR_FONT_DESC,
            Self::Foreground => ffi::PANGO_ATTR_FOREGROUND,
            Self::Background => ffi::PANGO_ATTR_BACKGROUND,
            Self::Underline => ffi::PANGO_ATTR_UNDERLINE,
            Self::Strikethrough => ffi::PANGO_ATTR_STRIKETHROUGH,
            Self::Rise => ffi::PANGO_ATTR_RISE,
            Self::Shape => ffi::PANGO_ATTR_SHAPE,
            Self::Scale => ffi::PANGO_ATTR_SCALE,
            Self::Fallback => ffi::PANGO_ATTR_FALLBACK,
            Self::LetterSpacing => ffi::PANGO_ATTR_LETTER_SPACING,
            Self::UnderlineColor => ffi::PANGO_ATTR_UNDERLINE_COLOR,
            Self::StrikethroughColor => ffi::PANGO_ATTR_STRIKETHROUGH_COLOR,
            Self::AbsoluteSize => ffi::PANGO_ATTR_ABSOLUTE_SIZE,
            Self::Gravity => ffi::PANGO_ATTR_GRAVITY,
            Self::GravityHint => ffi::PANGO_ATTR_GRAVITY_HINT,
            Self::FontFeatures => ffi::PANGO_ATTR_FONT_FEATURES,
            Self::ForegroundAlpha => ffi::PANGO_ATTR_FOREGROUND_ALPHA,
            Self::BackgroundAlpha => ffi::PANGO_ATTR_BACKGROUND_ALPHA,
            Self::AllowBreaks => ffi::PANGO_ATTR_ALLOW_BREAKS,
            Self::Show => ffi::PANGO_ATTR_SHOW,
            Self::InsertHyphens => ffi::PANGO_ATTR_INSERT_HYPHENS,
            Self::Overline => ffi::PANGO_ATTR_OVERLINE,
            Self::OverlineColor => ffi::PANGO_ATTR_OVERLINE_COLOR,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::LineHeight => ffi::PANGO_ATTR_LINE_HEIGHT,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::AbsoluteLineHeight => ffi::PANGO_ATTR_ABSOLUTE_LINE_HEIGHT,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::TextTransform => ffi::PANGO_ATTR_TEXT_TRANSFORM,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::Word => ffi::PANGO_ATTR_WORD,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::Sentence => ffi::PANGO_ATTR_SENTENCE,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::BaselineShift => ffi::PANGO_ATTR_BASELINE_SHIFT,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::FontScale => ffi::PANGO_ATTR_FONT_SCALE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoAttrType> for AttrType {
    unsafe fn from_glib(value: ffi::PangoAttrType) -> Self {
        match value {
            ffi::PANGO_ATTR_INVALID => Self::Invalid,
            ffi::PANGO_ATTR_LANGUAGE => Self::Language,
            ffi::PANGO_ATTR_FAMILY => Self::Family,
            ffi::PANGO_ATTR_STYLE => Self::Style,
            ffi::PANGO_ATTR_WEIGHT => Self::Weight,
            ffi::PANGO_ATTR_VARIANT => Self::Variant,
            ffi::PANGO_ATTR_STRETCH => Self::Stretch,
            ffi::PANGO_ATTR_SIZE => Self::Size,
            ffi::PANGO_ATTR_FONT_DESC => Self::FontDesc,
            ffi::PANGO_ATTR_FOREGROUND => Self::Foreground,
            ffi::PANGO_ATTR_BACKGROUND => Self::Background,
            ffi::PANGO_ATTR_UNDERLINE => Self::Underline,
            ffi::PANGO_ATTR_STRIKETHROUGH => Self::Strikethrough,
            ffi::PANGO_ATTR_RISE => Self::Rise,
            ffi::PANGO_ATTR_SHAPE => Self::Shape,
            ffi::PANGO_ATTR_SCALE => Self::Scale,
            ffi::PANGO_ATTR_FALLBACK => Self::Fallback,
            ffi::PANGO_ATTR_LETTER_SPACING => Self::LetterSpacing,
            ffi::PANGO_ATTR_UNDERLINE_COLOR => Self::UnderlineColor,
            ffi::PANGO_ATTR_STRIKETHROUGH_COLOR => Self::StrikethroughColor,
            ffi::PANGO_ATTR_ABSOLUTE_SIZE => Self::AbsoluteSize,
            ffi::PANGO_ATTR_GRAVITY => Self::Gravity,
            ffi::PANGO_ATTR_GRAVITY_HINT => Self::GravityHint,
            ffi::PANGO_ATTR_FONT_FEATURES => Self::FontFeatures,
            ffi::PANGO_ATTR_FOREGROUND_ALPHA => Self::ForegroundAlpha,
            ffi::PANGO_ATTR_BACKGROUND_ALPHA => Self::BackgroundAlpha,
            ffi::PANGO_ATTR_ALLOW_BREAKS => Self::AllowBreaks,
            ffi::PANGO_ATTR_SHOW => Self::Show,
            ffi::PANGO_ATTR_INSERT_HYPHENS => Self::InsertHyphens,
            ffi::PANGO_ATTR_OVERLINE => Self::Overline,
            ffi::PANGO_ATTR_OVERLINE_COLOR => Self::OverlineColor,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_ATTR_LINE_HEIGHT => Self::LineHeight,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_ATTR_ABSOLUTE_LINE_HEIGHT => Self::AbsoluteLineHeight,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_ATTR_TEXT_TRANSFORM => Self::TextTransform,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_ATTR_WORD => Self::Word,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_ATTR_SENTENCE => Self::Sentence,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_ATTR_BASELINE_SHIFT => Self::BaselineShift,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_ATTR_FONT_SCALE => Self::FontScale,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AttrType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_attr_type_get_type()) }
    }
}

impl glib::value::ValueType for AttrType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AttrType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AttrType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoBaselineShift")]
pub enum BaselineShift {
    #[doc(alias = "PANGO_BASELINE_SHIFT_NONE")]
    None,
    #[doc(alias = "PANGO_BASELINE_SHIFT_SUPERSCRIPT")]
    Superscript,
    #[doc(alias = "PANGO_BASELINE_SHIFT_SUBSCRIPT")]
    Subscript,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl fmt::Display for BaselineShift {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "BaselineShift::{}",
            match *self {
                Self::None => "None",
                Self::Superscript => "Superscript",
                Self::Subscript => "Subscript",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[doc(hidden)]
impl IntoGlib for BaselineShift {
    type GlibType = ffi::PangoBaselineShift;

    fn into_glib(self) -> ffi::PangoBaselineShift {
        match self {
            Self::None => ffi::PANGO_BASELINE_SHIFT_NONE,
            Self::Superscript => ffi::PANGO_BASELINE_SHIFT_SUPERSCRIPT,
            Self::Subscript => ffi::PANGO_BASELINE_SHIFT_SUBSCRIPT,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[doc(hidden)]
impl FromGlib<ffi::PangoBaselineShift> for BaselineShift {
    unsafe fn from_glib(value: ffi::PangoBaselineShift) -> Self {
        match value {
            ffi::PANGO_BASELINE_SHIFT_NONE => Self::None,
            ffi::PANGO_BASELINE_SHIFT_SUPERSCRIPT => Self::Superscript,
            ffi::PANGO_BASELINE_SHIFT_SUBSCRIPT => Self::Subscript,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl StaticType for BaselineShift {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_baseline_shift_get_type()) }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl glib::value::ValueType for BaselineShift {
    type Type = Self;
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
unsafe impl<'a> FromValue<'a> for BaselineShift {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl ToValue for BaselineShift {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "v1_44", deprecated = "Since 1.44")]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoBidiType")]
pub enum BidiType {
    #[doc(alias = "PANGO_BIDI_TYPE_L")]
    L,
    #[doc(alias = "PANGO_BIDI_TYPE_LRE")]
    Lre,
    #[doc(alias = "PANGO_BIDI_TYPE_LRO")]
    Lro,
    #[doc(alias = "PANGO_BIDI_TYPE_R")]
    R,
    #[doc(alias = "PANGO_BIDI_TYPE_AL")]
    Al,
    #[doc(alias = "PANGO_BIDI_TYPE_RLE")]
    Rle,
    #[doc(alias = "PANGO_BIDI_TYPE_RLO")]
    Rlo,
    #[doc(alias = "PANGO_BIDI_TYPE_PDF")]
    Pdf,
    #[doc(alias = "PANGO_BIDI_TYPE_EN")]
    En,
    #[doc(alias = "PANGO_BIDI_TYPE_ES")]
    Es,
    #[doc(alias = "PANGO_BIDI_TYPE_ET")]
    Et,
    #[doc(alias = "PANGO_BIDI_TYPE_AN")]
    An,
    #[doc(alias = "PANGO_BIDI_TYPE_CS")]
    Cs,
    #[doc(alias = "PANGO_BIDI_TYPE_NSM")]
    Nsm,
    #[doc(alias = "PANGO_BIDI_TYPE_BN")]
    Bn,
    #[doc(alias = "PANGO_BIDI_TYPE_B")]
    B,
    #[doc(alias = "PANGO_BIDI_TYPE_S")]
    S,
    #[doc(alias = "PANGO_BIDI_TYPE_WS")]
    Ws,
    #[doc(alias = "PANGO_BIDI_TYPE_ON")]
    On,
    #[doc(alias = "PANGO_BIDI_TYPE_LRI")]
    Lri,
    #[doc(alias = "PANGO_BIDI_TYPE_RLI")]
    Rli,
    #[doc(alias = "PANGO_BIDI_TYPE_FSI")]
    Fsi,
    #[doc(alias = "PANGO_BIDI_TYPE_PDI")]
    Pdi,
    #[doc(hidden)]
    __Unknown(i32),
}

impl BidiType {
    #[doc(alias = "pango_bidi_type_for_unichar")]
    pub fn for_unichar(ch: char) -> BidiType {
        unsafe { from_glib(ffi::pango_bidi_type_for_unichar(ch.into_glib())) }
    }
}

impl fmt::Display for BidiType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "BidiType::{}",
            match *self {
                Self::L => "L",
                Self::Lre => "Lre",
                Self::Lro => "Lro",
                Self::R => "R",
                Self::Al => "Al",
                Self::Rle => "Rle",
                Self::Rlo => "Rlo",
                Self::Pdf => "Pdf",
                Self::En => "En",
                Self::Es => "Es",
                Self::Et => "Et",
                Self::An => "An",
                Self::Cs => "Cs",
                Self::Nsm => "Nsm",
                Self::Bn => "Bn",
                Self::B => "B",
                Self::S => "S",
                Self::Ws => "Ws",
                Self::On => "On",
                Self::Lri => "Lri",
                Self::Rli => "Rli",
                Self::Fsi => "Fsi",
                Self::Pdi => "Pdi",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for BidiType {
    type GlibType = ffi::PangoBidiType;

    fn into_glib(self) -> ffi::PangoBidiType {
        match self {
            Self::L => ffi::PANGO_BIDI_TYPE_L,
            Self::Lre => ffi::PANGO_BIDI_TYPE_LRE,
            Self::Lro => ffi::PANGO_BIDI_TYPE_LRO,
            Self::R => ffi::PANGO_BIDI_TYPE_R,
            Self::Al => ffi::PANGO_BIDI_TYPE_AL,
            Self::Rle => ffi::PANGO_BIDI_TYPE_RLE,
            Self::Rlo => ffi::PANGO_BIDI_TYPE_RLO,
            Self::Pdf => ffi::PANGO_BIDI_TYPE_PDF,
            Self::En => ffi::PANGO_BIDI_TYPE_EN,
            Self::Es => ffi::PANGO_BIDI_TYPE_ES,
            Self::Et => ffi::PANGO_BIDI_TYPE_ET,
            Self::An => ffi::PANGO_BIDI_TYPE_AN,
            Self::Cs => ffi::PANGO_BIDI_TYPE_CS,
            Self::Nsm => ffi::PANGO_BIDI_TYPE_NSM,
            Self::Bn => ffi::PANGO_BIDI_TYPE_BN,
            Self::B => ffi::PANGO_BIDI_TYPE_B,
            Self::S => ffi::PANGO_BIDI_TYPE_S,
            Self::Ws => ffi::PANGO_BIDI_TYPE_WS,
            Self::On => ffi::PANGO_BIDI_TYPE_ON,
            Self::Lri => ffi::PANGO_BIDI_TYPE_LRI,
            Self::Rli => ffi::PANGO_BIDI_TYPE_RLI,
            Self::Fsi => ffi::PANGO_BIDI_TYPE_FSI,
            Self::Pdi => ffi::PANGO_BIDI_TYPE_PDI,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoBidiType> for BidiType {
    unsafe fn from_glib(value: ffi::PangoBidiType) -> Self {
        match value {
            ffi::PANGO_BIDI_TYPE_L => Self::L,
            ffi::PANGO_BIDI_TYPE_LRE => Self::Lre,
            ffi::PANGO_BIDI_TYPE_LRO => Self::Lro,
            ffi::PANGO_BIDI_TYPE_R => Self::R,
            ffi::PANGO_BIDI_TYPE_AL => Self::Al,
            ffi::PANGO_BIDI_TYPE_RLE => Self::Rle,
            ffi::PANGO_BIDI_TYPE_RLO => Self::Rlo,
            ffi::PANGO_BIDI_TYPE_PDF => Self::Pdf,
            ffi::PANGO_BIDI_TYPE_EN => Self::En,
            ffi::PANGO_BIDI_TYPE_ES => Self::Es,
            ffi::PANGO_BIDI_TYPE_ET => Self::Et,
            ffi::PANGO_BIDI_TYPE_AN => Self::An,
            ffi::PANGO_BIDI_TYPE_CS => Self::Cs,
            ffi::PANGO_BIDI_TYPE_NSM => Self::Nsm,
            ffi::PANGO_BIDI_TYPE_BN => Self::Bn,
            ffi::PANGO_BIDI_TYPE_B => Self::B,
            ffi::PANGO_BIDI_TYPE_S => Self::S,
            ffi::PANGO_BIDI_TYPE_WS => Self::Ws,
            ffi::PANGO_BIDI_TYPE_ON => Self::On,
            ffi::PANGO_BIDI_TYPE_LRI => Self::Lri,
            ffi::PANGO_BIDI_TYPE_RLI => Self::Rli,
            ffi::PANGO_BIDI_TYPE_FSI => Self::Fsi,
            ffi::PANGO_BIDI_TYPE_PDI => Self::Pdi,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for BidiType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_bidi_type_get_type()) }
    }
}

impl glib::value::ValueType for BidiType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BidiType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for BidiType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoCoverageLevel")]
pub enum CoverageLevel {
    #[doc(alias = "PANGO_COVERAGE_NONE")]
    None,
    #[doc(alias = "PANGO_COVERAGE_FALLBACK")]
    Fallback,
    #[doc(alias = "PANGO_COVERAGE_APPROXIMATE")]
    Approximate,
    #[doc(alias = "PANGO_COVERAGE_EXACT")]
    Exact,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CoverageLevel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CoverageLevel::{}",
            match *self {
                Self::None => "None",
                Self::Fallback => "Fallback",
                Self::Approximate => "Approximate",
                Self::Exact => "Exact",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CoverageLevel {
    type GlibType = ffi::PangoCoverageLevel;

    fn into_glib(self) -> ffi::PangoCoverageLevel {
        match self {
            Self::None => ffi::PANGO_COVERAGE_NONE,
            Self::Fallback => ffi::PANGO_COVERAGE_FALLBACK,
            Self::Approximate => ffi::PANGO_COVERAGE_APPROXIMATE,
            Self::Exact => ffi::PANGO_COVERAGE_EXACT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoCoverageLevel> for CoverageLevel {
    unsafe fn from_glib(value: ffi::PangoCoverageLevel) -> Self {
        match value {
            ffi::PANGO_COVERAGE_NONE => Self::None,
            ffi::PANGO_COVERAGE_FALLBACK => Self::Fallback,
            ffi::PANGO_COVERAGE_APPROXIMATE => Self::Approximate,
            ffi::PANGO_COVERAGE_EXACT => Self::Exact,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CoverageLevel {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_coverage_level_get_type()) }
    }
}

impl glib::value::ValueType for CoverageLevel {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CoverageLevel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CoverageLevel {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoDirection")]
pub enum Direction {
    #[doc(alias = "PANGO_DIRECTION_LTR")]
    Ltr,
    #[doc(alias = "PANGO_DIRECTION_RTL")]
    Rtl,
    #[doc(alias = "PANGO_DIRECTION_TTB_LTR")]
    TtbLtr,
    #[doc(alias = "PANGO_DIRECTION_TTB_RTL")]
    TtbRtl,
    #[doc(alias = "PANGO_DIRECTION_WEAK_LTR")]
    WeakLtr,
    #[doc(alias = "PANGO_DIRECTION_WEAK_RTL")]
    WeakRtl,
    #[doc(alias = "PANGO_DIRECTION_NEUTRAL")]
    Neutral,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Direction {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Direction::{}",
            match *self {
                Self::Ltr => "Ltr",
                Self::Rtl => "Rtl",
                Self::TtbLtr => "TtbLtr",
                Self::TtbRtl => "TtbRtl",
                Self::WeakLtr => "WeakLtr",
                Self::WeakRtl => "WeakRtl",
                Self::Neutral => "Neutral",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Direction {
    type GlibType = ffi::PangoDirection;

    fn into_glib(self) -> ffi::PangoDirection {
        match self {
            Self::Ltr => ffi::PANGO_DIRECTION_LTR,
            Self::Rtl => ffi::PANGO_DIRECTION_RTL,
            Self::TtbLtr => ffi::PANGO_DIRECTION_TTB_LTR,
            Self::TtbRtl => ffi::PANGO_DIRECTION_TTB_RTL,
            Self::WeakLtr => ffi::PANGO_DIRECTION_WEAK_LTR,
            Self::WeakRtl => ffi::PANGO_DIRECTION_WEAK_RTL,
            Self::Neutral => ffi::PANGO_DIRECTION_NEUTRAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoDirection> for Direction {
    unsafe fn from_glib(value: ffi::PangoDirection) -> Self {
        match value {
            ffi::PANGO_DIRECTION_LTR => Self::Ltr,
            ffi::PANGO_DIRECTION_RTL => Self::Rtl,
            ffi::PANGO_DIRECTION_TTB_LTR => Self::TtbLtr,
            ffi::PANGO_DIRECTION_TTB_RTL => Self::TtbRtl,
            ffi::PANGO_DIRECTION_WEAK_LTR => Self::WeakLtr,
            ffi::PANGO_DIRECTION_WEAK_RTL => Self::WeakRtl,
            ffi::PANGO_DIRECTION_NEUTRAL => Self::Neutral,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Direction {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_direction_get_type()) }
    }
}

impl glib::value::ValueType for Direction {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Direction {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Direction {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoEllipsizeMode")]
pub enum EllipsizeMode {
    #[doc(alias = "PANGO_ELLIPSIZE_NONE")]
    None,
    #[doc(alias = "PANGO_ELLIPSIZE_START")]
    Start,
    #[doc(alias = "PANGO_ELLIPSIZE_MIDDLE")]
    Middle,
    #[doc(alias = "PANGO_ELLIPSIZE_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for EllipsizeMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "EllipsizeMode::{}",
            match *self {
                Self::None => "None",
                Self::Start => "Start",
                Self::Middle => "Middle",
                Self::End => "End",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for EllipsizeMode {
    type GlibType = ffi::PangoEllipsizeMode;

    fn into_glib(self) -> ffi::PangoEllipsizeMode {
        match self {
            Self::None => ffi::PANGO_ELLIPSIZE_NONE,
            Self::Start => ffi::PANGO_ELLIPSIZE_START,
            Self::Middle => ffi::PANGO_ELLIPSIZE_MIDDLE,
            Self::End => ffi::PANGO_ELLIPSIZE_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoEllipsizeMode> for EllipsizeMode {
    unsafe fn from_glib(value: ffi::PangoEllipsizeMode) -> Self {
        match value {
            ffi::PANGO_ELLIPSIZE_NONE => Self::None,
            ffi::PANGO_ELLIPSIZE_START => Self::Start,
            ffi::PANGO_ELLIPSIZE_MIDDLE => Self::Middle,
            ffi::PANGO_ELLIPSIZE_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for EllipsizeMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_ellipsize_mode_get_type()) }
    }
}

impl glib::value::ValueType for EllipsizeMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for EllipsizeMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for EllipsizeMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoFontScale")]
pub enum FontScale {
    #[doc(alias = "PANGO_FONT_SCALE_NONE")]
    None,
    #[doc(alias = "PANGO_FONT_SCALE_SUPERSCRIPT")]
    Superscript,
    #[doc(alias = "PANGO_FONT_SCALE_SUBSCRIPT")]
    Subscript,
    #[doc(alias = "PANGO_FONT_SCALE_SMALL_CAPS")]
    SmallCaps,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl fmt::Display for FontScale {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FontScale::{}",
            match *self {
                Self::None => "None",
                Self::Superscript => "Superscript",
                Self::Subscript => "Subscript",
                Self::SmallCaps => "SmallCaps",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[doc(hidden)]
impl IntoGlib for FontScale {
    type GlibType = ffi::PangoFontScale;

    fn into_glib(self) -> ffi::PangoFontScale {
        match self {
            Self::None => ffi::PANGO_FONT_SCALE_NONE,
            Self::Superscript => ffi::PANGO_FONT_SCALE_SUPERSCRIPT,
            Self::Subscript => ffi::PANGO_FONT_SCALE_SUBSCRIPT,
            Self::SmallCaps => ffi::PANGO_FONT_SCALE_SMALL_CAPS,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[doc(hidden)]
impl FromGlib<ffi::PangoFontScale> for FontScale {
    unsafe fn from_glib(value: ffi::PangoFontScale) -> Self {
        match value {
            ffi::PANGO_FONT_SCALE_NONE => Self::None,
            ffi::PANGO_FONT_SCALE_SUPERSCRIPT => Self::Superscript,
            ffi::PANGO_FONT_SCALE_SUBSCRIPT => Self::Subscript,
            ffi::PANGO_FONT_SCALE_SMALL_CAPS => Self::SmallCaps,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl StaticType for FontScale {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_font_scale_get_type()) }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl glib::value::ValueType for FontScale {
    type Type = Self;
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
unsafe impl<'a> FromValue<'a> for FontScale {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl ToValue for FontScale {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoGravity")]
pub enum Gravity {
    #[doc(alias = "PANGO_GRAVITY_SOUTH")]
    South,
    #[doc(alias = "PANGO_GRAVITY_EAST")]
    East,
    #[doc(alias = "PANGO_GRAVITY_NORTH")]
    North,
    #[doc(alias = "PANGO_GRAVITY_WEST")]
    West,
    #[doc(alias = "PANGO_GRAVITY_AUTO")]
    Auto,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Gravity {
    #[doc(alias = "pango_gravity_get_for_matrix")]
    #[doc(alias = "get_for_matrix")]
    pub fn for_matrix(matrix: Option<&Matrix>) -> Gravity {
        unsafe { from_glib(ffi::pango_gravity_get_for_matrix(matrix.to_glib_none().0)) }
    }

    #[doc(alias = "pango_gravity_get_for_script")]
    #[doc(alias = "get_for_script")]
    pub fn for_script(script: Script, base_gravity: Gravity, hint: GravityHint) -> Gravity {
        unsafe {
            from_glib(ffi::pango_gravity_get_for_script(
                script.into_glib(),
                base_gravity.into_glib(),
                hint.into_glib(),
            ))
        }
    }

    #[doc(alias = "pango_gravity_get_for_script_and_width")]
    #[doc(alias = "get_for_script_and_width")]
    pub fn for_script_and_width(
        script: Script,
        wide: bool,
        base_gravity: Gravity,
        hint: GravityHint,
    ) -> Gravity {
        unsafe {
            from_glib(ffi::pango_gravity_get_for_script_and_width(
                script.into_glib(),
                wide.into_glib(),
                base_gravity.into_glib(),
                hint.into_glib(),
            ))
        }
    }

    #[doc(alias = "pango_gravity_to_rotation")]
    pub fn to_rotation(self) -> f64 {
        unsafe { ffi::pango_gravity_to_rotation(self.into_glib()) }
    }
}

impl fmt::Display for Gravity {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Gravity::{}",
            match *self {
                Self::South => "South",
                Self::East => "East",
                Self::North => "North",
                Self::West => "West",
                Self::Auto => "Auto",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Gravity {
    type GlibType = ffi::PangoGravity;

    fn into_glib(self) -> ffi::PangoGravity {
        match self {
            Self::South => ffi::PANGO_GRAVITY_SOUTH,
            Self::East => ffi::PANGO_GRAVITY_EAST,
            Self::North => ffi::PANGO_GRAVITY_NORTH,
            Self::West => ffi::PANGO_GRAVITY_WEST,
            Self::Auto => ffi::PANGO_GRAVITY_AUTO,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoGravity> for Gravity {
    unsafe fn from_glib(value: ffi::PangoGravity) -> Self {
        match value {
            ffi::PANGO_GRAVITY_SOUTH => Self::South,
            ffi::PANGO_GRAVITY_EAST => Self::East,
            ffi::PANGO_GRAVITY_NORTH => Self::North,
            ffi::PANGO_GRAVITY_WEST => Self::West,
            ffi::PANGO_GRAVITY_AUTO => Self::Auto,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Gravity {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_gravity_get_type()) }
    }
}

impl glib::value::ValueType for Gravity {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Gravity {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Gravity {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoGravityHint")]
pub enum GravityHint {
    #[doc(alias = "PANGO_GRAVITY_HINT_NATURAL")]
    Natural,
    #[doc(alias = "PANGO_GRAVITY_HINT_STRONG")]
    Strong,
    #[doc(alias = "PANGO_GRAVITY_HINT_LINE")]
    Line,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for GravityHint {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "GravityHint::{}",
            match *self {
                Self::Natural => "Natural",
                Self::Strong => "Strong",
                Self::Line => "Line",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for GravityHint {
    type GlibType = ffi::PangoGravityHint;

    fn into_glib(self) -> ffi::PangoGravityHint {
        match self {
            Self::Natural => ffi::PANGO_GRAVITY_HINT_NATURAL,
            Self::Strong => ffi::PANGO_GRAVITY_HINT_STRONG,
            Self::Line => ffi::PANGO_GRAVITY_HINT_LINE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoGravityHint> for GravityHint {
    unsafe fn from_glib(value: ffi::PangoGravityHint) -> Self {
        match value {
            ffi::PANGO_GRAVITY_HINT_NATURAL => Self::Natural,
            ffi::PANGO_GRAVITY_HINT_STRONG => Self::Strong,
            ffi::PANGO_GRAVITY_HINT_LINE => Self::Line,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for GravityHint {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_gravity_hint_get_type()) }
    }
}

impl glib::value::ValueType for GravityHint {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GravityHint {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GravityHint {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_46", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_46")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoOverline")]
pub enum Overline {
    #[doc(alias = "PANGO_OVERLINE_NONE")]
    None,
    #[doc(alias = "PANGO_OVERLINE_SINGLE")]
    Single,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_46", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_46")))]
impl fmt::Display for Overline {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Overline::{}",
            match *self {
                Self::None => "None",
                Self::Single => "Single",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v1_46", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_46")))]
#[doc(hidden)]
impl IntoGlib for Overline {
    type GlibType = ffi::PangoOverline;

    fn into_glib(self) -> ffi::PangoOverline {
        match self {
            Self::None => ffi::PANGO_OVERLINE_NONE,
            Self::Single => ffi::PANGO_OVERLINE_SINGLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_46", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_46")))]
#[doc(hidden)]
impl FromGlib<ffi::PangoOverline> for Overline {
    unsafe fn from_glib(value: ffi::PangoOverline) -> Self {
        match value {
            ffi::PANGO_OVERLINE_NONE => Self::None,
            ffi::PANGO_OVERLINE_SINGLE => Self::Single,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_46", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_46")))]
impl StaticType for Overline {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_overline_get_type()) }
    }
}

#[cfg(any(feature = "v1_46", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_46")))]
impl glib::value::ValueType for Overline {
    type Type = Self;
}

#[cfg(any(feature = "v1_46", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_46")))]
unsafe impl<'a> FromValue<'a> for Overline {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_46", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_46")))]
impl ToValue for Overline {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoRenderPart")]
pub enum RenderPart {
    #[doc(alias = "PANGO_RENDER_PART_FOREGROUND")]
    Foreground,
    #[doc(alias = "PANGO_RENDER_PART_BACKGROUND")]
    Background,
    #[doc(alias = "PANGO_RENDER_PART_UNDERLINE")]
    Underline,
    #[doc(alias = "PANGO_RENDER_PART_STRIKETHROUGH")]
    Strikethrough,
    #[doc(alias = "PANGO_RENDER_PART_OVERLINE")]
    Overline,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RenderPart {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RenderPart::{}",
            match *self {
                Self::Foreground => "Foreground",
                Self::Background => "Background",
                Self::Underline => "Underline",
                Self::Strikethrough => "Strikethrough",
                Self::Overline => "Overline",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RenderPart {
    type GlibType = ffi::PangoRenderPart;

    fn into_glib(self) -> ffi::PangoRenderPart {
        match self {
            Self::Foreground => ffi::PANGO_RENDER_PART_FOREGROUND,
            Self::Background => ffi::PANGO_RENDER_PART_BACKGROUND,
            Self::Underline => ffi::PANGO_RENDER_PART_UNDERLINE,
            Self::Strikethrough => ffi::PANGO_RENDER_PART_STRIKETHROUGH,
            Self::Overline => ffi::PANGO_RENDER_PART_OVERLINE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoRenderPart> for RenderPart {
    unsafe fn from_glib(value: ffi::PangoRenderPart) -> Self {
        match value {
            ffi::PANGO_RENDER_PART_FOREGROUND => Self::Foreground,
            ffi::PANGO_RENDER_PART_BACKGROUND => Self::Background,
            ffi::PANGO_RENDER_PART_UNDERLINE => Self::Underline,
            ffi::PANGO_RENDER_PART_STRIKETHROUGH => Self::Strikethrough,
            ffi::PANGO_RENDER_PART_OVERLINE => Self::Overline,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for RenderPart {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_render_part_get_type()) }
    }
}

impl glib::value::ValueType for RenderPart {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RenderPart {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RenderPart {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoScript")]
pub enum Script {
    #[doc(alias = "PANGO_SCRIPT_INVALID_CODE")]
    InvalidCode,
    #[doc(alias = "PANGO_SCRIPT_COMMON")]
    Common,
    #[doc(alias = "PANGO_SCRIPT_INHERITED")]
    Inherited,
    #[doc(alias = "PANGO_SCRIPT_ARABIC")]
    Arabic,
    #[doc(alias = "PANGO_SCRIPT_ARMENIAN")]
    Armenian,
    #[doc(alias = "PANGO_SCRIPT_BENGALI")]
    Bengali,
    #[doc(alias = "PANGO_SCRIPT_BOPOMOFO")]
    Bopomofo,
    #[doc(alias = "PANGO_SCRIPT_CHEROKEE")]
    Cherokee,
    #[doc(alias = "PANGO_SCRIPT_COPTIC")]
    Coptic,
    #[doc(alias = "PANGO_SCRIPT_CYRILLIC")]
    Cyrillic,
    #[doc(alias = "PANGO_SCRIPT_DESERET")]
    Deseret,
    #[doc(alias = "PANGO_SCRIPT_DEVANAGARI")]
    Devanagari,
    #[doc(alias = "PANGO_SCRIPT_ETHIOPIC")]
    Ethiopic,
    #[doc(alias = "PANGO_SCRIPT_GEORGIAN")]
    Georgian,
    #[doc(alias = "PANGO_SCRIPT_GOTHIC")]
    Gothic,
    #[doc(alias = "PANGO_SCRIPT_GREEK")]
    Greek,
    #[doc(alias = "PANGO_SCRIPT_GUJARATI")]
    Gujarati,
    #[doc(alias = "PANGO_SCRIPT_GURMUKHI")]
    Gurmukhi,
    #[doc(alias = "PANGO_SCRIPT_HAN")]
    Han,
    #[doc(alias = "PANGO_SCRIPT_HANGUL")]
    Hangul,
    #[doc(alias = "PANGO_SCRIPT_HEBREW")]
    Hebrew,
    #[doc(alias = "PANGO_SCRIPT_HIRAGANA")]
    Hiragana,
    #[doc(alias = "PANGO_SCRIPT_KANNADA")]
    Kannada,
    #[doc(alias = "PANGO_SCRIPT_KATAKANA")]
    Katakana,
    #[doc(alias = "PANGO_SCRIPT_KHMER")]
    Khmer,
    #[doc(alias = "PANGO_SCRIPT_LAO")]
    Lao,
    #[doc(alias = "PANGO_SCRIPT_LATIN")]
    Latin,
    #[doc(alias = "PANGO_SCRIPT_MALAYALAM")]
    Malayalam,
    #[doc(alias = "PANGO_SCRIPT_MONGOLIAN")]
    Mongolian,
    #[doc(alias = "PANGO_SCRIPT_MYANMAR")]
    Myanmar,
    #[doc(alias = "PANGO_SCRIPT_OGHAM")]
    Ogham,
    #[doc(alias = "PANGO_SCRIPT_OLD_ITALIC")]
    OldItalic,
    #[doc(alias = "PANGO_SCRIPT_ORIYA")]
    Oriya,
    #[doc(alias = "PANGO_SCRIPT_RUNIC")]
    Runic,
    #[doc(alias = "PANGO_SCRIPT_SINHALA")]
    Sinhala,
    #[doc(alias = "PANGO_SCRIPT_SYRIAC")]
    Syriac,
    #[doc(alias = "PANGO_SCRIPT_TAMIL")]
    Tamil,
    #[doc(alias = "PANGO_SCRIPT_TELUGU")]
    Telugu,
    #[doc(alias = "PANGO_SCRIPT_THAANA")]
    Thaana,
    #[doc(alias = "PANGO_SCRIPT_THAI")]
    Thai,
    #[doc(alias = "PANGO_SCRIPT_TIBETAN")]
    Tibetan,
    #[doc(alias = "PANGO_SCRIPT_CANADIAN_ABORIGINAL")]
    CanadianAboriginal,
    #[doc(alias = "PANGO_SCRIPT_YI")]
    Yi,
    #[doc(alias = "PANGO_SCRIPT_TAGALOG")]
    Tagalog,
    #[doc(alias = "PANGO_SCRIPT_HANUNOO")]
    Hanunoo,
    #[doc(alias = "PANGO_SCRIPT_BUHID")]
    Buhid,
    #[doc(alias = "PANGO_SCRIPT_TAGBANWA")]
    Tagbanwa,
    #[doc(alias = "PANGO_SCRIPT_BRAILLE")]
    Braille,
    #[doc(alias = "PANGO_SCRIPT_CYPRIOT")]
    Cypriot,
    #[doc(alias = "PANGO_SCRIPT_LIMBU")]
    Limbu,
    #[doc(alias = "PANGO_SCRIPT_OSMANYA")]
    Osmanya,
    #[doc(alias = "PANGO_SCRIPT_SHAVIAN")]
    Shavian,
    #[doc(alias = "PANGO_SCRIPT_LINEAR_B")]
    LinearB,
    #[doc(alias = "PANGO_SCRIPT_TAI_LE")]
    TaiLe,
    #[doc(alias = "PANGO_SCRIPT_UGARITIC")]
    Ugaritic,
    #[doc(alias = "PANGO_SCRIPT_NEW_TAI_LUE")]
    NewTaiLue,
    #[doc(alias = "PANGO_SCRIPT_BUGINESE")]
    Buginese,
    #[doc(alias = "PANGO_SCRIPT_GLAGOLITIC")]
    Glagolitic,
    #[doc(alias = "PANGO_SCRIPT_TIFINAGH")]
    Tifinagh,
    #[doc(alias = "PANGO_SCRIPT_SYLOTI_NAGRI")]
    SylotiNagri,
    #[doc(alias = "PANGO_SCRIPT_OLD_PERSIAN")]
    OldPersian,
    #[doc(alias = "PANGO_SCRIPT_KHAROSHTHI")]
    Kharoshthi,
    #[doc(alias = "PANGO_SCRIPT_UNKNOWN")]
    Unknown,
    #[doc(alias = "PANGO_SCRIPT_BALINESE")]
    Balinese,
    #[doc(alias = "PANGO_SCRIPT_CUNEIFORM")]
    Cuneiform,
    #[doc(alias = "PANGO_SCRIPT_PHOENICIAN")]
    Phoenician,
    #[doc(alias = "PANGO_SCRIPT_PHAGS_PA")]
    PhagsPa,
    #[doc(alias = "PANGO_SCRIPT_NKO")]
    Nko,
    #[doc(alias = "PANGO_SCRIPT_KAYAH_LI")]
    KayahLi,
    #[doc(alias = "PANGO_SCRIPT_LEPCHA")]
    Lepcha,
    #[doc(alias = "PANGO_SCRIPT_REJANG")]
    Rejang,
    #[doc(alias = "PANGO_SCRIPT_SUNDANESE")]
    Sundanese,
    #[doc(alias = "PANGO_SCRIPT_SAURASHTRA")]
    Saurashtra,
    #[doc(alias = "PANGO_SCRIPT_CHAM")]
    Cham,
    #[doc(alias = "PANGO_SCRIPT_OL_CHIKI")]
    OlChiki,
    #[doc(alias = "PANGO_SCRIPT_VAI")]
    Vai,
    #[doc(alias = "PANGO_SCRIPT_CARIAN")]
    Carian,
    #[doc(alias = "PANGO_SCRIPT_LYCIAN")]
    Lycian,
    #[doc(alias = "PANGO_SCRIPT_LYDIAN")]
    Lydian,
    #[doc(alias = "PANGO_SCRIPT_BATAK")]
    Batak,
    #[doc(alias = "PANGO_SCRIPT_BRAHMI")]
    Brahmi,
    #[doc(alias = "PANGO_SCRIPT_MANDAIC")]
    Mandaic,
    #[doc(alias = "PANGO_SCRIPT_CHAKMA")]
    Chakma,
    #[doc(alias = "PANGO_SCRIPT_MEROITIC_CURSIVE")]
    MeroiticCursive,
    #[doc(alias = "PANGO_SCRIPT_MEROITIC_HIEROGLYPHS")]
    MeroiticHieroglyphs,
    #[doc(alias = "PANGO_SCRIPT_MIAO")]
    Miao,
    #[doc(alias = "PANGO_SCRIPT_SHARADA")]
    Sharada,
    #[doc(alias = "PANGO_SCRIPT_SORA_SOMPENG")]
    SoraSompeng,
    #[doc(alias = "PANGO_SCRIPT_TAKRI")]
    Takri,
    #[doc(alias = "PANGO_SCRIPT_BASSA_VAH")]
    BassaVah,
    #[doc(alias = "PANGO_SCRIPT_CAUCASIAN_ALBANIAN")]
    CaucasianAlbanian,
    #[doc(alias = "PANGO_SCRIPT_DUPLOYAN")]
    Duployan,
    #[doc(alias = "PANGO_SCRIPT_ELBASAN")]
    Elbasan,
    #[doc(alias = "PANGO_SCRIPT_GRANTHA")]
    Grantha,
    #[doc(alias = "PANGO_SCRIPT_KHOJKI")]
    Khojki,
    #[doc(alias = "PANGO_SCRIPT_KHUDAWADI")]
    Khudawadi,
    #[doc(alias = "PANGO_SCRIPT_LINEAR_A")]
    LinearA,
    #[doc(alias = "PANGO_SCRIPT_MAHAJANI")]
    Mahajani,
    #[doc(alias = "PANGO_SCRIPT_MANICHAEAN")]
    Manichaean,
    #[doc(alias = "PANGO_SCRIPT_MENDE_KIKAKUI")]
    MendeKikakui,
    #[doc(alias = "PANGO_SCRIPT_MODI")]
    Modi,
    #[doc(alias = "PANGO_SCRIPT_MRO")]
    Mro,
    #[doc(alias = "PANGO_SCRIPT_NABATAEAN")]
    Nabataean,
    #[doc(alias = "PANGO_SCRIPT_OLD_NORTH_ARABIAN")]
    OldNorthArabian,
    #[doc(alias = "PANGO_SCRIPT_OLD_PERMIC")]
    OldPermic,
    #[doc(alias = "PANGO_SCRIPT_PAHAWH_HMONG")]
    PahawhHmong,
    #[doc(alias = "PANGO_SCRIPT_PALMYRENE")]
    Palmyrene,
    #[doc(alias = "PANGO_SCRIPT_PAU_CIN_HAU")]
    PauCinHau,
    #[doc(alias = "PANGO_SCRIPT_PSALTER_PAHLAVI")]
    PsalterPahlavi,
    #[doc(alias = "PANGO_SCRIPT_SIDDHAM")]
    Siddham,
    #[doc(alias = "PANGO_SCRIPT_TIRHUTA")]
    Tirhuta,
    #[doc(alias = "PANGO_SCRIPT_WARANG_CITI")]
    WarangCiti,
    #[doc(alias = "PANGO_SCRIPT_AHOM")]
    Ahom,
    #[doc(alias = "PANGO_SCRIPT_ANATOLIAN_HIEROGLYPHS")]
    AnatolianHieroglyphs,
    #[doc(alias = "PANGO_SCRIPT_HATRAN")]
    Hatran,
    #[doc(alias = "PANGO_SCRIPT_MULTANI")]
    Multani,
    #[doc(alias = "PANGO_SCRIPT_OLD_HUNGARIAN")]
    OldHungarian,
    #[doc(alias = "PANGO_SCRIPT_SIGNWRITING")]
    Signwriting,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Script {
    #[cfg_attr(feature = "v1_44", deprecated = "Since 1.44")]
    #[doc(alias = "pango_script_for_unichar")]
    pub fn for_unichar(ch: char) -> Script {
        unsafe { from_glib(ffi::pango_script_for_unichar(ch.into_glib())) }
    }

    #[doc(alias = "pango_script_get_sample_language")]
    #[doc(alias = "get_sample_language")]
    pub fn sample_language(self) -> Option<Language> {
        unsafe { from_glib_full(ffi::pango_script_get_sample_language(self.into_glib())) }
    }
}

impl fmt::Display for Script {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Script::{}",
            match *self {
                Self::InvalidCode => "InvalidCode",
                Self::Common => "Common",
                Self::Inherited => "Inherited",
                Self::Arabic => "Arabic",
                Self::Armenian => "Armenian",
                Self::Bengali => "Bengali",
                Self::Bopomofo => "Bopomofo",
                Self::Cherokee => "Cherokee",
                Self::Coptic => "Coptic",
                Self::Cyrillic => "Cyrillic",
                Self::Deseret => "Deseret",
                Self::Devanagari => "Devanagari",
                Self::Ethiopic => "Ethiopic",
                Self::Georgian => "Georgian",
                Self::Gothic => "Gothic",
                Self::Greek => "Greek",
                Self::Gujarati => "Gujarati",
                Self::Gurmukhi => "Gurmukhi",
                Self::Han => "Han",
                Self::Hangul => "Hangul",
                Self::Hebrew => "Hebrew",
                Self::Hiragana => "Hiragana",
                Self::Kannada => "Kannada",
                Self::Katakana => "Katakana",
                Self::Khmer => "Khmer",
                Self::Lao => "Lao",
                Self::Latin => "Latin",
                Self::Malayalam => "Malayalam",
                Self::Mongolian => "Mongolian",
                Self::Myanmar => "Myanmar",
                Self::Ogham => "Ogham",
                Self::OldItalic => "OldItalic",
                Self::Oriya => "Oriya",
                Self::Runic => "Runic",
                Self::Sinhala => "Sinhala",
                Self::Syriac => "Syriac",
                Self::Tamil => "Tamil",
                Self::Telugu => "Telugu",
                Self::Thaana => "Thaana",
                Self::Thai => "Thai",
                Self::Tibetan => "Tibetan",
                Self::CanadianAboriginal => "CanadianAboriginal",
                Self::Yi => "Yi",
                Self::Tagalog => "Tagalog",
                Self::Hanunoo => "Hanunoo",
                Self::Buhid => "Buhid",
                Self::Tagbanwa => "Tagbanwa",
                Self::Braille => "Braille",
                Self::Cypriot => "Cypriot",
                Self::Limbu => "Limbu",
                Self::Osmanya => "Osmanya",
                Self::Shavian => "Shavian",
                Self::LinearB => "LinearB",
                Self::TaiLe => "TaiLe",
                Self::Ugaritic => "Ugaritic",
                Self::NewTaiLue => "NewTaiLue",
                Self::Buginese => "Buginese",
                Self::Glagolitic => "Glagolitic",
                Self::Tifinagh => "Tifinagh",
                Self::SylotiNagri => "SylotiNagri",
                Self::OldPersian => "OldPersian",
                Self::Kharoshthi => "Kharoshthi",
                Self::Unknown => "Unknown",
                Self::Balinese => "Balinese",
                Self::Cuneiform => "Cuneiform",
                Self::Phoenician => "Phoenician",
                Self::PhagsPa => "PhagsPa",
                Self::Nko => "Nko",
                Self::KayahLi => "KayahLi",
                Self::Lepcha => "Lepcha",
                Self::Rejang => "Rejang",
                Self::Sundanese => "Sundanese",
                Self::Saurashtra => "Saurashtra",
                Self::Cham => "Cham",
                Self::OlChiki => "OlChiki",
                Self::Vai => "Vai",
                Self::Carian => "Carian",
                Self::Lycian => "Lycian",
                Self::Lydian => "Lydian",
                Self::Batak => "Batak",
                Self::Brahmi => "Brahmi",
                Self::Mandaic => "Mandaic",
                Self::Chakma => "Chakma",
                Self::MeroiticCursive => "MeroiticCursive",
                Self::MeroiticHieroglyphs => "MeroiticHieroglyphs",
                Self::Miao => "Miao",
                Self::Sharada => "Sharada",
                Self::SoraSompeng => "SoraSompeng",
                Self::Takri => "Takri",
                Self::BassaVah => "BassaVah",
                Self::CaucasianAlbanian => "CaucasianAlbanian",
                Self::Duployan => "Duployan",
                Self::Elbasan => "Elbasan",
                Self::Grantha => "Grantha",
                Self::Khojki => "Khojki",
                Self::Khudawadi => "Khudawadi",
                Self::LinearA => "LinearA",
                Self::Mahajani => "Mahajani",
                Self::Manichaean => "Manichaean",
                Self::MendeKikakui => "MendeKikakui",
                Self::Modi => "Modi",
                Self::Mro => "Mro",
                Self::Nabataean => "Nabataean",
                Self::OldNorthArabian => "OldNorthArabian",
                Self::OldPermic => "OldPermic",
                Self::PahawhHmong => "PahawhHmong",
                Self::Palmyrene => "Palmyrene",
                Self::PauCinHau => "PauCinHau",
                Self::PsalterPahlavi => "PsalterPahlavi",
                Self::Siddham => "Siddham",
                Self::Tirhuta => "Tirhuta",
                Self::WarangCiti => "WarangCiti",
                Self::Ahom => "Ahom",
                Self::AnatolianHieroglyphs => "AnatolianHieroglyphs",
                Self::Hatran => "Hatran",
                Self::Multani => "Multani",
                Self::OldHungarian => "OldHungarian",
                Self::Signwriting => "Signwriting",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Script {
    type GlibType = ffi::PangoScript;

    fn into_glib(self) -> ffi::PangoScript {
        match self {
            Self::InvalidCode => ffi::PANGO_SCRIPT_INVALID_CODE,
            Self::Common => ffi::PANGO_SCRIPT_COMMON,
            Self::Inherited => ffi::PANGO_SCRIPT_INHERITED,
            Self::Arabic => ffi::PANGO_SCRIPT_ARABIC,
            Self::Armenian => ffi::PANGO_SCRIPT_ARMENIAN,
            Self::Bengali => ffi::PANGO_SCRIPT_BENGALI,
            Self::Bopomofo => ffi::PANGO_SCRIPT_BOPOMOFO,
            Self::Cherokee => ffi::PANGO_SCRIPT_CHEROKEE,
            Self::Coptic => ffi::PANGO_SCRIPT_COPTIC,
            Self::Cyrillic => ffi::PANGO_SCRIPT_CYRILLIC,
            Self::Deseret => ffi::PANGO_SCRIPT_DESERET,
            Self::Devanagari => ffi::PANGO_SCRIPT_DEVANAGARI,
            Self::Ethiopic => ffi::PANGO_SCRIPT_ETHIOPIC,
            Self::Georgian => ffi::PANGO_SCRIPT_GEORGIAN,
            Self::Gothic => ffi::PANGO_SCRIPT_GOTHIC,
            Self::Greek => ffi::PANGO_SCRIPT_GREEK,
            Self::Gujarati => ffi::PANGO_SCRIPT_GUJARATI,
            Self::Gurmukhi => ffi::PANGO_SCRIPT_GURMUKHI,
            Self::Han => ffi::PANGO_SCRIPT_HAN,
            Self::Hangul => ffi::PANGO_SCRIPT_HANGUL,
            Self::Hebrew => ffi::PANGO_SCRIPT_HEBREW,
            Self::Hiragana => ffi::PANGO_SCRIPT_HIRAGANA,
            Self::Kannada => ffi::PANGO_SCRIPT_KANNADA,
            Self::Katakana => ffi::PANGO_SCRIPT_KATAKANA,
            Self::Khmer => ffi::PANGO_SCRIPT_KHMER,
            Self::Lao => ffi::PANGO_SCRIPT_LAO,
            Self::Latin => ffi::PANGO_SCRIPT_LATIN,
            Self::Malayalam => ffi::PANGO_SCRIPT_MALAYALAM,
            Self::Mongolian => ffi::PANGO_SCRIPT_MONGOLIAN,
            Self::Myanmar => ffi::PANGO_SCRIPT_MYANMAR,
            Self::Ogham => ffi::PANGO_SCRIPT_OGHAM,
            Self::OldItalic => ffi::PANGO_SCRIPT_OLD_ITALIC,
            Self::Oriya => ffi::PANGO_SCRIPT_ORIYA,
            Self::Runic => ffi::PANGO_SCRIPT_RUNIC,
            Self::Sinhala => ffi::PANGO_SCRIPT_SINHALA,
            Self::Syriac => ffi::PANGO_SCRIPT_SYRIAC,
            Self::Tamil => ffi::PANGO_SCRIPT_TAMIL,
            Self::Telugu => ffi::PANGO_SCRIPT_TELUGU,
            Self::Thaana => ffi::PANGO_SCRIPT_THAANA,
            Self::Thai => ffi::PANGO_SCRIPT_THAI,
            Self::Tibetan => ffi::PANGO_SCRIPT_TIBETAN,
            Self::CanadianAboriginal => ffi::PANGO_SCRIPT_CANADIAN_ABORIGINAL,
            Self::Yi => ffi::PANGO_SCRIPT_YI,
            Self::Tagalog => ffi::PANGO_SCRIPT_TAGALOG,
            Self::Hanunoo => ffi::PANGO_SCRIPT_HANUNOO,
            Self::Buhid => ffi::PANGO_SCRIPT_BUHID,
            Self::Tagbanwa => ffi::PANGO_SCRIPT_TAGBANWA,
            Self::Braille => ffi::PANGO_SCRIPT_BRAILLE,
            Self::Cypriot => ffi::PANGO_SCRIPT_CYPRIOT,
            Self::Limbu => ffi::PANGO_SCRIPT_LIMBU,
            Self::Osmanya => ffi::PANGO_SCRIPT_OSMANYA,
            Self::Shavian => ffi::PANGO_SCRIPT_SHAVIAN,
            Self::LinearB => ffi::PANGO_SCRIPT_LINEAR_B,
            Self::TaiLe => ffi::PANGO_SCRIPT_TAI_LE,
            Self::Ugaritic => ffi::PANGO_SCRIPT_UGARITIC,
            Self::NewTaiLue => ffi::PANGO_SCRIPT_NEW_TAI_LUE,
            Self::Buginese => ffi::PANGO_SCRIPT_BUGINESE,
            Self::Glagolitic => ffi::PANGO_SCRIPT_GLAGOLITIC,
            Self::Tifinagh => ffi::PANGO_SCRIPT_TIFINAGH,
            Self::SylotiNagri => ffi::PANGO_SCRIPT_SYLOTI_NAGRI,
            Self::OldPersian => ffi::PANGO_SCRIPT_OLD_PERSIAN,
            Self::Kharoshthi => ffi::PANGO_SCRIPT_KHAROSHTHI,
            Self::Unknown => ffi::PANGO_SCRIPT_UNKNOWN,
            Self::Balinese => ffi::PANGO_SCRIPT_BALINESE,
            Self::Cuneiform => ffi::PANGO_SCRIPT_CUNEIFORM,
            Self::Phoenician => ffi::PANGO_SCRIPT_PHOENICIAN,
            Self::PhagsPa => ffi::PANGO_SCRIPT_PHAGS_PA,
            Self::Nko => ffi::PANGO_SCRIPT_NKO,
            Self::KayahLi => ffi::PANGO_SCRIPT_KAYAH_LI,
            Self::Lepcha => ffi::PANGO_SCRIPT_LEPCHA,
            Self::Rejang => ffi::PANGO_SCRIPT_REJANG,
            Self::Sundanese => ffi::PANGO_SCRIPT_SUNDANESE,
            Self::Saurashtra => ffi::PANGO_SCRIPT_SAURASHTRA,
            Self::Cham => ffi::PANGO_SCRIPT_CHAM,
            Self::OlChiki => ffi::PANGO_SCRIPT_OL_CHIKI,
            Self::Vai => ffi::PANGO_SCRIPT_VAI,
            Self::Carian => ffi::PANGO_SCRIPT_CARIAN,
            Self::Lycian => ffi::PANGO_SCRIPT_LYCIAN,
            Self::Lydian => ffi::PANGO_SCRIPT_LYDIAN,
            Self::Batak => ffi::PANGO_SCRIPT_BATAK,
            Self::Brahmi => ffi::PANGO_SCRIPT_BRAHMI,
            Self::Mandaic => ffi::PANGO_SCRIPT_MANDAIC,
            Self::Chakma => ffi::PANGO_SCRIPT_CHAKMA,
            Self::MeroiticCursive => ffi::PANGO_SCRIPT_MEROITIC_CURSIVE,
            Self::MeroiticHieroglyphs => ffi::PANGO_SCRIPT_MEROITIC_HIEROGLYPHS,
            Self::Miao => ffi::PANGO_SCRIPT_MIAO,
            Self::Sharada => ffi::PANGO_SCRIPT_SHARADA,
            Self::SoraSompeng => ffi::PANGO_SCRIPT_SORA_SOMPENG,
            Self::Takri => ffi::PANGO_SCRIPT_TAKRI,
            Self::BassaVah => ffi::PANGO_SCRIPT_BASSA_VAH,
            Self::CaucasianAlbanian => ffi::PANGO_SCRIPT_CAUCASIAN_ALBANIAN,
            Self::Duployan => ffi::PANGO_SCRIPT_DUPLOYAN,
            Self::Elbasan => ffi::PANGO_SCRIPT_ELBASAN,
            Self::Grantha => ffi::PANGO_SCRIPT_GRANTHA,
            Self::Khojki => ffi::PANGO_SCRIPT_KHOJKI,
            Self::Khudawadi => ffi::PANGO_SCRIPT_KHUDAWADI,
            Self::LinearA => ffi::PANGO_SCRIPT_LINEAR_A,
            Self::Mahajani => ffi::PANGO_SCRIPT_MAHAJANI,
            Self::Manichaean => ffi::PANGO_SCRIPT_MANICHAEAN,
            Self::MendeKikakui => ffi::PANGO_SCRIPT_MENDE_KIKAKUI,
            Self::Modi => ffi::PANGO_SCRIPT_MODI,
            Self::Mro => ffi::PANGO_SCRIPT_MRO,
            Self::Nabataean => ffi::PANGO_SCRIPT_NABATAEAN,
            Self::OldNorthArabian => ffi::PANGO_SCRIPT_OLD_NORTH_ARABIAN,
            Self::OldPermic => ffi::PANGO_SCRIPT_OLD_PERMIC,
            Self::PahawhHmong => ffi::PANGO_SCRIPT_PAHAWH_HMONG,
            Self::Palmyrene => ffi::PANGO_SCRIPT_PALMYRENE,
            Self::PauCinHau => ffi::PANGO_SCRIPT_PAU_CIN_HAU,
            Self::PsalterPahlavi => ffi::PANGO_SCRIPT_PSALTER_PAHLAVI,
            Self::Siddham => ffi::PANGO_SCRIPT_SIDDHAM,
            Self::Tirhuta => ffi::PANGO_SCRIPT_TIRHUTA,
            Self::WarangCiti => ffi::PANGO_SCRIPT_WARANG_CITI,
            Self::Ahom => ffi::PANGO_SCRIPT_AHOM,
            Self::AnatolianHieroglyphs => ffi::PANGO_SCRIPT_ANATOLIAN_HIEROGLYPHS,
            Self::Hatran => ffi::PANGO_SCRIPT_HATRAN,
            Self::Multani => ffi::PANGO_SCRIPT_MULTANI,
            Self::OldHungarian => ffi::PANGO_SCRIPT_OLD_HUNGARIAN,
            Self::Signwriting => ffi::PANGO_SCRIPT_SIGNWRITING,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoScript> for Script {
    unsafe fn from_glib(value: ffi::PangoScript) -> Self {
        match value {
            ffi::PANGO_SCRIPT_INVALID_CODE => Self::InvalidCode,
            ffi::PANGO_SCRIPT_COMMON => Self::Common,
            ffi::PANGO_SCRIPT_INHERITED => Self::Inherited,
            ffi::PANGO_SCRIPT_ARABIC => Self::Arabic,
            ffi::PANGO_SCRIPT_ARMENIAN => Self::Armenian,
            ffi::PANGO_SCRIPT_BENGALI => Self::Bengali,
            ffi::PANGO_SCRIPT_BOPOMOFO => Self::Bopomofo,
            ffi::PANGO_SCRIPT_CHEROKEE => Self::Cherokee,
            ffi::PANGO_SCRIPT_COPTIC => Self::Coptic,
            ffi::PANGO_SCRIPT_CYRILLIC => Self::Cyrillic,
            ffi::PANGO_SCRIPT_DESERET => Self::Deseret,
            ffi::PANGO_SCRIPT_DEVANAGARI => Self::Devanagari,
            ffi::PANGO_SCRIPT_ETHIOPIC => Self::Ethiopic,
            ffi::PANGO_SCRIPT_GEORGIAN => Self::Georgian,
            ffi::PANGO_SCRIPT_GOTHIC => Self::Gothic,
            ffi::PANGO_SCRIPT_GREEK => Self::Greek,
            ffi::PANGO_SCRIPT_GUJARATI => Self::Gujarati,
            ffi::PANGO_SCRIPT_GURMUKHI => Self::Gurmukhi,
            ffi::PANGO_SCRIPT_HAN => Self::Han,
            ffi::PANGO_SCRIPT_HANGUL => Self::Hangul,
            ffi::PANGO_SCRIPT_HEBREW => Self::Hebrew,
            ffi::PANGO_SCRIPT_HIRAGANA => Self::Hiragana,
            ffi::PANGO_SCRIPT_KANNADA => Self::Kannada,
            ffi::PANGO_SCRIPT_KATAKANA => Self::Katakana,
            ffi::PANGO_SCRIPT_KHMER => Self::Khmer,
            ffi::PANGO_SCRIPT_LAO => Self::Lao,
            ffi::PANGO_SCRIPT_LATIN => Self::Latin,
            ffi::PANGO_SCRIPT_MALAYALAM => Self::Malayalam,
            ffi::PANGO_SCRIPT_MONGOLIAN => Self::Mongolian,
            ffi::PANGO_SCRIPT_MYANMAR => Self::Myanmar,
            ffi::PANGO_SCRIPT_OGHAM => Self::Ogham,
            ffi::PANGO_SCRIPT_OLD_ITALIC => Self::OldItalic,
            ffi::PANGO_SCRIPT_ORIYA => Self::Oriya,
            ffi::PANGO_SCRIPT_RUNIC => Self::Runic,
            ffi::PANGO_SCRIPT_SINHALA => Self::Sinhala,
            ffi::PANGO_SCRIPT_SYRIAC => Self::Syriac,
            ffi::PANGO_SCRIPT_TAMIL => Self::Tamil,
            ffi::PANGO_SCRIPT_TELUGU => Self::Telugu,
            ffi::PANGO_SCRIPT_THAANA => Self::Thaana,
            ffi::PANGO_SCRIPT_THAI => Self::Thai,
            ffi::PANGO_SCRIPT_TIBETAN => Self::Tibetan,
            ffi::PANGO_SCRIPT_CANADIAN_ABORIGINAL => Self::CanadianAboriginal,
            ffi::PANGO_SCRIPT_YI => Self::Yi,
            ffi::PANGO_SCRIPT_TAGALOG => Self::Tagalog,
            ffi::PANGO_SCRIPT_HANUNOO => Self::Hanunoo,
            ffi::PANGO_SCRIPT_BUHID => Self::Buhid,
            ffi::PANGO_SCRIPT_TAGBANWA => Self::Tagbanwa,
            ffi::PANGO_SCRIPT_BRAILLE => Self::Braille,
            ffi::PANGO_SCRIPT_CYPRIOT => Self::Cypriot,
            ffi::PANGO_SCRIPT_LIMBU => Self::Limbu,
            ffi::PANGO_SCRIPT_OSMANYA => Self::Osmanya,
            ffi::PANGO_SCRIPT_SHAVIAN => Self::Shavian,
            ffi::PANGO_SCRIPT_LINEAR_B => Self::LinearB,
            ffi::PANGO_SCRIPT_TAI_LE => Self::TaiLe,
            ffi::PANGO_SCRIPT_UGARITIC => Self::Ugaritic,
            ffi::PANGO_SCRIPT_NEW_TAI_LUE => Self::NewTaiLue,
            ffi::PANGO_SCRIPT_BUGINESE => Self::Buginese,
            ffi::PANGO_SCRIPT_GLAGOLITIC => Self::Glagolitic,
            ffi::PANGO_SCRIPT_TIFINAGH => Self::Tifinagh,
            ffi::PANGO_SCRIPT_SYLOTI_NAGRI => Self::SylotiNagri,
            ffi::PANGO_SCRIPT_OLD_PERSIAN => Self::OldPersian,
            ffi::PANGO_SCRIPT_KHAROSHTHI => Self::Kharoshthi,
            ffi::PANGO_SCRIPT_UNKNOWN => Self::Unknown,
            ffi::PANGO_SCRIPT_BALINESE => Self::Balinese,
            ffi::PANGO_SCRIPT_CUNEIFORM => Self::Cuneiform,
            ffi::PANGO_SCRIPT_PHOENICIAN => Self::Phoenician,
            ffi::PANGO_SCRIPT_PHAGS_PA => Self::PhagsPa,
            ffi::PANGO_SCRIPT_NKO => Self::Nko,
            ffi::PANGO_SCRIPT_KAYAH_LI => Self::KayahLi,
            ffi::PANGO_SCRIPT_LEPCHA => Self::Lepcha,
            ffi::PANGO_SCRIPT_REJANG => Self::Rejang,
            ffi::PANGO_SCRIPT_SUNDANESE => Self::Sundanese,
            ffi::PANGO_SCRIPT_SAURASHTRA => Self::Saurashtra,
            ffi::PANGO_SCRIPT_CHAM => Self::Cham,
            ffi::PANGO_SCRIPT_OL_CHIKI => Self::OlChiki,
            ffi::PANGO_SCRIPT_VAI => Self::Vai,
            ffi::PANGO_SCRIPT_CARIAN => Self::Carian,
            ffi::PANGO_SCRIPT_LYCIAN => Self::Lycian,
            ffi::PANGO_SCRIPT_LYDIAN => Self::Lydian,
            ffi::PANGO_SCRIPT_BATAK => Self::Batak,
            ffi::PANGO_SCRIPT_BRAHMI => Self::Brahmi,
            ffi::PANGO_SCRIPT_MANDAIC => Self::Mandaic,
            ffi::PANGO_SCRIPT_CHAKMA => Self::Chakma,
            ffi::PANGO_SCRIPT_MEROITIC_CURSIVE => Self::MeroiticCursive,
            ffi::PANGO_SCRIPT_MEROITIC_HIEROGLYPHS => Self::MeroiticHieroglyphs,
            ffi::PANGO_SCRIPT_MIAO => Self::Miao,
            ffi::PANGO_SCRIPT_SHARADA => Self::Sharada,
            ffi::PANGO_SCRIPT_SORA_SOMPENG => Self::SoraSompeng,
            ffi::PANGO_SCRIPT_TAKRI => Self::Takri,
            ffi::PANGO_SCRIPT_BASSA_VAH => Self::BassaVah,
            ffi::PANGO_SCRIPT_CAUCASIAN_ALBANIAN => Self::CaucasianAlbanian,
            ffi::PANGO_SCRIPT_DUPLOYAN => Self::Duployan,
            ffi::PANGO_SCRIPT_ELBASAN => Self::Elbasan,
            ffi::PANGO_SCRIPT_GRANTHA => Self::Grantha,
            ffi::PANGO_SCRIPT_KHOJKI => Self::Khojki,
            ffi::PANGO_SCRIPT_KHUDAWADI => Self::Khudawadi,
            ffi::PANGO_SCRIPT_LINEAR_A => Self::LinearA,
            ffi::PANGO_SCRIPT_MAHAJANI => Self::Mahajani,
            ffi::PANGO_SCRIPT_MANICHAEAN => Self::Manichaean,
            ffi::PANGO_SCRIPT_MENDE_KIKAKUI => Self::MendeKikakui,
            ffi::PANGO_SCRIPT_MODI => Self::Modi,
            ffi::PANGO_SCRIPT_MRO => Self::Mro,
            ffi::PANGO_SCRIPT_NABATAEAN => Self::Nabataean,
            ffi::PANGO_SCRIPT_OLD_NORTH_ARABIAN => Self::OldNorthArabian,
            ffi::PANGO_SCRIPT_OLD_PERMIC => Self::OldPermic,
            ffi::PANGO_SCRIPT_PAHAWH_HMONG => Self::PahawhHmong,
            ffi::PANGO_SCRIPT_PALMYRENE => Self::Palmyrene,
            ffi::PANGO_SCRIPT_PAU_CIN_HAU => Self::PauCinHau,
            ffi::PANGO_SCRIPT_PSALTER_PAHLAVI => Self::PsalterPahlavi,
            ffi::PANGO_SCRIPT_SIDDHAM => Self::Siddham,
            ffi::PANGO_SCRIPT_TIRHUTA => Self::Tirhuta,
            ffi::PANGO_SCRIPT_WARANG_CITI => Self::WarangCiti,
            ffi::PANGO_SCRIPT_AHOM => Self::Ahom,
            ffi::PANGO_SCRIPT_ANATOLIAN_HIEROGLYPHS => Self::AnatolianHieroglyphs,
            ffi::PANGO_SCRIPT_HATRAN => Self::Hatran,
            ffi::PANGO_SCRIPT_MULTANI => Self::Multani,
            ffi::PANGO_SCRIPT_OLD_HUNGARIAN => Self::OldHungarian,
            ffi::PANGO_SCRIPT_SIGNWRITING => Self::Signwriting,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Script {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_script_get_type()) }
    }
}

impl glib::value::ValueType for Script {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Script {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Script {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoStretch")]
pub enum Stretch {
    #[doc(alias = "PANGO_STRETCH_ULTRA_CONDENSED")]
    UltraCondensed,
    #[doc(alias = "PANGO_STRETCH_EXTRA_CONDENSED")]
    ExtraCondensed,
    #[doc(alias = "PANGO_STRETCH_CONDENSED")]
    Condensed,
    #[doc(alias = "PANGO_STRETCH_SEMI_CONDENSED")]
    SemiCondensed,
    #[doc(alias = "PANGO_STRETCH_NORMAL")]
    Normal,
    #[doc(alias = "PANGO_STRETCH_SEMI_EXPANDED")]
    SemiExpanded,
    #[doc(alias = "PANGO_STRETCH_EXPANDED")]
    Expanded,
    #[doc(alias = "PANGO_STRETCH_EXTRA_EXPANDED")]
    ExtraExpanded,
    #[doc(alias = "PANGO_STRETCH_ULTRA_EXPANDED")]
    UltraExpanded,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Stretch {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Stretch::{}",
            match *self {
                Self::UltraCondensed => "UltraCondensed",
                Self::ExtraCondensed => "ExtraCondensed",
                Self::Condensed => "Condensed",
                Self::SemiCondensed => "SemiCondensed",
                Self::Normal => "Normal",
                Self::SemiExpanded => "SemiExpanded",
                Self::Expanded => "Expanded",
                Self::ExtraExpanded => "ExtraExpanded",
                Self::UltraExpanded => "UltraExpanded",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Stretch {
    type GlibType = ffi::PangoStretch;

    fn into_glib(self) -> ffi::PangoStretch {
        match self {
            Self::UltraCondensed => ffi::PANGO_STRETCH_ULTRA_CONDENSED,
            Self::ExtraCondensed => ffi::PANGO_STRETCH_EXTRA_CONDENSED,
            Self::Condensed => ffi::PANGO_STRETCH_CONDENSED,
            Self::SemiCondensed => ffi::PANGO_STRETCH_SEMI_CONDENSED,
            Self::Normal => ffi::PANGO_STRETCH_NORMAL,
            Self::SemiExpanded => ffi::PANGO_STRETCH_SEMI_EXPANDED,
            Self::Expanded => ffi::PANGO_STRETCH_EXPANDED,
            Self::ExtraExpanded => ffi::PANGO_STRETCH_EXTRA_EXPANDED,
            Self::UltraExpanded => ffi::PANGO_STRETCH_ULTRA_EXPANDED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoStretch> for Stretch {
    unsafe fn from_glib(value: ffi::PangoStretch) -> Self {
        match value {
            ffi::PANGO_STRETCH_ULTRA_CONDENSED => Self::UltraCondensed,
            ffi::PANGO_STRETCH_EXTRA_CONDENSED => Self::ExtraCondensed,
            ffi::PANGO_STRETCH_CONDENSED => Self::Condensed,
            ffi::PANGO_STRETCH_SEMI_CONDENSED => Self::SemiCondensed,
            ffi::PANGO_STRETCH_NORMAL => Self::Normal,
            ffi::PANGO_STRETCH_SEMI_EXPANDED => Self::SemiExpanded,
            ffi::PANGO_STRETCH_EXPANDED => Self::Expanded,
            ffi::PANGO_STRETCH_EXTRA_EXPANDED => Self::ExtraExpanded,
            ffi::PANGO_STRETCH_ULTRA_EXPANDED => Self::UltraExpanded,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Stretch {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_stretch_get_type()) }
    }
}

impl glib::value::ValueType for Stretch {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Stretch {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Stretch {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoStyle")]
pub enum Style {
    #[doc(alias = "PANGO_STYLE_NORMAL")]
    Normal,
    #[doc(alias = "PANGO_STYLE_OBLIQUE")]
    Oblique,
    #[doc(alias = "PANGO_STYLE_ITALIC")]
    Italic,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Style {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Style::{}",
            match *self {
                Self::Normal => "Normal",
                Self::Oblique => "Oblique",
                Self::Italic => "Italic",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Style {
    type GlibType = ffi::PangoStyle;

    fn into_glib(self) -> ffi::PangoStyle {
        match self {
            Self::Normal => ffi::PANGO_STYLE_NORMAL,
            Self::Oblique => ffi::PANGO_STYLE_OBLIQUE,
            Self::Italic => ffi::PANGO_STYLE_ITALIC,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoStyle> for Style {
    unsafe fn from_glib(value: ffi::PangoStyle) -> Self {
        match value {
            ffi::PANGO_STYLE_NORMAL => Self::Normal,
            ffi::PANGO_STYLE_OBLIQUE => Self::Oblique,
            ffi::PANGO_STYLE_ITALIC => Self::Italic,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Style {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_style_get_type()) }
    }
}

impl glib::value::ValueType for Style {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Style {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Style {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoTabAlign")]
pub enum TabAlign {
    #[doc(alias = "PANGO_TAB_LEFT")]
    Left,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_TAB_RIGHT")]
    Right,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_TAB_CENTER")]
    Center,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_TAB_DECIMAL")]
    Decimal,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TabAlign {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TabAlign::{}",
            match *self {
                Self::Left => "Left",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::Right => "Right",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::Center => "Center",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::Decimal => "Decimal",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TabAlign {
    type GlibType = ffi::PangoTabAlign;

    fn into_glib(self) -> ffi::PangoTabAlign {
        match self {
            Self::Left => ffi::PANGO_TAB_LEFT,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::Right => ffi::PANGO_TAB_RIGHT,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::Center => ffi::PANGO_TAB_CENTER,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::Decimal => ffi::PANGO_TAB_DECIMAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoTabAlign> for TabAlign {
    unsafe fn from_glib(value: ffi::PangoTabAlign) -> Self {
        match value {
            ffi::PANGO_TAB_LEFT => Self::Left,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_TAB_RIGHT => Self::Right,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_TAB_CENTER => Self::Center,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_TAB_DECIMAL => Self::Decimal,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TabAlign {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_tab_align_get_type()) }
    }
}

impl glib::value::ValueType for TabAlign {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TabAlign {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TabAlign {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoTextTransform")]
pub enum TextTransform {
    #[doc(alias = "PANGO_TEXT_TRANSFORM_NONE")]
    None,
    #[doc(alias = "PANGO_TEXT_TRANSFORM_LOWERCASE")]
    Lowercase,
    #[doc(alias = "PANGO_TEXT_TRANSFORM_UPPERCASE")]
    Uppercase,
    #[doc(alias = "PANGO_TEXT_TRANSFORM_CAPITALIZE")]
    Capitalize,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl fmt::Display for TextTransform {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextTransform::{}",
            match *self {
                Self::None => "None",
                Self::Lowercase => "Lowercase",
                Self::Uppercase => "Uppercase",
                Self::Capitalize => "Capitalize",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[doc(hidden)]
impl IntoGlib for TextTransform {
    type GlibType = ffi::PangoTextTransform;

    fn into_glib(self) -> ffi::PangoTextTransform {
        match self {
            Self::None => ffi::PANGO_TEXT_TRANSFORM_NONE,
            Self::Lowercase => ffi::PANGO_TEXT_TRANSFORM_LOWERCASE,
            Self::Uppercase => ffi::PANGO_TEXT_TRANSFORM_UPPERCASE,
            Self::Capitalize => ffi::PANGO_TEXT_TRANSFORM_CAPITALIZE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
#[doc(hidden)]
impl FromGlib<ffi::PangoTextTransform> for TextTransform {
    unsafe fn from_glib(value: ffi::PangoTextTransform) -> Self {
        match value {
            ffi::PANGO_TEXT_TRANSFORM_NONE => Self::None,
            ffi::PANGO_TEXT_TRANSFORM_LOWERCASE => Self::Lowercase,
            ffi::PANGO_TEXT_TRANSFORM_UPPERCASE => Self::Uppercase,
            ffi::PANGO_TEXT_TRANSFORM_CAPITALIZE => Self::Capitalize,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl StaticType for TextTransform {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_text_transform_get_type()) }
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl glib::value::ValueType for TextTransform {
    type Type = Self;
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
unsafe impl<'a> FromValue<'a> for TextTransform {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
impl ToValue for TextTransform {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoUnderline")]
pub enum Underline {
    #[doc(alias = "PANGO_UNDERLINE_NONE")]
    None,
    #[doc(alias = "PANGO_UNDERLINE_SINGLE")]
    Single,
    #[doc(alias = "PANGO_UNDERLINE_DOUBLE")]
    Double,
    #[doc(alias = "PANGO_UNDERLINE_LOW")]
    Low,
    #[doc(alias = "PANGO_UNDERLINE_ERROR")]
    Error,
    #[doc(alias = "PANGO_UNDERLINE_SINGLE_LINE")]
    SingleLine,
    #[doc(alias = "PANGO_UNDERLINE_DOUBLE_LINE")]
    DoubleLine,
    #[doc(alias = "PANGO_UNDERLINE_ERROR_LINE")]
    ErrorLine,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Underline {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Underline::{}",
            match *self {
                Self::None => "None",
                Self::Single => "Single",
                Self::Double => "Double",
                Self::Low => "Low",
                Self::Error => "Error",
                Self::SingleLine => "SingleLine",
                Self::DoubleLine => "DoubleLine",
                Self::ErrorLine => "ErrorLine",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Underline {
    type GlibType = ffi::PangoUnderline;

    fn into_glib(self) -> ffi::PangoUnderline {
        match self {
            Self::None => ffi::PANGO_UNDERLINE_NONE,
            Self::Single => ffi::PANGO_UNDERLINE_SINGLE,
            Self::Double => ffi::PANGO_UNDERLINE_DOUBLE,
            Self::Low => ffi::PANGO_UNDERLINE_LOW,
            Self::Error => ffi::PANGO_UNDERLINE_ERROR,
            Self::SingleLine => ffi::PANGO_UNDERLINE_SINGLE_LINE,
            Self::DoubleLine => ffi::PANGO_UNDERLINE_DOUBLE_LINE,
            Self::ErrorLine => ffi::PANGO_UNDERLINE_ERROR_LINE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoUnderline> for Underline {
    unsafe fn from_glib(value: ffi::PangoUnderline) -> Self {
        match value {
            ffi::PANGO_UNDERLINE_NONE => Self::None,
            ffi::PANGO_UNDERLINE_SINGLE => Self::Single,
            ffi::PANGO_UNDERLINE_DOUBLE => Self::Double,
            ffi::PANGO_UNDERLINE_LOW => Self::Low,
            ffi::PANGO_UNDERLINE_ERROR => Self::Error,
            ffi::PANGO_UNDERLINE_SINGLE_LINE => Self::SingleLine,
            ffi::PANGO_UNDERLINE_DOUBLE_LINE => Self::DoubleLine,
            ffi::PANGO_UNDERLINE_ERROR_LINE => Self::ErrorLine,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Underline {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_underline_get_type()) }
    }
}

impl glib::value::ValueType for Underline {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Underline {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Underline {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoVariant")]
pub enum Variant {
    #[doc(alias = "PANGO_VARIANT_NORMAL")]
    Normal,
    #[doc(alias = "PANGO_VARIANT_SMALL_CAPS")]
    SmallCaps,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_VARIANT_ALL_SMALL_CAPS")]
    AllSmallCaps,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_VARIANT_PETITE_CAPS")]
    PetiteCaps,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_VARIANT_ALL_PETITE_CAPS")]
    AllPetiteCaps,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_VARIANT_UNICASE")]
    Unicase,
    #[cfg(any(feature = "v1_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_50")))]
    #[doc(alias = "PANGO_VARIANT_TITLE_CAPS")]
    TitleCaps,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Variant {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Variant::{}",
            match *self {
                Self::Normal => "Normal",
                Self::SmallCaps => "SmallCaps",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::AllSmallCaps => "AllSmallCaps",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::PetiteCaps => "PetiteCaps",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::AllPetiteCaps => "AllPetiteCaps",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::Unicase => "Unicase",
                #[cfg(any(feature = "v1_50", feature = "dox"))]
                Self::TitleCaps => "TitleCaps",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Variant {
    type GlibType = ffi::PangoVariant;

    fn into_glib(self) -> ffi::PangoVariant {
        match self {
            Self::Normal => ffi::PANGO_VARIANT_NORMAL,
            Self::SmallCaps => ffi::PANGO_VARIANT_SMALL_CAPS,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::AllSmallCaps => ffi::PANGO_VARIANT_ALL_SMALL_CAPS,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::PetiteCaps => ffi::PANGO_VARIANT_PETITE_CAPS,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::AllPetiteCaps => ffi::PANGO_VARIANT_ALL_PETITE_CAPS,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::Unicase => ffi::PANGO_VARIANT_UNICASE,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            Self::TitleCaps => ffi::PANGO_VARIANT_TITLE_CAPS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoVariant> for Variant {
    unsafe fn from_glib(value: ffi::PangoVariant) -> Self {
        match value {
            ffi::PANGO_VARIANT_NORMAL => Self::Normal,
            ffi::PANGO_VARIANT_SMALL_CAPS => Self::SmallCaps,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_VARIANT_ALL_SMALL_CAPS => Self::AllSmallCaps,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_VARIANT_PETITE_CAPS => Self::PetiteCaps,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_VARIANT_ALL_PETITE_CAPS => Self::AllPetiteCaps,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_VARIANT_UNICASE => Self::Unicase,
            #[cfg(any(feature = "v1_50", feature = "dox"))]
            ffi::PANGO_VARIANT_TITLE_CAPS => Self::TitleCaps,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Variant {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_variant_get_type()) }
    }
}

impl glib::value::ValueType for Variant {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Variant {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Variant {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoWeight")]
pub enum Weight {
    #[doc(alias = "PANGO_WEIGHT_THIN")]
    Thin,
    #[doc(alias = "PANGO_WEIGHT_ULTRALIGHT")]
    Ultralight,
    #[doc(alias = "PANGO_WEIGHT_LIGHT")]
    Light,
    #[doc(alias = "PANGO_WEIGHT_SEMILIGHT")]
    Semilight,
    #[doc(alias = "PANGO_WEIGHT_BOOK")]
    Book,
    #[doc(alias = "PANGO_WEIGHT_NORMAL")]
    Normal,
    #[doc(alias = "PANGO_WEIGHT_MEDIUM")]
    Medium,
    #[doc(alias = "PANGO_WEIGHT_SEMIBOLD")]
    Semibold,
    #[doc(alias = "PANGO_WEIGHT_BOLD")]
    Bold,
    #[doc(alias = "PANGO_WEIGHT_ULTRABOLD")]
    Ultrabold,
    #[doc(alias = "PANGO_WEIGHT_HEAVY")]
    Heavy,
    #[doc(alias = "PANGO_WEIGHT_ULTRAHEAVY")]
    Ultraheavy,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Weight {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Weight::{}",
            match *self {
                Self::Thin => "Thin",
                Self::Ultralight => "Ultralight",
                Self::Light => "Light",
                Self::Semilight => "Semilight",
                Self::Book => "Book",
                Self::Normal => "Normal",
                Self::Medium => "Medium",
                Self::Semibold => "Semibold",
                Self::Bold => "Bold",
                Self::Ultrabold => "Ultrabold",
                Self::Heavy => "Heavy",
                Self::Ultraheavy => "Ultraheavy",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Weight {
    type GlibType = ffi::PangoWeight;

    fn into_glib(self) -> ffi::PangoWeight {
        match self {
            Self::Thin => ffi::PANGO_WEIGHT_THIN,
            Self::Ultralight => ffi::PANGO_WEIGHT_ULTRALIGHT,
            Self::Light => ffi::PANGO_WEIGHT_LIGHT,
            Self::Semilight => ffi::PANGO_WEIGHT_SEMILIGHT,
            Self::Book => ffi::PANGO_WEIGHT_BOOK,
            Self::Normal => ffi::PANGO_WEIGHT_NORMAL,
            Self::Medium => ffi::PANGO_WEIGHT_MEDIUM,
            Self::Semibold => ffi::PANGO_WEIGHT_SEMIBOLD,
            Self::Bold => ffi::PANGO_WEIGHT_BOLD,
            Self::Ultrabold => ffi::PANGO_WEIGHT_ULTRABOLD,
            Self::Heavy => ffi::PANGO_WEIGHT_HEAVY,
            Self::Ultraheavy => ffi::PANGO_WEIGHT_ULTRAHEAVY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoWeight> for Weight {
    unsafe fn from_glib(value: ffi::PangoWeight) -> Self {
        match value {
            ffi::PANGO_WEIGHT_THIN => Self::Thin,
            ffi::PANGO_WEIGHT_ULTRALIGHT => Self::Ultralight,
            ffi::PANGO_WEIGHT_LIGHT => Self::Light,
            ffi::PANGO_WEIGHT_SEMILIGHT => Self::Semilight,
            ffi::PANGO_WEIGHT_BOOK => Self::Book,
            ffi::PANGO_WEIGHT_NORMAL => Self::Normal,
            ffi::PANGO_WEIGHT_MEDIUM => Self::Medium,
            ffi::PANGO_WEIGHT_SEMIBOLD => Self::Semibold,
            ffi::PANGO_WEIGHT_BOLD => Self::Bold,
            ffi::PANGO_WEIGHT_ULTRABOLD => Self::Ultrabold,
            ffi::PANGO_WEIGHT_HEAVY => Self::Heavy,
            ffi::PANGO_WEIGHT_ULTRAHEAVY => Self::Ultraheavy,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Weight {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_weight_get_type()) }
    }
}

impl glib::value::ValueType for Weight {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Weight {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Weight {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PangoWrapMode")]
pub enum WrapMode {
    #[doc(alias = "PANGO_WRAP_WORD")]
    Word,
    #[doc(alias = "PANGO_WRAP_CHAR")]
    Char,
    #[doc(alias = "PANGO_WRAP_WORD_CHAR")]
    WordChar,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WrapMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WrapMode::{}",
            match *self {
                Self::Word => "Word",
                Self::Char => "Char",
                Self::WordChar => "WordChar",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WrapMode {
    type GlibType = ffi::PangoWrapMode;

    fn into_glib(self) -> ffi::PangoWrapMode {
        match self {
            Self::Word => ffi::PANGO_WRAP_WORD,
            Self::Char => ffi::PANGO_WRAP_CHAR,
            Self::WordChar => ffi::PANGO_WRAP_WORD_CHAR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PangoWrapMode> for WrapMode {
    unsafe fn from_glib(value: ffi::PangoWrapMode) -> Self {
        match value {
            ffi::PANGO_WRAP_WORD => Self::Word,
            ffi::PANGO_WRAP_CHAR => Self::Char,
            ffi::PANGO_WRAP_WORD_CHAR => Self::WordChar,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WrapMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::pango_wrap_mode_get_type()) }
    }
}

impl glib::value::ValueType for WrapMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WrapMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WrapMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
