; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=m68k -verify-machineinstrs | FileCheck %s

define i32 @test1(ptr %y) nounwind {
; CHECK-LABEL: test1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %a0
; CHECK-NEXT:    cmpi.l #0, (%a0)
; CHECK-NEXT:    beq .LBB0_2
; CHECK-NEXT:  ; %bb.1: ; %cond_false
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    rts
; CHECK-NEXT:  .LBB0_2: ; %cond_true
; CHECK-NEXT:    moveq #1, %d0
; CHECK-NEXT:    rts
 %tmp = load i32, ptr %y  ; <i32> [#uses=1]
 %tmp.upgrd.1 = icmp eq i32 %tmp, 0  ; <i1> [#uses=1]
 br i1 %tmp.upgrd.1, label %cond_true, label %cond_false

cond_false:  ; preds = %0
 ret i32 0

cond_true:     ; preds = %0
 ret i32 1
}

define i32 @test2(ptr %y) nounwind {
; CHECK-LABEL: test2:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %a0
; CHECK-NEXT:    move.l (%a0), %d0
; CHECK-NEXT:    and.l #536870911, %d0
; CHECK-NEXT:    cmpi.l #0, %d0
; CHECK-NEXT:    beq .LBB1_2
; CHECK-NEXT:  ; %bb.1: ; %cond_false
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    rts
; CHECK-NEXT:  .LBB1_2: ; %cond_true
; CHECK-NEXT:    moveq #1, %d0
; CHECK-NEXT:    rts
 %tmp = load i32, ptr %y  ; <i32> [#uses=1]
 %tmp1 = shl i32 %tmp, 3  ; <i32> [#uses=1]
 %tmp1.upgrd.2 = icmp eq i32 %tmp1, 0  ; <i1> [#uses=1]
 br i1 %tmp1.upgrd.2, label %cond_true, label %cond_false

cond_false:  ; preds = %0
 ret i32 0

cond_true:  ; preds = %0
 ret i32 1
}

define i8 @test2b(ptr %y) nounwind {
; CHECK-LABEL: test2b:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %a0
; CHECK-NEXT:    move.b (%a0), %d0
; CHECK-NEXT:    and.b #31, %d0
; CHECK-NEXT:    cmpi.b #0, %d0
; CHECK-NEXT:    beq .LBB2_2
; CHECK-NEXT:  ; %bb.1: ; %cond_false
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    rts
; CHECK-NEXT:  .LBB2_2: ; %cond_true
; CHECK-NEXT:    moveq #1, %d0
; CHECK-NEXT:    rts
 %tmp = load i8, ptr %y  ; <i8> [#uses=1]
 %tmp1 = shl i8 %tmp, 3  ; <i8> [#uses=1]
 %tmp1.upgrd.2 = icmp eq i8 %tmp1, 0  ; <i1> [#uses=1]
 br i1 %tmp1.upgrd.2, label %cond_true, label %cond_false

cond_false:  ; preds = %0
 ret i8 0

cond_true:  ; preds = %0
 ret i8 1
}

define i64 @test3(i64 %x) nounwind {
; CHECK-LABEL: test3:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.l (8,%sp), %d0
; CHECK-NEXT:    or.l (4,%sp), %d0
; CHECK-NEXT:    seq %d0
; CHECK-NEXT:    move.l %d0, %d1
; CHECK-NEXT:    and.l #255, %d1
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    rts
  %t = icmp eq i64 %x, 0
  %r = zext i1 %t to i64
  ret i64 %r
}

define i64 @test4(i64 %x) nounwind {
; CHECK-LABEL: test4:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    suba.l #4, %sp
; CHECK-NEXT:    movem.l %d2, (0,%sp) ; 8-byte Folded Spill
; CHECK-NEXT:    move.l (8,%sp), %d1
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    move.l (12,%sp), %d2
; CHECK-NEXT:    sub.l #1, %d2
; CHECK-NEXT:    subx.l %d0, %d1
; CHECK-NEXT:    slt %d1
; CHECK-NEXT:    and.l #255, %d1
; CHECK-NEXT:    movem.l (0,%sp), %d2 ; 8-byte Folded Reload
; CHECK-NEXT:    adda.l #4, %sp
; CHECK-NEXT:    rts
  %t = icmp slt i64 %x, 1
  %r = zext i1 %t to i64
  ret i64 %r
}

define i32 @test6() nounwind align 2 {
; CHECK-LABEL: test6:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    suba.l #20, %sp
; CHECK-NEXT:    move.l (12,%sp), %d0
; CHECK-NEXT:    or.l (8,%sp), %d0
; CHECK-NEXT:    beq .LBB5_1
; CHECK-NEXT:  ; %bb.2: ; %F
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    adda.l #20, %sp
; CHECK-NEXT:    rts
; CHECK-NEXT:  .LBB5_1: ; %T
; CHECK-NEXT:    moveq #1, %d0
; CHECK-NEXT:    adda.l #20, %sp
; CHECK-NEXT:    rts
  %A = alloca {i64, i64}, align 8
  %B = getelementptr inbounds {i64, i64}, ptr %A, i64 0, i32 1
  %C = load i64, ptr %B
  %D = icmp eq i64 %C, 0
  br i1 %D, label %T, label %F
T:
  ret i32 1

F:
  ret i32 0
}

define i32 @test7(i64 %res) nounwind {
; CHECK-LABEL: test7:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    cmpi.l #0, (4,%sp)
; CHECK-NEXT:    seq %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    rts
entry:
  %lnot = icmp ult i64 %res, 4294967296
  %lnot.ext = zext i1 %lnot to i32
  ret i32 %lnot.ext
}

define i32 @test8(i64 %res) nounwind {
; CHECK-LABEL: test8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    sub.l #3, %d0
; CHECK-NEXT:    scs %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    rts
entry:
  %lnot = icmp ult i64 %res, 12884901888
  %lnot.ext = zext i1 %lnot to i32
  ret i32 %lnot.ext
}

define i32 @test11(i64 %l) nounwind {
; CHECK-LABEL: test11:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    and.l #-32768, %d0
; CHECK-NEXT:    sub.l #32768, %d0
; CHECK-NEXT:    seq %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    rts
entry:
  %shr.mask = and i64 %l, -140737488355328
  %cmp = icmp eq i64 %shr.mask, 140737488355328
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @test13(i32 %mask, i32 %base, i32 %intra) {
; CHECK-LABEL: test13:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.b (7,%sp), %d0
; CHECK-NEXT:    and.b #8, %d0
; CHECK-NEXT:    cmpi.b #0, %d0
; CHECK-NEXT:    bne .LBB9_1
; CHECK-NEXT:  ; %bb.2:
; CHECK-NEXT:    lea (8,%sp), %a0
; CHECK-NEXT:    move.l (%a0), %d0
; CHECK-NEXT:    rts
; CHECK-NEXT:  .LBB9_1:
; CHECK-NEXT:    lea (12,%sp), %a0
; CHECK-NEXT:    move.l (%a0), %d0
; CHECK-NEXT:    rts
  %and = and i32 %mask, 8
  %tobool = icmp ne i32 %and, 0
  %cond = select i1 %tobool, i32 %intra, i32 %base
  ret i32 %cond
}

define i32 @test14(i32 %mask, i32 %base, i32 %intra) #0 {
; CHECK-LABEL: test14:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    lsr.l #7, %d0
; CHECK-NEXT:    cmpi.l #0, %d0
; CHECK-NEXT:    bpl .LBB10_1
; CHECK-NEXT:  ; %bb.2:
; CHECK-NEXT:    lea (8,%sp), %a0
; CHECK-NEXT:    move.l (%a0), %d0
; CHECK-NEXT:    rts
; CHECK-NEXT:  .LBB10_1:
; CHECK-NEXT:    lea (12,%sp), %a0
; CHECK-NEXT:    move.l (%a0), %d0
; CHECK-NEXT:    rts
  %s = lshr i32 %mask, 7
  %tobool = icmp sgt i32 %s, -1
  %cond = select i1 %tobool, i32 %intra, i32 %base
  ret i32 %cond
}

define zeroext i1 @test15(i32 %bf.load, i32 %n) {
; CHECK-LABEL: test15:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    moveq #16, %d0
; CHECK-NEXT:    move.l (4,%sp), %d1
; CHECK-NEXT:    lsr.l %d0, %d1
; CHECK-NEXT:    move.l %d1, %d0
; CHECK-NEXT:    sub.l (8,%sp), %d0
; CHECK-NEXT:    scc %d0
; CHECK-NEXT:    cmpi.l #0, %d1
; CHECK-NEXT:    seq %d1
; CHECK-NEXT:    or.b %d0, %d1
; CHECK-NEXT:    move.l %d1, %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    rts
  %bf.lshr = lshr i32 %bf.load, 16
  %cmp2 = icmp eq i32 %bf.lshr, 0
  %cmp5 = icmp uge i32 %bf.lshr, %n
  %.cmp5 = or i1 %cmp2, %cmp5
  ret i1 %.cmp5
}

define i8 @test16(i16 signext %L) {
; CHECK-LABEL: test16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    moveq #15, %d1
; CHECK-NEXT:    move.w (6,%sp), %d0
; CHECK-NEXT:    lsr.w %d1, %d0
; CHECK-NEXT:    eori.b #1, %d0
; CHECK-NEXT:    ; kill: def $bd0 killed $bd0 killed $wd0
; CHECK-NEXT:    rts
  %lshr  = lshr i16 %L, 15
  %trunc = trunc i16 %lshr to i8
  %not   = xor i8 %trunc, 1
  ret i8 %not
}

define i8 @test18(i64 %L) {
; CHECK-LABEL: test18:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    moveq #31, %d1
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    lsr.l %d1, %d0
; CHECK-NEXT:    eori.b #1, %d0
; CHECK-NEXT:    ; kill: def $bd0 killed $bd0 killed $d0
; CHECK-NEXT:    rts
  %lshr  = lshr i64 %L, 63
  %trunc = trunc i64 %lshr to i8
  %not   = xor i8 %trunc, 1
  ret i8 %not
}

@d = global i8 0, align 1

define void @test20(i32 %bf.load, i8 %x1, ptr %b_addr) {
; CHECK-LABEL: test20:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    suba.l #4, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -8
; CHECK-NEXT:    movem.l %d2, (0,%sp) ; 8-byte Folded Spill
; CHECK-NEXT:    move.l #16777215, %d0
; CHECK-NEXT:    and.l (8,%sp), %d0
; CHECK-NEXT:    sne %d1
; CHECK-NEXT:    and.l #255, %d1
; CHECK-NEXT:    move.l (16,%sp), %a0
; CHECK-NEXT:    move.b (15,%sp), %d2
; CHECK-NEXT:    and.l #255, %d2
; CHECK-NEXT:    add.l %d1, %d2
; CHECK-NEXT:    sne (%a0)
; CHECK-NEXT:    cmpi.l #0, %d0
; CHECK-NEXT:    lea (d,%pc), %a0
; CHECK-NEXT:    sne (%a0)
; CHECK-NEXT:    movem.l (0,%sp), %d2 ; 8-byte Folded Reload
; CHECK-NEXT:    adda.l #4, %sp
; CHECK-NEXT:    rts
  %bf.shl = shl i32 %bf.load, 8
  %bf.ashr = ashr exact i32 %bf.shl, 8
  %tobool4 = icmp ne i32 %bf.ashr, 0
  %conv = zext i1 %tobool4 to i32
  %conv6 = zext i8 %x1 to i32
  %add = add nuw nsw i32 %conv, %conv6
  %tobool7 = icmp ne i32 %add, 0
  %frombool = zext i1 %tobool7 to i8
  store i8 %frombool, ptr %b_addr, align 1
  %tobool14 = icmp ne i32 %bf.shl, 0
  %frombool15 = zext i1 %tobool14 to i8
  store i8 %frombool15, ptr @d, align 1
  ret void
}
