// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/osconfig/agentendpoint/v1/patch_jobs.proto

package agentendpoint

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Post-patch reboot settings.
type PatchConfig_RebootConfig int32

const (
	// The default behavior is DEFAULT.
	PatchConfig_REBOOT_CONFIG_UNSPECIFIED PatchConfig_RebootConfig = 0
	// The agent decides if a reboot is necessary by checking
	// signals such as registry keys on Windows or `/var/run/reboot-required` on
	// APT based systems. On RPM based systems, a set of core system package
	// install times are compared with system boot time.
	PatchConfig_DEFAULT PatchConfig_RebootConfig = 1
	// Always reboot the machine after the update completes.
	PatchConfig_ALWAYS PatchConfig_RebootConfig = 2
	// Never reboot the machine after the update completes.
	PatchConfig_NEVER PatchConfig_RebootConfig = 3
)

var PatchConfig_RebootConfig_name = map[int32]string{
	0: "REBOOT_CONFIG_UNSPECIFIED",
	1: "DEFAULT",
	2: "ALWAYS",
	3: "NEVER",
}

var PatchConfig_RebootConfig_value = map[string]int32{
	"REBOOT_CONFIG_UNSPECIFIED": 0,
	"DEFAULT":                   1,
	"ALWAYS":                    2,
	"NEVER":                     3,
}

func (x PatchConfig_RebootConfig) String() string {
	return proto.EnumName(PatchConfig_RebootConfig_name, int32(x))
}

func (PatchConfig_RebootConfig) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{0, 0}
}

// Apt patch type.
type AptSettings_Type int32

const (
	// By default, upgrade will be performed.
	AptSettings_TYPE_UNSPECIFIED AptSettings_Type = 0
	// Runs `apt-get dist-upgrade`.
	AptSettings_DIST AptSettings_Type = 1
	// Runs `apt-get upgrade`.
	AptSettings_UPGRADE AptSettings_Type = 2
)

var AptSettings_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "DIST",
	2: "UPGRADE",
}

var AptSettings_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"DIST":             1,
	"UPGRADE":          2,
}

func (x AptSettings_Type) String() string {
	return proto.EnumName(AptSettings_Type_name, int32(x))
}

func (AptSettings_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{1, 0}
}

// Microsoft Windows update classifications as defined in
// [1]
// https://support.microsoft.com/en-us/help/824684/description-of-the-standard-terminology-that-is-used-to-describe-micro
type WindowsUpdateSettings_Classification int32

const (
	// Invalid. If classifications are included, they must be specified.
	WindowsUpdateSettings_CLASSIFICATION_UNSPECIFIED WindowsUpdateSettings_Classification = 0
	// "A widely released fix for a specific problem that addresses a critical,
	// non-security-related bug." [1]
	WindowsUpdateSettings_CRITICAL WindowsUpdateSettings_Classification = 1
	// "A widely released fix for a product-specific, security-related
	// vulnerability. Security vulnerabilities are rated by their severity. The
	// severity rating is indicated in the Microsoft security bulletin as
	// critical, important, moderate, or low." [1]
	WindowsUpdateSettings_SECURITY WindowsUpdateSettings_Classification = 2
	// "A widely released and frequent software update that contains additions
	// to a product’s definition database. Definition databases are often used
	// to detect objects that have specific attributes, such as malicious code,
	// phishing websites, or junk mail." [1]
	WindowsUpdateSettings_DEFINITION WindowsUpdateSettings_Classification = 3
	// "Software that controls the input and output of a device." [1]
	WindowsUpdateSettings_DRIVER WindowsUpdateSettings_Classification = 4
	// "New product functionality that is first distributed outside the context
	// of a product release and that is typically included in the next full
	// product release." [1]
	WindowsUpdateSettings_FEATURE_PACK WindowsUpdateSettings_Classification = 5
	// "A tested, cumulative set of all hotfixes, security updates, critical
	// updates, and updates. Additionally, service packs may contain additional
	// fixes for problems that are found internally since the release of the
	// product. Service packs my also contain a limited number of
	// customer-requested design changes or features." [1]
	WindowsUpdateSettings_SERVICE_PACK WindowsUpdateSettings_Classification = 6
	// "A utility or feature that helps complete a task or set of tasks." [1]
	WindowsUpdateSettings_TOOL WindowsUpdateSettings_Classification = 7
	// "A tested, cumulative set of hotfixes, security updates, critical
	// updates, and updates that are packaged together for easy deployment. A
	// rollup generally targets a specific area, such as security, or a
	// component of a product, such as Internet Information Services (IIS)." [1]
	WindowsUpdateSettings_UPDATE_ROLLUP WindowsUpdateSettings_Classification = 8
	// "A widely released fix for a specific problem. An update addresses a
	// noncritical, non-security-related bug." [1]
	WindowsUpdateSettings_UPDATE WindowsUpdateSettings_Classification = 9
)

var WindowsUpdateSettings_Classification_name = map[int32]string{
	0: "CLASSIFICATION_UNSPECIFIED",
	1: "CRITICAL",
	2: "SECURITY",
	3: "DEFINITION",
	4: "DRIVER",
	5: "FEATURE_PACK",
	6: "SERVICE_PACK",
	7: "TOOL",
	8: "UPDATE_ROLLUP",
	9: "UPDATE",
}

var WindowsUpdateSettings_Classification_value = map[string]int32{
	"CLASSIFICATION_UNSPECIFIED": 0,
	"CRITICAL":                   1,
	"SECURITY":                   2,
	"DEFINITION":                 3,
	"DRIVER":                     4,
	"FEATURE_PACK":               5,
	"SERVICE_PACK":               6,
	"TOOL":                       7,
	"UPDATE_ROLLUP":              8,
	"UPDATE":                     9,
}

func (x WindowsUpdateSettings_Classification) String() string {
	return proto.EnumName(WindowsUpdateSettings_Classification_name, int32(x))
}

func (WindowsUpdateSettings_Classification) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{5, 0}
}

// The interpreter used to execute the a file.
type ExecStepConfig_Interpreter int32

const (
	// Invalid for a Windows ExecStepConfig. For a Linux ExecStepConfig, the
	// interpreter will be parsed from the shebang line of the script if
	// unspecified.
	ExecStepConfig_INTERPRETER_UNSPECIFIED ExecStepConfig_Interpreter = 0
	// Indicates that the script will be run with /bin/sh on Linux and cmd
	// on windows.
	ExecStepConfig_SHELL ExecStepConfig_Interpreter = 1
	// Indicates that the file will be run with PowerShell.
	ExecStepConfig_POWERSHELL ExecStepConfig_Interpreter = 2
)

var ExecStepConfig_Interpreter_name = map[int32]string{
	0: "INTERPRETER_UNSPECIFIED",
	1: "SHELL",
	2: "POWERSHELL",
}

var ExecStepConfig_Interpreter_value = map[string]int32{
	"INTERPRETER_UNSPECIFIED": 0,
	"SHELL":                   1,
	"POWERSHELL":              2,
}

func (x ExecStepConfig_Interpreter) String() string {
	return proto.EnumName(ExecStepConfig_Interpreter_name, int32(x))
}

func (ExecStepConfig_Interpreter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{8, 0}
}

// Patch configuration specifications. Contains details on how to
// apply patches to a VM instance.
type PatchConfig struct {
	// Post-patch reboot settings.
	RebootConfig PatchConfig_RebootConfig `protobuf:"varint,1,opt,name=reboot_config,json=rebootConfig,proto3,enum=google.cloud.osconfig.agentendpoint.v1.PatchConfig_RebootConfig" json:"reboot_config,omitempty"`
	// Retry strategy can be defined to have the agent retry patching
	// during the window if patching fails. If omitted, the agent will use its
	// default retry strategy.
	RetryStrategy *RetryStrategy `protobuf:"bytes,2,opt,name=retry_strategy,json=retryStrategy,proto3" json:"retry_strategy,omitempty"`
	// Apt update settings. Use this override the default apt patch rules.
	Apt *AptSettings `protobuf:"bytes,3,opt,name=apt,proto3" json:"apt,omitempty"`
	// Yum update settings. Use this override the default yum patch rules.
	Yum *YumSettings `protobuf:"bytes,4,opt,name=yum,proto3" json:"yum,omitempty"`
	// Goo update settings. Use this override the default goo patch rules.
	Goo *GooSettings `protobuf:"bytes,5,opt,name=goo,proto3" json:"goo,omitempty"`
	// Zypper update settings. Use this override the default zypper patch rules.
	Zypper *ZypperSettings `protobuf:"bytes,6,opt,name=zypper,proto3" json:"zypper,omitempty"`
	// Windows update settings. Use this override the default windows patch rules.
	WindowsUpdate *WindowsUpdateSettings `protobuf:"bytes,7,opt,name=windows_update,json=windowsUpdate,proto3" json:"windows_update,omitempty"`
	// The ExecStep to run before the patch update.
	PreStep *ExecStep `protobuf:"bytes,8,opt,name=pre_step,json=preStep,proto3" json:"pre_step,omitempty"`
	// The ExecStep to run after the patch update.
	PostStep             *ExecStep `protobuf:"bytes,9,opt,name=post_step,json=postStep,proto3" json:"post_step,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *PatchConfig) Reset()         { *m = PatchConfig{} }
func (m *PatchConfig) String() string { return proto.CompactTextString(m) }
func (*PatchConfig) ProtoMessage()    {}
func (*PatchConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{0}
}

func (m *PatchConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchConfig.Unmarshal(m, b)
}
func (m *PatchConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchConfig.Marshal(b, m, deterministic)
}
func (m *PatchConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchConfig.Merge(m, src)
}
func (m *PatchConfig) XXX_Size() int {
	return xxx_messageInfo_PatchConfig.Size(m)
}
func (m *PatchConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PatchConfig proto.InternalMessageInfo

func (m *PatchConfig) GetRebootConfig() PatchConfig_RebootConfig {
	if m != nil {
		return m.RebootConfig
	}
	return PatchConfig_REBOOT_CONFIG_UNSPECIFIED
}

func (m *PatchConfig) GetRetryStrategy() *RetryStrategy {
	if m != nil {
		return m.RetryStrategy
	}
	return nil
}

func (m *PatchConfig) GetApt() *AptSettings {
	if m != nil {
		return m.Apt
	}
	return nil
}

func (m *PatchConfig) GetYum() *YumSettings {
	if m != nil {
		return m.Yum
	}
	return nil
}

func (m *PatchConfig) GetGoo() *GooSettings {
	if m != nil {
		return m.Goo
	}
	return nil
}

func (m *PatchConfig) GetZypper() *ZypperSettings {
	if m != nil {
		return m.Zypper
	}
	return nil
}

func (m *PatchConfig) GetWindowsUpdate() *WindowsUpdateSettings {
	if m != nil {
		return m.WindowsUpdate
	}
	return nil
}

func (m *PatchConfig) GetPreStep() *ExecStep {
	if m != nil {
		return m.PreStep
	}
	return nil
}

func (m *PatchConfig) GetPostStep() *ExecStep {
	if m != nil {
		return m.PostStep
	}
	return nil
}

// Apt patching will be performed by executing `apt-get update && apt-get
// upgrade`. Additional options can be set to control how this is executed.
type AptSettings struct {
	// By changing the type to DIST, the patching will be performed
	// using `apt-get dist-upgrade` instead.
	Type AptSettings_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.osconfig.agentendpoint.v1.AptSettings_Type" json:"type,omitempty"`
	// List of packages to exclude from update.
	Excludes []string `protobuf:"bytes,2,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of packages to be updated. These are the only packages
	// that will be updated. If these packages are not installed, they will be
	// ignored. This field cannot be specified with any other patch configuration
	// fields.
	ExclusivePackages    []string `protobuf:"bytes,3,rep,name=exclusive_packages,json=exclusivePackages,proto3" json:"exclusive_packages,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AptSettings) Reset()         { *m = AptSettings{} }
func (m *AptSettings) String() string { return proto.CompactTextString(m) }
func (*AptSettings) ProtoMessage()    {}
func (*AptSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{1}
}

func (m *AptSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AptSettings.Unmarshal(m, b)
}
func (m *AptSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AptSettings.Marshal(b, m, deterministic)
}
func (m *AptSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AptSettings.Merge(m, src)
}
func (m *AptSettings) XXX_Size() int {
	return xxx_messageInfo_AptSettings.Size(m)
}
func (m *AptSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_AptSettings.DiscardUnknown(m)
}

var xxx_messageInfo_AptSettings proto.InternalMessageInfo

func (m *AptSettings) GetType() AptSettings_Type {
	if m != nil {
		return m.Type
	}
	return AptSettings_TYPE_UNSPECIFIED
}

func (m *AptSettings) GetExcludes() []string {
	if m != nil {
		return m.Excludes
	}
	return nil
}

func (m *AptSettings) GetExclusivePackages() []string {
	if m != nil {
		return m.ExclusivePackages
	}
	return nil
}

// Yum patching will be performed by executing `yum update`. Additional options
// can be set to control how this is executed.
//
// Note that not all settings are supported on all platforms.
type YumSettings struct {
	// Adds the `--security` flag to `yum update`. Not supported on
	// all platforms.
	Security bool `protobuf:"varint,1,opt,name=security,proto3" json:"security,omitempty"`
	// Will cause patch to run `yum update-minimal` instead.
	Minimal bool `protobuf:"varint,2,opt,name=minimal,proto3" json:"minimal,omitempty"`
	// List of packages to exclude from update. These packages will be excluded by
	// using the yum `--exclude` flag.
	Excludes []string `protobuf:"bytes,3,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of packages to be updated. These are the only packages
	// that will be updated. If these packages are not installed, they will be
	// ignored. This field must not be specified with any other patch
	// configuration fields.
	ExclusivePackages    []string `protobuf:"bytes,4,rep,name=exclusive_packages,json=exclusivePackages,proto3" json:"exclusive_packages,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *YumSettings) Reset()         { *m = YumSettings{} }
func (m *YumSettings) String() string { return proto.CompactTextString(m) }
func (*YumSettings) ProtoMessage()    {}
func (*YumSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{2}
}

func (m *YumSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YumSettings.Unmarshal(m, b)
}
func (m *YumSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YumSettings.Marshal(b, m, deterministic)
}
func (m *YumSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YumSettings.Merge(m, src)
}
func (m *YumSettings) XXX_Size() int {
	return xxx_messageInfo_YumSettings.Size(m)
}
func (m *YumSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_YumSettings.DiscardUnknown(m)
}

var xxx_messageInfo_YumSettings proto.InternalMessageInfo

func (m *YumSettings) GetSecurity() bool {
	if m != nil {
		return m.Security
	}
	return false
}

func (m *YumSettings) GetMinimal() bool {
	if m != nil {
		return m.Minimal
	}
	return false
}

func (m *YumSettings) GetExcludes() []string {
	if m != nil {
		return m.Excludes
	}
	return nil
}

func (m *YumSettings) GetExclusivePackages() []string {
	if m != nil {
		return m.ExclusivePackages
	}
	return nil
}

// Googet patching is performed by running `googet update`.
type GooSettings struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GooSettings) Reset()         { *m = GooSettings{} }
func (m *GooSettings) String() string { return proto.CompactTextString(m) }
func (*GooSettings) ProtoMessage()    {}
func (*GooSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{3}
}

func (m *GooSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GooSettings.Unmarshal(m, b)
}
func (m *GooSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GooSettings.Marshal(b, m, deterministic)
}
func (m *GooSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GooSettings.Merge(m, src)
}
func (m *GooSettings) XXX_Size() int {
	return xxx_messageInfo_GooSettings.Size(m)
}
func (m *GooSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_GooSettings.DiscardUnknown(m)
}

var xxx_messageInfo_GooSettings proto.InternalMessageInfo

// Zypper patching is performed by running `zypper patch`.
// See also https://en.opensuse.org/SDB:Zypper_manual.
type ZypperSettings struct {
	// Adds the `--with-optional` flag to `zypper patch`.
	WithOptional bool `protobuf:"varint,1,opt,name=with_optional,json=withOptional,proto3" json:"with_optional,omitempty"`
	// Adds the `--with-update` flag, to `zypper patch`.
	WithUpdate bool `protobuf:"varint,2,opt,name=with_update,json=withUpdate,proto3" json:"with_update,omitempty"`
	// Install only patches with these categories.
	// Common categories include security, recommended, and feature.
	Categories []string `protobuf:"bytes,3,rep,name=categories,proto3" json:"categories,omitempty"`
	// Install only patches with these severities.
	// Common severities include critical, important, moderate, and low.
	Severities []string `protobuf:"bytes,4,rep,name=severities,proto3" json:"severities,omitempty"`
	// List of patches to exclude from update.
	Excludes []string `protobuf:"bytes,5,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of patches to be updated. These are the only patches
	// that will be installed using 'zypper patch patch:<patch_name>' command.
	// This field must not be used with any other patch configuration fields.
	ExclusivePatches     []string `protobuf:"bytes,6,rep,name=exclusive_patches,json=exclusivePatches,proto3" json:"exclusive_patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZypperSettings) Reset()         { *m = ZypperSettings{} }
func (m *ZypperSettings) String() string { return proto.CompactTextString(m) }
func (*ZypperSettings) ProtoMessage()    {}
func (*ZypperSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{4}
}

func (m *ZypperSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZypperSettings.Unmarshal(m, b)
}
func (m *ZypperSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZypperSettings.Marshal(b, m, deterministic)
}
func (m *ZypperSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZypperSettings.Merge(m, src)
}
func (m *ZypperSettings) XXX_Size() int {
	return xxx_messageInfo_ZypperSettings.Size(m)
}
func (m *ZypperSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ZypperSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ZypperSettings proto.InternalMessageInfo

func (m *ZypperSettings) GetWithOptional() bool {
	if m != nil {
		return m.WithOptional
	}
	return false
}

func (m *ZypperSettings) GetWithUpdate() bool {
	if m != nil {
		return m.WithUpdate
	}
	return false
}

func (m *ZypperSettings) GetCategories() []string {
	if m != nil {
		return m.Categories
	}
	return nil
}

func (m *ZypperSettings) GetSeverities() []string {
	if m != nil {
		return m.Severities
	}
	return nil
}

func (m *ZypperSettings) GetExcludes() []string {
	if m != nil {
		return m.Excludes
	}
	return nil
}

func (m *ZypperSettings) GetExclusivePatches() []string {
	if m != nil {
		return m.ExclusivePatches
	}
	return nil
}

// Windows patching is performed using the Windows Update Agent.
type WindowsUpdateSettings struct {
	// Only apply updates of these windows update classifications. If empty, all
	// updates will be applied.
	Classifications []WindowsUpdateSettings_Classification `protobuf:"varint,1,rep,packed,name=classifications,proto3,enum=google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings_Classification" json:"classifications,omitempty"`
	// List of KBs to exclude from update.
	Excludes []string `protobuf:"bytes,2,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of kbs to be updated. These are the only patches
	// that will be updated. This field must not be used with other
	// patch configurations.
	ExclusivePatches     []string `protobuf:"bytes,3,rep,name=exclusive_patches,json=exclusivePatches,proto3" json:"exclusive_patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowsUpdateSettings) Reset()         { *m = WindowsUpdateSettings{} }
func (m *WindowsUpdateSettings) String() string { return proto.CompactTextString(m) }
func (*WindowsUpdateSettings) ProtoMessage()    {}
func (*WindowsUpdateSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{5}
}

func (m *WindowsUpdateSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowsUpdateSettings.Unmarshal(m, b)
}
func (m *WindowsUpdateSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowsUpdateSettings.Marshal(b, m, deterministic)
}
func (m *WindowsUpdateSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsUpdateSettings.Merge(m, src)
}
func (m *WindowsUpdateSettings) XXX_Size() int {
	return xxx_messageInfo_WindowsUpdateSettings.Size(m)
}
func (m *WindowsUpdateSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsUpdateSettings.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsUpdateSettings proto.InternalMessageInfo

func (m *WindowsUpdateSettings) GetClassifications() []WindowsUpdateSettings_Classification {
	if m != nil {
		return m.Classifications
	}
	return nil
}

func (m *WindowsUpdateSettings) GetExcludes() []string {
	if m != nil {
		return m.Excludes
	}
	return nil
}

func (m *WindowsUpdateSettings) GetExclusivePatches() []string {
	if m != nil {
		return m.ExclusivePatches
	}
	return nil
}

// The strategy for retrying failed patches during the patch window.
type RetryStrategy struct {
	// If true, the agent will continue to try and patch until the window has
	// ended.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RetryStrategy) Reset()         { *m = RetryStrategy{} }
func (m *RetryStrategy) String() string { return proto.CompactTextString(m) }
func (*RetryStrategy) ProtoMessage()    {}
func (*RetryStrategy) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{6}
}

func (m *RetryStrategy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RetryStrategy.Unmarshal(m, b)
}
func (m *RetryStrategy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RetryStrategy.Marshal(b, m, deterministic)
}
func (m *RetryStrategy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetryStrategy.Merge(m, src)
}
func (m *RetryStrategy) XXX_Size() int {
	return xxx_messageInfo_RetryStrategy.Size(m)
}
func (m *RetryStrategy) XXX_DiscardUnknown() {
	xxx_messageInfo_RetryStrategy.DiscardUnknown(m)
}

var xxx_messageInfo_RetryStrategy proto.InternalMessageInfo

func (m *RetryStrategy) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// A step that runs an executable for a PatchJob.
type ExecStep struct {
	// The ExecStepConfig for all Linux VMs targeted by the PatchJob.
	LinuxExecStepConfig *ExecStepConfig `protobuf:"bytes,1,opt,name=linux_exec_step_config,json=linuxExecStepConfig,proto3" json:"linux_exec_step_config,omitempty"`
	// The ExecStepConfig for all Windows VMs targeted by the PatchJob.
	WindowsExecStepConfig *ExecStepConfig `protobuf:"bytes,2,opt,name=windows_exec_step_config,json=windowsExecStepConfig,proto3" json:"windows_exec_step_config,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}        `json:"-"`
	XXX_unrecognized      []byte          `json:"-"`
	XXX_sizecache         int32           `json:"-"`
}

func (m *ExecStep) Reset()         { *m = ExecStep{} }
func (m *ExecStep) String() string { return proto.CompactTextString(m) }
func (*ExecStep) ProtoMessage()    {}
func (*ExecStep) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{7}
}

func (m *ExecStep) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecStep.Unmarshal(m, b)
}
func (m *ExecStep) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecStep.Marshal(b, m, deterministic)
}
func (m *ExecStep) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecStep.Merge(m, src)
}
func (m *ExecStep) XXX_Size() int {
	return xxx_messageInfo_ExecStep.Size(m)
}
func (m *ExecStep) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecStep.DiscardUnknown(m)
}

var xxx_messageInfo_ExecStep proto.InternalMessageInfo

func (m *ExecStep) GetLinuxExecStepConfig() *ExecStepConfig {
	if m != nil {
		return m.LinuxExecStepConfig
	}
	return nil
}

func (m *ExecStep) GetWindowsExecStepConfig() *ExecStepConfig {
	if m != nil {
		return m.WindowsExecStepConfig
	}
	return nil
}

// Common configurations for an ExecStep.
type ExecStepConfig struct {
	// Location of the executable.
	//
	// Types that are valid to be assigned to Executable:
	//	*ExecStepConfig_LocalPath
	//	*ExecStepConfig_GcsObject
	Executable isExecStepConfig_Executable `protobuf_oneof:"executable"`
	// Defaults to [0]. A list of possible return values that the
	// execution can return to indicate a success.
	AllowedSuccessCodes []int32 `protobuf:"varint,3,rep,packed,name=allowed_success_codes,json=allowedSuccessCodes,proto3" json:"allowed_success_codes,omitempty"`
	// The script interpreter to use to run the script. If no interpreter is
	// specified the script will be executed directly, which will likely
	// only succeed for scripts with shebang lines.
	// [Wikipedia shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).
	Interpreter          ExecStepConfig_Interpreter `protobuf:"varint,4,opt,name=interpreter,proto3,enum=google.cloud.osconfig.agentendpoint.v1.ExecStepConfig_Interpreter" json:"interpreter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ExecStepConfig) Reset()         { *m = ExecStepConfig{} }
func (m *ExecStepConfig) String() string { return proto.CompactTextString(m) }
func (*ExecStepConfig) ProtoMessage()    {}
func (*ExecStepConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{8}
}

func (m *ExecStepConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecStepConfig.Unmarshal(m, b)
}
func (m *ExecStepConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecStepConfig.Marshal(b, m, deterministic)
}
func (m *ExecStepConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecStepConfig.Merge(m, src)
}
func (m *ExecStepConfig) XXX_Size() int {
	return xxx_messageInfo_ExecStepConfig.Size(m)
}
func (m *ExecStepConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecStepConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExecStepConfig proto.InternalMessageInfo

type isExecStepConfig_Executable interface {
	isExecStepConfig_Executable()
}

type ExecStepConfig_LocalPath struct {
	LocalPath string `protobuf:"bytes,1,opt,name=local_path,json=localPath,proto3,oneof"`
}

type ExecStepConfig_GcsObject struct {
	GcsObject *GcsObject `protobuf:"bytes,2,opt,name=gcs_object,json=gcsObject,proto3,oneof"`
}

func (*ExecStepConfig_LocalPath) isExecStepConfig_Executable() {}

func (*ExecStepConfig_GcsObject) isExecStepConfig_Executable() {}

func (m *ExecStepConfig) GetExecutable() isExecStepConfig_Executable {
	if m != nil {
		return m.Executable
	}
	return nil
}

func (m *ExecStepConfig) GetLocalPath() string {
	if x, ok := m.GetExecutable().(*ExecStepConfig_LocalPath); ok {
		return x.LocalPath
	}
	return ""
}

func (m *ExecStepConfig) GetGcsObject() *GcsObject {
	if x, ok := m.GetExecutable().(*ExecStepConfig_GcsObject); ok {
		return x.GcsObject
	}
	return nil
}

func (m *ExecStepConfig) GetAllowedSuccessCodes() []int32 {
	if m != nil {
		return m.AllowedSuccessCodes
	}
	return nil
}

func (m *ExecStepConfig) GetInterpreter() ExecStepConfig_Interpreter {
	if m != nil {
		return m.Interpreter
	}
	return ExecStepConfig_INTERPRETER_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExecStepConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExecStepConfig_LocalPath)(nil),
		(*ExecStepConfig_GcsObject)(nil),
	}
}

// GCS object representation.
type GcsObject struct {
	// Bucket of the GCS object.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Name of the GCS object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Generation number of the GCS object. This is used to ensure that the
	// ExecStep specified by this PatchJob does not change.
	GenerationNumber     int64    `protobuf:"varint,3,opt,name=generation_number,json=generationNumber,proto3" json:"generation_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsObject) Reset()         { *m = GcsObject{} }
func (m *GcsObject) String() string { return proto.CompactTextString(m) }
func (*GcsObject) ProtoMessage()    {}
func (*GcsObject) Descriptor() ([]byte, []int) {
	return fileDescriptor_b784aaf27e9fe4b6, []int{9}
}

func (m *GcsObject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsObject.Unmarshal(m, b)
}
func (m *GcsObject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsObject.Marshal(b, m, deterministic)
}
func (m *GcsObject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsObject.Merge(m, src)
}
func (m *GcsObject) XXX_Size() int {
	return xxx_messageInfo_GcsObject.Size(m)
}
func (m *GcsObject) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsObject.DiscardUnknown(m)
}

var xxx_messageInfo_GcsObject proto.InternalMessageInfo

func (m *GcsObject) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GcsObject) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *GcsObject) GetGenerationNumber() int64 {
	if m != nil {
		return m.GenerationNumber
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1.PatchConfig_RebootConfig", PatchConfig_RebootConfig_name, PatchConfig_RebootConfig_value)
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1.AptSettings_Type", AptSettings_Type_name, AptSettings_Type_value)
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings_Classification", WindowsUpdateSettings_Classification_name, WindowsUpdateSettings_Classification_value)
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1.ExecStepConfig_Interpreter", ExecStepConfig_Interpreter_name, ExecStepConfig_Interpreter_value)
	proto.RegisterType((*PatchConfig)(nil), "google.cloud.osconfig.agentendpoint.v1.PatchConfig")
	proto.RegisterType((*AptSettings)(nil), "google.cloud.osconfig.agentendpoint.v1.AptSettings")
	proto.RegisterType((*YumSettings)(nil), "google.cloud.osconfig.agentendpoint.v1.YumSettings")
	proto.RegisterType((*GooSettings)(nil), "google.cloud.osconfig.agentendpoint.v1.GooSettings")
	proto.RegisterType((*ZypperSettings)(nil), "google.cloud.osconfig.agentendpoint.v1.ZypperSettings")
	proto.RegisterType((*WindowsUpdateSettings)(nil), "google.cloud.osconfig.agentendpoint.v1.WindowsUpdateSettings")
	proto.RegisterType((*RetryStrategy)(nil), "google.cloud.osconfig.agentendpoint.v1.RetryStrategy")
	proto.RegisterType((*ExecStep)(nil), "google.cloud.osconfig.agentendpoint.v1.ExecStep")
	proto.RegisterType((*ExecStepConfig)(nil), "google.cloud.osconfig.agentendpoint.v1.ExecStepConfig")
	proto.RegisterType((*GcsObject)(nil), "google.cloud.osconfig.agentendpoint.v1.GcsObject")
}

func init() {
	proto.RegisterFile("google/cloud/osconfig/agentendpoint/v1/patch_jobs.proto", fileDescriptor_b784aaf27e9fe4b6)
}

var fileDescriptor_b784aaf27e9fe4b6 = []byte{
	// 1139 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x96, 0xdd, 0x8e, 0xdb, 0x44,
	0x14, 0xc7, 0xeb, 0x64, 0x37, 0x9b, 0x9c, 0x7c, 0xe0, 0x4e, 0x69, 0x31, 0x45, 0xb4, 0x2b, 0x23,
	0xa1, 0x05, 0x84, 0x43, 0xb7, 0xe2, 0x43, 0x42, 0x48, 0x64, 0x1d, 0xa7, 0x35, 0x0d, 0x49, 0x18,
	0x3b, 0xad, 0xb6, 0x42, 0xb2, 0x1c, 0x67, 0xea, 0xb8, 0x75, 0x3c, 0x96, 0x3d, 0xde, 0xdd, 0xf0,
	0x0c, 0x08, 0xf1, 0x32, 0xbc, 0x05, 0x6f, 0xc0, 0x05, 0xb7, 0x3c, 0x00, 0x0f, 0x80, 0x66, 0xe2,
	0x64, 0x9d, 0xd0, 0x42, 0xba, 0xbd, 0xcb, 0xf9, 0x1f, 0xff, 0x7f, 0x9e, 0x33, 0x39, 0x67, 0xc6,
	0xf0, 0xa5, 0x4f, 0xa9, 0x1f, 0x92, 0xb6, 0x17, 0xd2, 0x6c, 0xda, 0xa6, 0xa9, 0x47, 0xa3, 0x67,
	0x81, 0xdf, 0x76, 0x7d, 0x12, 0x31, 0x12, 0x4d, 0x63, 0x1a, 0x44, 0xac, 0x7d, 0x76, 0xaf, 0x1d,
	0xbb, 0xcc, 0x9b, 0x39, 0xcf, 0xe9, 0x24, 0xd5, 0xe2, 0x84, 0x32, 0x8a, 0x3e, 0x5c, 0x1a, 0x35,
	0x61, 0xd4, 0x56, 0x46, 0x6d, 0xc3, 0xa8, 0x9d, 0xdd, 0x53, 0x7f, 0xaf, 0x40, 0x7d, 0xc4, 0xcd,
	0xba, 0x78, 0x00, 0x11, 0x68, 0x26, 0x64, 0x42, 0x29, 0x73, 0x96, 0x0e, 0x45, 0x3a, 0x94, 0x8e,
	0x5a, 0xc7, 0xdf, 0x6a, 0xbb, 0xf1, 0xb4, 0x02, 0x4b, 0xc3, 0x02, 0xb4, 0x0c, 0x70, 0x23, 0x29,
	0x44, 0xe8, 0x47, 0x68, 0x25, 0x84, 0x25, 0x0b, 0x27, 0x65, 0x89, 0xcb, 0x88, 0xbf, 0x50, 0x4a,
	0x87, 0xd2, 0x51, 0xfd, 0xf8, 0xf3, 0x5d, 0xdf, 0x83, 0xb9, 0xdb, 0xca, 0xcd, 0xb8, 0x99, 0x14,
	0x43, 0x64, 0x40, 0xd9, 0x8d, 0x99, 0x52, 0x16, 0xc8, 0xfb, 0xbb, 0x22, 0x3b, 0x31, 0xb3, 0x08,
	0x63, 0x41, 0xe4, 0xa7, 0x98, 0xfb, 0x39, 0x66, 0x91, 0xcd, 0x95, 0xbd, 0xd7, 0xc3, 0x9c, 0x66,
	0xf3, 0x4b, 0xcc, 0x22, 0x9b, 0x73, 0x8c, 0x4f, 0xa9, 0xb2, 0xff, 0x7a, 0x98, 0x07, 0x94, 0x5e,
	0x62, 0x7c, 0x4a, 0xd1, 0x00, 0x2a, 0x3f, 0x2d, 0xe2, 0x98, 0x24, 0x4a, 0x45, 0x90, 0xbe, 0xd8,
	0x95, 0xf4, 0x54, 0xb8, 0xd6, 0xb0, 0x9c, 0x82, 0xa6, 0xd0, 0x3a, 0x0f, 0xa2, 0x29, 0x3d, 0x4f,
	0x9d, 0x2c, 0x9e, 0xba, 0x8c, 0x28, 0x07, 0x82, 0xfb, 0xcd, 0xae, 0xdc, 0x27, 0x4b, 0xf7, 0x58,
	0x98, 0xd7, 0xf8, 0xe6, 0x79, 0x51, 0x46, 0x8f, 0xa0, 0x1a, 0x27, 0xc4, 0x49, 0x19, 0x89, 0x95,
	0xaa, 0xe0, 0x7f, 0xb6, 0x2b, 0xdf, 0xb8, 0x20, 0x9e, 0xc5, 0x48, 0x8c, 0x0f, 0xe2, 0x84, 0xf0,
	0x1f, 0xe8, 0x7b, 0xa8, 0xc5, 0x34, 0x65, 0x4b, 0x5a, 0xed, 0x8a, 0xb4, 0x2a, 0x47, 0xf0, 0x5f,
	0xea, 0x0f, 0xd0, 0x28, 0xb6, 0x28, 0x7a, 0x1f, 0xde, 0xc5, 0xc6, 0xc9, 0x70, 0x68, 0x3b, 0xfa,
	0x70, 0xd0, 0x33, 0x1f, 0x38, 0xe3, 0x81, 0x35, 0x32, 0x74, 0xb3, 0x67, 0x1a, 0x5d, 0xf9, 0x1a,
	0xaa, 0xc3, 0x41, 0xd7, 0xe8, 0x75, 0xc6, 0x7d, 0x5b, 0x96, 0x10, 0x40, 0xa5, 0xd3, 0x7f, 0xd2,
	0x39, 0xb5, 0xe4, 0x12, 0xaa, 0xc1, 0xfe, 0xc0, 0x78, 0x6c, 0x60, 0xb9, 0xac, 0xfe, 0x21, 0x41,
	0xbd, 0xd0, 0x47, 0xa8, 0x0f, 0x7b, 0x6c, 0x11, 0x93, 0x7c, 0x8a, 0xbe, 0xba, 0x42, 0x2b, 0x6a,
	0xf6, 0x22, 0x26, 0x58, 0x50, 0xd0, 0x6d, 0xa8, 0x92, 0x0b, 0x2f, 0xcc, 0xa6, 0x24, 0x55, 0x4a,
	0x87, 0xe5, 0xa3, 0x1a, 0x5e, 0xc7, 0xe8, 0x53, 0x40, 0xe2, 0x77, 0x1a, 0x9c, 0x11, 0x27, 0x76,
	0xbd, 0x17, 0xae, 0x4f, 0x52, 0xa5, 0x2c, 0x9e, 0xba, 0xbe, 0xce, 0x8c, 0xf2, 0x84, 0x7a, 0x1f,
	0xf6, 0x38, 0x18, 0xbd, 0x0d, 0xb2, 0x7d, 0x3a, 0x32, 0xb6, 0x4a, 0xad, 0xc2, 0x5e, 0xd7, 0xb4,
	0x78, 0x9d, 0x75, 0x38, 0x18, 0x8f, 0x1e, 0xe0, 0x4e, 0xd7, 0x90, 0x4b, 0xea, 0x2f, 0x12, 0xd4,
	0x0b, 0xed, 0xcd, 0xd7, 0x93, 0x12, 0x2f, 0x4b, 0x02, 0xb6, 0x10, 0x15, 0x56, 0xf1, 0x3a, 0x46,
	0x0a, 0x1c, 0xcc, 0x83, 0x28, 0x98, 0xbb, 0xa1, 0x18, 0xed, 0x2a, 0x5e, 0x85, 0x1b, 0x55, 0x94,
	0x77, 0xaa, 0x62, 0xef, 0x55, 0x55, 0x34, 0xa1, 0x5e, 0x98, 0x13, 0xf5, 0x4f, 0x09, 0x5a, 0x9b,
	0xdd, 0x8e, 0x3e, 0x80, 0xe6, 0x79, 0xc0, 0x66, 0x0e, 0x8d, 0x59, 0x40, 0x23, 0x37, 0xcc, 0xd7,
	0xd9, 0xe0, 0xe2, 0x30, 0xd7, 0xd0, 0x5d, 0xa8, 0x8b, 0x87, 0xf2, 0x39, 0x58, 0xae, 0x17, 0xb8,
	0x94, 0x77, 0xf1, 0x1d, 0x00, 0x8f, 0x1f, 0x2d, 0x34, 0x09, 0xd6, 0x8b, 0x2e, 0x28, 0x3c, 0x9f,
	0x92, 0x33, 0x92, 0x04, 0x2c, 0x58, 0x2f, 0xb7, 0xa0, 0x6c, 0x94, 0xbc, 0xbf, 0x55, 0xf2, 0x27,
	0x70, 0xbd, 0x58, 0x32, 0xf3, 0x66, 0x24, 0x55, 0x2a, 0xe2, 0x21, 0xb9, 0x50, 0xb1, 0xd0, 0xd5,
	0x5f, 0xcb, 0x70, 0xf3, 0xa5, 0x73, 0x87, 0xce, 0xe0, 0x2d, 0x2f, 0x74, 0xd3, 0x34, 0x78, 0x16,
	0x78, 0x2e, 0xaf, 0x2b, 0x55, 0xa4, 0xc3, 0xf2, 0x51, 0xeb, 0xb8, 0xff, 0x46, 0xf3, 0xac, 0xe9,
	0x1b, 0x50, 0xbc, 0xfd, 0x92, 0xff, 0xec, 0xc9, 0x97, 0x96, 0x56, 0x7e, 0x45, 0x69, 0xbf, 0x49,
	0xd0, 0xda, 0x7c, 0x19, 0xba, 0x03, 0xb7, 0xf5, 0x7e, 0xc7, 0xb2, 0xcc, 0x9e, 0xa9, 0x77, 0x6c,
	0x73, 0x38, 0xd8, 0x6a, 0xd3, 0x06, 0x54, 0x75, 0x6c, 0xda, 0xa6, 0xde, 0xe9, 0xcb, 0x12, 0x8f,
	0x2c, 0x43, 0x1f, 0x63, 0xd3, 0x3e, 0x95, 0x4b, 0xa8, 0x05, 0xd0, 0x35, 0x7a, 0xe6, 0xc0, 0xe4,
	0x3e, 0xb9, 0xcc, 0x07, 0xb6, 0x8b, 0x4d, 0x3e, 0xa5, 0x7b, 0x48, 0x86, 0x46, 0xcf, 0xe8, 0xd8,
	0x63, 0x6c, 0x38, 0xa3, 0x8e, 0xfe, 0x48, 0xde, 0xe7, 0x8a, 0x65, 0xe0, 0xc7, 0xa6, 0x9e, 0x2b,
	0x15, 0x3e, 0x02, 0xf6, 0x70, 0xd8, 0x97, 0x0f, 0xd0, 0x75, 0x68, 0x8e, 0x47, 0xdd, 0x8e, 0x6d,
	0x38, 0x78, 0xd8, 0xef, 0x8f, 0x47, 0x72, 0x95, 0xc3, 0x96, 0x92, 0x5c, 0x53, 0x3f, 0x82, 0xe6,
	0xc6, 0x65, 0xc4, 0x3b, 0x9f, 0x44, 0xee, 0x24, 0x24, 0xd3, 0xbc, 0xd9, 0x56, 0xa1, 0xfa, 0x97,
	0x04, 0xd5, 0xd5, 0x39, 0x84, 0x5e, 0xc0, 0xad, 0x30, 0x88, 0xb2, 0x0b, 0x87, 0x5c, 0x10, 0x4f,
	0x1c, 0x69, 0xc5, 0x2b, 0xf7, 0x35, 0xce, 0xf7, 0x15, 0x31, 0xbf, 0x68, 0x6f, 0x08, 0xea, 0xa6,
	0x88, 0x28, 0x28, 0xab, 0xc3, 0xfe, 0x5f, 0xaf, 0x2b, 0xbd, 0xd1, 0xeb, 0x6e, 0xe6, 0xdc, 0x4d,
	0x59, 0xfd, 0xbb, 0x04, 0xad, 0xad, 0x35, 0xdc, 0x05, 0x08, 0xa9, 0xe7, 0x86, 0xbc, 0x13, 0x66,
	0xa2, 0xc8, 0xda, 0xc3, 0x6b, 0xb8, 0x26, 0xb4, 0x91, 0xcb, 0x66, 0x08, 0x03, 0xf8, 0x5e, 0xea,
	0xd0, 0xc9, 0x73, 0xe2, 0xb1, 0x7c, 0x59, 0xf7, 0x76, 0xbe, 0x2f, 0xbd, 0x74, 0x28, 0x8c, 0x9c,
	0xe9, 0xaf, 0x02, 0x74, 0x0c, 0x37, 0xdd, 0x30, 0xa4, 0xe7, 0x64, 0xea, 0xa4, 0x99, 0xe7, 0x91,
	0x34, 0x75, 0x3c, 0xba, 0x3a, 0x79, 0xf6, 0xf1, 0x8d, 0x3c, 0x69, 0x2d, 0x73, 0x3a, 0x4f, 0xa1,
	0x29, 0xd4, 0x83, 0x88, 0x91, 0x24, 0x4e, 0x08, 0x23, 0x89, 0xb8, 0xff, 0x5b, 0xc7, 0x27, 0x57,
	0xdb, 0x1f, 0xcd, 0xbc, 0x24, 0xe1, 0x22, 0x56, 0x35, 0xa0, 0x5e, 0xc8, 0xa1, 0xf7, 0xe0, 0x1d,
	0x73, 0x60, 0x1b, 0x78, 0x84, 0x0d, 0xdb, 0xc0, 0x5b, 0x8d, 0x5e, 0x83, 0x7d, 0xeb, 0xa1, 0xd1,
	0xe7, 0x5d, 0xde, 0x02, 0x18, 0x0d, 0x9f, 0x18, 0x78, 0x19, 0x97, 0x4e, 0x1a, 0x00, 0xfc, 0x1f,
	0xcd, 0x18, 0x6f, 0x31, 0x75, 0x06, 0xb5, 0xf5, 0x46, 0xa0, 0x5b, 0x50, 0x99, 0x64, 0xde, 0x0b,
	0xc2, 0x96, 0x9b, 0x8d, 0xf3, 0x88, 0xeb, 0x85, 0x3d, 0xae, 0xe1, 0x3c, 0xe2, 0xe3, 0xea, 0x93,
	0x88, 0x24, 0x62, 0xf8, 0x9c, 0x28, 0x9b, 0x4f, 0x48, 0x22, 0x3e, 0xa2, 0xca, 0x58, 0xbe, 0x4c,
	0x0c, 0x84, 0x7e, 0xf2, 0xb3, 0x04, 0x1f, 0x7b, 0x74, 0xbe, 0xe3, 0xae, 0x9c, 0xd4, 0xc4, 0x98,
	0x7f, 0x47, 0x27, 0xe9, 0x53, 0x2b, 0xb7, 0xf8, 0x34, 0x74, 0x23, 0x5f, 0xa3, 0x89, 0xdf, 0xf6,
	0x49, 0x24, 0x3e, 0x5b, 0xdb, 0xcb, 0x94, 0x1b, 0x07, 0xe9, 0xff, 0x7d, 0xf2, 0x7e, 0xbd, 0x21,
	0x4c, 0x2a, 0xc2, 0x7f, 0xff, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x6b, 0x40, 0xf6, 0x08, 0x31,
	0x0b, 0x00, 0x00,
}
