//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SQLPoolBlobAuditingPoliciesServer is a fake server for instances of the armsynapse.SQLPoolBlobAuditingPoliciesClient type.
type SQLPoolBlobAuditingPoliciesServer struct {
	// CreateOrUpdate is the fake for method SQLPoolBlobAuditingPoliciesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, parameters armsynapse.SQLPoolBlobAuditingPolicy, options *armsynapse.SQLPoolBlobAuditingPoliciesClientCreateOrUpdateOptions) (resp azfake.Responder[armsynapse.SQLPoolBlobAuditingPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SQLPoolBlobAuditingPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, options *armsynapse.SQLPoolBlobAuditingPoliciesClientGetOptions) (resp azfake.Responder[armsynapse.SQLPoolBlobAuditingPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySQLPoolPager is the fake for method SQLPoolBlobAuditingPoliciesClient.NewListBySQLPoolPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySQLPoolPager func(resourceGroupName string, workspaceName string, sqlPoolName string, options *armsynapse.SQLPoolBlobAuditingPoliciesClientListBySQLPoolOptions) (resp azfake.PagerResponder[armsynapse.SQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse])
}

// NewSQLPoolBlobAuditingPoliciesServerTransport creates a new instance of SQLPoolBlobAuditingPoliciesServerTransport with the provided implementation.
// The returned SQLPoolBlobAuditingPoliciesServerTransport instance is connected to an instance of armsynapse.SQLPoolBlobAuditingPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLPoolBlobAuditingPoliciesServerTransport(srv *SQLPoolBlobAuditingPoliciesServer) *SQLPoolBlobAuditingPoliciesServerTransport {
	return &SQLPoolBlobAuditingPoliciesServerTransport{
		srv:                   srv,
		newListBySQLPoolPager: newTracker[azfake.PagerResponder[armsynapse.SQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse]](),
	}
}

// SQLPoolBlobAuditingPoliciesServerTransport connects instances of armsynapse.SQLPoolBlobAuditingPoliciesClient to instances of SQLPoolBlobAuditingPoliciesServer.
// Don't use this type directly, use NewSQLPoolBlobAuditingPoliciesServerTransport instead.
type SQLPoolBlobAuditingPoliciesServerTransport struct {
	srv                   *SQLPoolBlobAuditingPoliciesServer
	newListBySQLPoolPager *tracker[azfake.PagerResponder[armsynapse.SQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse]]
}

// Do implements the policy.Transporter interface for SQLPoolBlobAuditingPoliciesServerTransport.
func (s *SQLPoolBlobAuditingPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLPoolBlobAuditingPoliciesClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SQLPoolBlobAuditingPoliciesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SQLPoolBlobAuditingPoliciesClient.NewListBySQLPoolPager":
		resp, err = s.dispatchNewListBySQLPoolPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLPoolBlobAuditingPoliciesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/auditingSettings/(?P<blobAuditingPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.SQLPoolBlobAuditingPolicy](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLPoolBlobAuditingPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLPoolBlobAuditingPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/auditingSettings/(?P<blobAuditingPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLPoolBlobAuditingPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLPoolBlobAuditingPoliciesServerTransport) dispatchNewListBySQLPoolPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySQLPoolPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySQLPoolPager not implemented")}
	}
	newListBySQLPoolPager := s.newListBySQLPoolPager.get(req)
	if newListBySQLPoolPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/auditingSettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListBySQLPoolPager(resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, nil)
		newListBySQLPoolPager = &resp
		s.newListBySQLPoolPager.add(req, newListBySQLPoolPager)
		server.PagerResponderInjectNextLinks(newListBySQLPoolPager, req, func(page *armsynapse.SQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySQLPoolPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySQLPoolPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySQLPoolPager) {
		s.newListBySQLPoolPager.remove(req)
	}
	return resp, nil
}
