//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armiotfirmwaredefense_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotfirmwaredefense/armiotfirmwaredefense"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListByWorkspace_MaximumSet_Gen.json
func ExampleFirmwareClient_NewListByWorkspacePager_firmwareListByWorkspaceMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListByWorkspacePager("rgworkspaces-firmwares", "A7", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirmwareList = armiotfirmwaredefense.FirmwareList{
		// 	Value: []*armiotfirmwaredefense.Firmware{
		// 		{
		// 			Name: to.Ptr("brmvnojpmxsgckdviynhxhftvcvbw"),
		// 			Type: to.Ptr("vlxhdbrphhnttmxvawwwewza"),
		// 			ID: to.Ptr("koexkheccwpzwqob"),
		// 			SystemData: &armiotfirmwaredefense.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
		// 				CreatedBy: to.Ptr("aylilpicryidesowemwnl"),
		// 				CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("bgtifu"),
		// 				LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
		// 			},
		// 			Properties: &armiotfirmwaredefense.FirmwareProperties{
		// 				Description: to.Ptr("uz"),
		// 				FileName: to.Ptr("wresexxulcdsdd"),
		// 				FileSize: to.Ptr[int64](17),
		// 				Model: to.Ptr("f"),
		// 				ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
		// 				Status: to.Ptr(armiotfirmwaredefense.StatusPending),
		// 				StatusMessages: []any{
		// 					map[string]any{
		// 						"message": "ulvhmhokezathzzauiitu",
		// 				}},
		// 				Vendor: to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
		// 				Version: to.Ptr("s"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListByWorkspace_MinimumSet_Gen.json
func ExampleFirmwareClient_NewListByWorkspacePager_firmwareListByWorkspaceMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListByWorkspacePager("rgworkspaces-firmwares", "A7", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirmwareList = armiotfirmwaredefense.FirmwareList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_Create_MaximumSet_Gen.json
func ExampleFirmwareClient_Create_firmwareCreateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().Create(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", armiotfirmwaredefense.Firmware{
		Properties: &armiotfirmwaredefense.FirmwareProperties{
			Description: to.Ptr("uz"),
			FileName:    to.Ptr("wresexxulcdsdd"),
			FileSize:    to.Ptr[int64](17),
			Model:       to.Ptr("f"),
			Status:      to.Ptr(armiotfirmwaredefense.StatusPending),
			StatusMessages: []any{
				map[string]any{
					"message": "ulvhmhokezathzzauiitu",
				}},
			Vendor:  to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
			Version: to.Ptr("s"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// 	Name: to.Ptr("brmvnojpmxsgckdviynhxhftvcvbw"),
	// 	Type: to.Ptr("vlxhdbrphhnttmxvawwwewza"),
	// 	ID: to.Ptr("koexkheccwpzwqob"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		CreatedBy: to.Ptr("aylilpicryidesowemwnl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("bgtifu"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Properties: &armiotfirmwaredefense.FirmwareProperties{
	// 		Description: to.Ptr("uz"),
	// 		FileName: to.Ptr("wresexxulcdsdd"),
	// 		FileSize: to.Ptr[int64](17),
	// 		Model: to.Ptr("f"),
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 		Status: to.Ptr(armiotfirmwaredefense.StatusPending),
	// 		StatusMessages: []any{
	// 			map[string]any{
	// 				"message": "ulvhmhokezathzzauiitu",
	// 		}},
	// 		Vendor: to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
	// 		Version: to.Ptr("s"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_Create_MinimumSet_Gen.json
func ExampleFirmwareClient_Create_firmwareCreateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().Create(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", armiotfirmwaredefense.Firmware{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_Update_MaximumSet_Gen.json
func ExampleFirmwareClient_Update_firmwareUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().Update(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", armiotfirmwaredefense.FirmwareUpdateDefinition{
		Properties: &armiotfirmwaredefense.FirmwareProperties{
			Description: to.Ptr("uz"),
			FileName:    to.Ptr("wresexxulcdsdd"),
			FileSize:    to.Ptr[int64](17),
			Model:       to.Ptr("f"),
			Status:      to.Ptr(armiotfirmwaredefense.StatusPending),
			StatusMessages: []any{
				map[string]any{
					"message": "ulvhmhokezathzzauiitu",
				}},
			Vendor:  to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
			Version: to.Ptr("s"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// 	Name: to.Ptr("brmvnojpmxsgckdviynhxhftvcvbw"),
	// 	Type: to.Ptr("vlxhdbrphhnttmxvawwwewza"),
	// 	ID: to.Ptr("koexkheccwpzwqob"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		CreatedBy: to.Ptr("aylilpicryidesowemwnl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("bgtifu"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Properties: &armiotfirmwaredefense.FirmwareProperties{
	// 		Description: to.Ptr("uz"),
	// 		FileName: to.Ptr("wresexxulcdsdd"),
	// 		FileSize: to.Ptr[int64](17),
	// 		Model: to.Ptr("f"),
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 		Status: to.Ptr(armiotfirmwaredefense.StatusPending),
	// 		StatusMessages: []any{
	// 			map[string]any{
	// 				"message": "ulvhmhokezathzzauiitu",
	// 		}},
	// 		Vendor: to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
	// 		Version: to.Ptr("s"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_Update_MinimumSet_Gen.json
func ExampleFirmwareClient_Update_firmwareUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().Update(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", armiotfirmwaredefense.FirmwareUpdateDefinition{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_Delete_MaximumSet_Gen.json
func ExampleFirmwareClient_Delete_firmwareDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewFirmwareClient().Delete(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_Delete_MinimumSet_Gen.json
func ExampleFirmwareClient_Delete_firmwareDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewFirmwareClient().Delete(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_Get_MaximumSet_Gen.json
func ExampleFirmwareClient_Get_firmwareGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().Get(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// 	Name: to.Ptr("brmvnojpmxsgckdviynhxhftvcvbw"),
	// 	Type: to.Ptr("vlxhdbrphhnttmxvawwwewza"),
	// 	ID: to.Ptr("koexkheccwpzwqob"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		CreatedBy: to.Ptr("aylilpicryidesowemwnl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("bgtifu"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Properties: &armiotfirmwaredefense.FirmwareProperties{
	// 		Description: to.Ptr("uz"),
	// 		FileName: to.Ptr("wresexxulcdsdd"),
	// 		FileSize: to.Ptr[int64](17),
	// 		Model: to.Ptr("f"),
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 		Status: to.Ptr(armiotfirmwaredefense.StatusPending),
	// 		StatusMessages: []any{
	// 			map[string]any{
	// 				"message": "ulvhmhokezathzzauiitu",
	// 		}},
	// 		Vendor: to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
	// 		Version: to.Ptr("s"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_Get_MinimumSet_Gen.json
func ExampleFirmwareClient_Get_firmwareGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().Get(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateDownloadUrl_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateDownloadURL_firmwareGenerateDownloadUrlMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateDownloadURL(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// 	UploadURL: to.Ptr("https://i/am/a/sas/token/too"),
	// 	URL: to.Ptr("https://i/am/a/sas/token"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateDownloadUrl_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateDownloadURL_firmwareGenerateDownloadUrlMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateDownloadURL(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateFilesystemDownloadUrl_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateFilesystemDownloadURL_firmwareGenerateFilesystemDownloadUrlMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateFilesystemDownloadURL(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// 	UploadURL: to.Ptr("https://i/am/a/sas/token/too"),
	// 	URL: to.Ptr("https://i/am/a/sas/token"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateFilesystemDownloadUrl_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateFilesystemDownloadURL_firmwareGenerateFilesystemDownloadUrlMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateFilesystemDownloadURL(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateSummary_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateSummary_firmwareGenerateSummaryMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateSummary(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirmwareSummary = armiotfirmwaredefense.FirmwareSummary{
	// 	AnalysisTimeSeconds: to.Ptr[int64](14),
	// 	BinaryCount: to.Ptr[int64](6),
	// 	ComponentCount: to.Ptr[int64](1),
	// 	ExtractedFileCount: to.Ptr[int64](17),
	// 	ExtractedSize: to.Ptr[int64](23),
	// 	FileSize: to.Ptr[int64](18),
	// 	RootFileSystems: to.Ptr[int64](9),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateSummary_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateSummary_firmwareGenerateSummaryMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateSummary(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirmwareSummary = armiotfirmwaredefense.FirmwareSummary{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateComponentList_MaximumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateComponentListPager_firmwareListGenerateComponentListMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateComponentListPager("rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ComponentList = armiotfirmwaredefense.ComponentList{
		// 	Value: []*armiotfirmwaredefense.Component{
		// 		{
		// 			ComponentID: to.Ptr("dwtwgmbjtftea"),
		// 			ComponentName: to.Ptr("wbjvfrmhmumeahdhkla"),
		// 			IsUpdateAvailable: to.Ptr(armiotfirmwaredefense.IsUpdateAvailableTrue),
		// 			License: to.Ptr("tirj"),
		// 			Paths: []*string{
		// 				to.Ptr("bjxczktgyhpatxkgwomhgfsw")},
		// 				ReleaseDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:30.304Z"); return t}()),
		// 				Version: to.Ptr("dmokuviyznjbdkfxbmvhlnglfnf"),
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateComponentList_MinimumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateComponentListPager_firmwareListGenerateComponentListMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateComponentListPager("rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ComponentList = armiotfirmwaredefense.ComponentList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateComponentDetails_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateComponentDetails_firmwareGenerateComponentDetailsMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateComponentDetails(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Component = armiotfirmwaredefense.Component{
	// 	ComponentID: to.Ptr("dwtwgmbjtftea"),
	// 	ComponentName: to.Ptr("wbjvfrmhmumeahdhkla"),
	// 	IsUpdateAvailable: to.Ptr(armiotfirmwaredefense.IsUpdateAvailableTrue),
	// 	License: to.Ptr("tirj"),
	// 	Paths: []*string{
	// 		to.Ptr("bjxczktgyhpatxkgwomhgfsw")},
	// 		ReleaseDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:30.304Z"); return t}()),
	// 		Version: to.Ptr("dmokuviyznjbdkfxbmvhlnglfnf"),
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateComponentDetails_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateComponentDetails_firmwareGenerateComponentDetailsMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateComponentDetails(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Component = armiotfirmwaredefense.Component{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateBinaryHardeningList_MaximumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateBinaryHardeningListPager_firmwareListGenerateBinaryHardeningListMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateBinaryHardeningListPager("rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.BinaryHardeningList = armiotfirmwaredefense.BinaryHardeningList{
		// 	Value: []*armiotfirmwaredefense.BinaryHardening{
		// 		{
		// 			Path: to.Ptr("ewqypeaihlnqdeesblp"),
		// 			Architecture: to.Ptr("rfqnzhnwitn"),
		// 			BinaryHardeningID: to.Ptr("paobczlmlkfeozykeeq"),
		// 			Class: to.Ptr("szvunaemnqnwqmfdx"),
		// 			Features: &armiotfirmwaredefense.BinaryHardeningFeatures{
		// 				Canary: to.Ptr(armiotfirmwaredefense.CanaryFlagTrue),
		// 				Nx: to.Ptr(armiotfirmwaredefense.NxFlagTrue),
		// 				Pie: to.Ptr(armiotfirmwaredefense.PieFlagTrue),
		// 				Relro: to.Ptr(armiotfirmwaredefense.RelroFlagTrue),
		// 				Stripped: to.Ptr(armiotfirmwaredefense.StrippedFlagTrue),
		// 			},
		// 			Rpath: to.Ptr("jigblxjxxqiskihigkmpqgrygxxx"),
		// 			Runpath: to.Ptr("aecstzybleqdwwhavfcywyo"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateBinaryHardeningList_MinimumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateBinaryHardeningListPager_firmwareListGenerateBinaryHardeningListMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateBinaryHardeningListPager("rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.BinaryHardeningList = armiotfirmwaredefense.BinaryHardeningList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateBinaryHardeningSummary_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateBinaryHardeningSummary_firmwareGenerateBinaryHardeningSummaryMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateBinaryHardeningSummary(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BinaryHardeningSummary = armiotfirmwaredefense.BinaryHardeningSummary{
	// 	Canary: to.Ptr[int32](28),
	// 	Nx: to.Ptr[int32](28),
	// 	Pie: to.Ptr[int32](19),
	// 	Relro: to.Ptr[int32](28),
	// 	Stripped: to.Ptr[int32](17),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateBinaryHardeningSummary_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateBinaryHardeningSummary_firmwareGenerateBinaryHardeningSummaryMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateBinaryHardeningSummary(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BinaryHardeningSummary = armiotfirmwaredefense.BinaryHardeningSummary{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateBinaryHardeningDetails_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateBinaryHardeningDetails_firmwareGenerateBinaryHardeningDetailsMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateBinaryHardeningDetails(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BinaryHardening = armiotfirmwaredefense.BinaryHardening{
	// 	Path: to.Ptr("ewqypeaihlnqdeesblp"),
	// 	Architecture: to.Ptr("rfqnzhnwitn"),
	// 	BinaryHardeningID: to.Ptr("paobczlmlkfeozykeeq"),
	// 	Class: to.Ptr("szvunaemnqnwqmfdx"),
	// 	Features: &armiotfirmwaredefense.BinaryHardeningFeatures{
	// 		Canary: to.Ptr(armiotfirmwaredefense.CanaryFlagTrue),
	// 		Nx: to.Ptr(armiotfirmwaredefense.NxFlagTrue),
	// 		Pie: to.Ptr(armiotfirmwaredefense.PieFlagTrue),
	// 		Relro: to.Ptr(armiotfirmwaredefense.RelroFlagTrue),
	// 		Stripped: to.Ptr(armiotfirmwaredefense.StrippedFlagTrue),
	// 	},
	// 	Rpath: to.Ptr("jigblxjxxqiskihigkmpqgrygxxx"),
	// 	Runpath: to.Ptr("aecstzybleqdwwhavfcywyo"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateBinaryHardeningDetails_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateBinaryHardeningDetails_firmwareGenerateBinaryHardeningDetailsMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateBinaryHardeningDetails(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BinaryHardening = armiotfirmwaredefense.BinaryHardening{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGeneratePasswordHashList_MaximumSet_Gen.json
func ExampleFirmwareClient_NewListGeneratePasswordHashListPager_firmwareListGeneratePasswordHashListMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGeneratePasswordHashListPager("rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PasswordHashList = armiotfirmwaredefense.PasswordHashList{
		// 	Value: []*armiotfirmwaredefense.PasswordHash{
		// 		{
		// 			Algorithm: to.Ptr("mzvaikhxwjbzddplm"),
		// 			Context: to.Ptr("gjeeqjzcrnbxiojt"),
		// 			FilePath: to.Ptr("xxtrysuheflpailcqzqbvytnsi"),
		// 			Hash: to.Ptr("ntksbuckwsaxdzlstqwenms"),
		// 			PasswordHashID: to.Ptr("twelvrhxk"),
		// 			Salt: to.Ptr("pdlihxaabeaxllsfdthctdcmltyhja"),
		// 			Username: to.Ptr("qvfpcvewrzdosvl"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGeneratePasswordHashList_MinimumSet_Gen.json
func ExampleFirmwareClient_NewListGeneratePasswordHashListPager_firmwareListGeneratePasswordHashListMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGeneratePasswordHashListPager("rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PasswordHashList = armiotfirmwaredefense.PasswordHashList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateCveList_MaximumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateCveListPager_firmwareListGenerateCveListMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateCveListPager("rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CveList = armiotfirmwaredefense.CveList{
		// 	Value: []*armiotfirmwaredefense.Cve{
		// 		{
		// 			Name: to.Ptr("x"),
		// 			Description: to.Ptr("jr"),
		// 			Component: map[string]any{
		// 			},
		// 			CveID: to.Ptr("bcmdkqlpeohuweqapzghpxxigubbnv"),
		// 			CvssScore: to.Ptr("kc"),
		// 			CvssV2Score: to.Ptr("qdzatwwrfqs"),
		// 			CvssV3Score: to.Ptr("hltdeqtpizrlxquimvbahazbluzy"),
		// 			CvssVersion: to.Ptr("wlacx"),
		// 			Links: []*armiotfirmwaredefense.CveLink{
		// 				{
		// 					Href: to.Ptr("dioeprjnkzyk"),
		// 					Label: to.Ptr("oxeatanlztnthd"),
		// 			}},
		// 			PublishDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:31.081Z"); return t}()),
		// 			Severity: to.Ptr("vwsqmwqxsdvszzdsfhtjep"),
		// 			UpdatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:31.081Z"); return t}()),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateCveList_MinimumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateCveListPager_firmwareListGenerateCveListMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateCveListPager("rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CveList = armiotfirmwaredefense.CveList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateCveSummary_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateCveSummary_firmwareGenerateCveSummaryMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateCveSummary(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CveSummary = armiotfirmwaredefense.CveSummary{
	// 	Critical: to.Ptr[int64](29),
	// 	High: to.Ptr[int64](10),
	// 	Low: to.Ptr[int64](27),
	// 	Medium: to.Ptr[int64](18),
	// 	Undefined: to.Ptr[int64](22),
	// 	Unknown: to.Ptr[int64](2),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateCveSummary_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateCveSummary_firmwareGenerateCveSummaryMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateCveSummary(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CveSummary = armiotfirmwaredefense.CveSummary{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateCryptoCertificateSummary_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateCryptoCertificateSummary_firmwareGenerateCryptoCertificateSummaryMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateCryptoCertificateSummary(ctx, "FirmwareAnalysisRG", "default", "DECAFBAD-0000-0000-0000-BADBADBADBAD", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CryptoCertificateSummary = armiotfirmwaredefense.CryptoCertificateSummary{
	// 	Expired: to.Ptr[int64](3),
	// 	ExpiringSoon: to.Ptr[int64](1),
	// 	PairedKeys: to.Ptr[int64](2),
	// 	SelfSigned: to.Ptr[int64](3),
	// 	ShortKeySize: to.Ptr[int64](1),
	// 	TotalCertificates: to.Ptr[int64](5),
	// 	WeakSignature: to.Ptr[int64](1),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateCryptoCertificateSummary_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateCryptoCertificateSummary_firmwareGenerateCryptoCertificateSummaryMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateCryptoCertificateSummary(ctx, "rgworkspaces-firmwares", "j5QE_", "wujtpcgypfpqseyrsebolarkspy", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CryptoCertificateSummary = armiotfirmwaredefense.CryptoCertificateSummary{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateCryptoKeySummary_MaximumSet_Gen.json
func ExampleFirmwareClient_GenerateCryptoKeySummary_firmwareGenerateCryptoKeySummaryMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateCryptoKeySummary(ctx, "FirmwareAnalysisRG", "default", "DECAFBAD-0000-0000-0000-BADBADBADBAD", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CryptoKeySummary = armiotfirmwaredefense.CryptoKeySummary{
	// 	PairedKeys: to.Ptr[int64](3),
	// 	PrivateKeys: to.Ptr[int64](3),
	// 	PublicKeys: to.Ptr[int64](3),
	// 	ShortKeySize: to.Ptr[int64](2),
	// 	TotalKeys: to.Ptr[int64](6),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_GenerateCryptoKeySummary_MinimumSet_Gen.json
func ExampleFirmwareClient_GenerateCryptoKeySummary_firmwareGenerateCryptoKeySummaryMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwareClient().GenerateCryptoKeySummary(ctx, "rgworkspaces-firmwares", "j5QE_", "wujtpcgypfpqseyrsebolarkspy", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CryptoKeySummary = armiotfirmwaredefense.CryptoKeySummary{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateCryptoCertificateList_MaximumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateCryptoCertificateListPager_firmwareListGenerateCryptoCertificateListMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateCryptoCertificateListPager("FirmwareAnalysisRG", "default", "DECAFBAD-0000-0000-0000-BADBADBADBAD", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CryptoCertificateList = armiotfirmwaredefense.CryptoCertificateList{
		// 	Value: []*armiotfirmwaredefense.CryptoCertificate{
		// 		{
		// 			Name: to.Ptr("VeriSign Class 3"),
		// 			CryptoCertID: to.Ptr("fafcad44-1770-41f3-998e-875fa688c143"),
		// 			Encoding: to.Ptr("PEM"),
		// 			ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-02-12T20:50:16.753Z"); return t}()),
		// 			FilePaths: []*string{
		// 				to.Ptr("this/is/a/path"),
		// 				to.Ptr("/this/is/another/path")},
		// 				Fingerprint: to.Ptr("eb:04:cf:5e:b1:f3:9a:fa:76:2f:2b:b1:20:f2:96:cb:a5:20:c1:b9:7d:b1:58:95:65:b8:1c:b9:a1:7b:72:44"),
		// 				IsExpired: to.Ptr(armiotfirmwaredefense.IsExpiredTrue),
		// 				IsSelfSigned: to.Ptr(armiotfirmwaredefense.IsSelfSignedFalse),
		// 				IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeTrue),
		// 				IsWeakSignature: to.Ptr(armiotfirmwaredefense.IsWeakSignatureTrue),
		// 				IssuedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2010-02-12T20:50:16.753Z"); return t}()),
		// 				Issuer: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 					CommonName: to.Ptr("VeriSign Class 3"),
		// 					Country: to.Ptr("United States"),
		// 					Organization: to.Ptr("Verisign, Inc."),
		// 					OrganizationalUnit: to.Ptr("(c) 1999 Verisign inc."),
		// 					State: to.Ptr("NY"),
		// 				},
		// 				KeyAlgorithm: to.Ptr("RSA Encryption"),
		// 				KeySize: to.Ptr[int64](1024),
		// 				PairedKey: &armiotfirmwaredefense.PairedKey{
		// 					Type: to.Ptr("Private Key"),
		// 					AdditionalProperties: map[string]any{
		// 						"displayName": "keyfilename.cer",
		// 					},
		// 					ID: to.Ptr("fafcad44-1770-41f3-998e-875fa688c143"),
		// 				},
		// 				Role: to.Ptr("Root CA"),
		// 				SerialNumber: to.Ptr("206684696279472310254277870180966723415"),
		// 				SignatureAlgorithm: to.Ptr("MD5 with RSA Encryption"),
		// 				Subject: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 					CommonName: to.Ptr("VeriSign Class 3"),
		// 					Country: to.Ptr("United States"),
		// 					Organization: to.Ptr("Verisign, Inc."),
		// 					OrganizationalUnit: to.Ptr("(c) 1999 Verisign inc."),
		// 					State: to.Ptr("NY"),
		// 				},
		// 				Usage: []*string{
		// 					to.Ptr("Crypt"),
		// 					to.Ptr("sign"),
		// 					to.Ptr("auth")},
		// 				},
		// 				{
		// 					Name: to.Ptr("VeriSign Class 2"),
		// 					CryptoCertID: to.Ptr("dfc4a7e4-2037-482a-bdf8-81289335337e"),
		// 					Encoding: to.Ptr("PEM"),
		// 					ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1999-12-31T15:59:59.999Z"); return t}()),
		// 					FilePaths: []*string{
		// 						to.Ptr("this/is/a/path"),
		// 						to.Ptr("/this/is/another/path")},
		// 						Fingerprint: to.Ptr("eb:04:cf:5e:b1:f3:9a:fa:76:2f:2b:b1:20:f2:96:cb:a5:20:c1:b9:7d:b1:58:95:65:b8:1c:b9:a1:7b:72:44"),
		// 						IsExpired: to.Ptr(armiotfirmwaredefense.IsExpiredTrue),
		// 						IsSelfSigned: to.Ptr(armiotfirmwaredefense.IsSelfSignedFalse),
		// 						IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeFalse),
		// 						IsWeakSignature: to.Ptr(armiotfirmwaredefense.IsWeakSignatureFalse),
		// 						IssuedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1970-01-01T00:00:00.000Z"); return t}()),
		// 						Issuer: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 							CommonName: to.Ptr("VeriSign Class 3"),
		// 							Country: to.Ptr("United States"),
		// 							Organization: to.Ptr("Verisign, Inc."),
		// 							OrganizationalUnit: to.Ptr("(c) 1999 Verisign inc."),
		// 							State: to.Ptr("NY"),
		// 						},
		// 						KeyAlgorithm: to.Ptr("RSA Encryption"),
		// 						KeySize: to.Ptr[int64](2048),
		// 						PairedKey: &armiotfirmwaredefense.PairedKey{
		// 							Type: to.Ptr("Private Key"),
		// 							ID: to.Ptr("fafcad44-1770-41f3-998e-875fa688c143"),
		// 						},
		// 						Role: to.Ptr("Intermediate CA"),
		// 						SerialNumber: to.Ptr("206684696279472310254277870180966723415"),
		// 						SignatureAlgorithm: to.Ptr("SHA-1 with RSA Encryption"),
		// 						Subject: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 							CommonName: to.Ptr("VeriSign Class 3"),
		// 							Country: to.Ptr("United States"),
		// 							Organization: to.Ptr("Verisign, Inc."),
		// 							OrganizationalUnit: to.Ptr("(c) 1999 Verisign inc."),
		// 							State: to.Ptr("NY"),
		// 						},
		// 						Usage: []*string{
		// 							to.Ptr("Crypt"),
		// 							to.Ptr("sign"),
		// 							to.Ptr("auth")},
		// 						},
		// 						{
		// 							Name: to.Ptr("JillianSign Class 1"),
		// 							CryptoCertID: to.Ptr("55d8329d-6f4b-4a36-a6a7-53f2ddf187b5"),
		// 							Encoding: to.Ptr("PEM"),
		// 							ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-16T20:50:16.753Z"); return t}()),
		// 							FilePaths: []*string{
		// 								to.Ptr("this/is/a/path/made/by/Jillian"),
		// 								to.Ptr("/this/is/another/path")},
		// 								Fingerprint: to.Ptr("eb:04:cf:5e:b1:f3:9a:fa:76:2f:2b:b1:20:f2:96:cb:a5:20:c1:b9:7d:b1:58:95:65:b8:1c:b9:a1:7b:72:44"),
		// 								IsExpired: to.Ptr(armiotfirmwaredefense.IsExpiredTrue),
		// 								IsSelfSigned: to.Ptr(armiotfirmwaredefense.IsSelfSignedTrue),
		// 								IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeFalse),
		// 								IsWeakSignature: to.Ptr(armiotfirmwaredefense.IsWeakSignatureFalse),
		// 								IssuedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-16T20:50:16.753Z"); return t}()),
		// 								Issuer: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 									CommonName: to.Ptr("VeriSign Class 3"),
		// 									Country: to.Ptr("United States"),
		// 									Organization: to.Ptr("Verisign, Inc."),
		// 									OrganizationalUnit: to.Ptr("(c) 1999 Verisign inc."),
		// 									State: to.Ptr("NY"),
		// 								},
		// 								KeyAlgorithm: to.Ptr("RSA Encryption"),
		// 								KeySize: to.Ptr[int64](2048),
		// 								Role: to.Ptr("Standard"),
		// 								SerialNumber: to.Ptr("206684696279472310254277870180966723415"),
		// 								SignatureAlgorithm: to.Ptr("SHA-1 with RSA Encryption"),
		// 								Subject: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 									CommonName: to.Ptr("JillianSign Class 1"),
		// 									Country: to.Ptr("United States"),
		// 									Organization: to.Ptr("Jilliansign, Inc."),
		// 									OrganizationalUnit: to.Ptr("(c) 2007 Jilliansign inc."),
		// 									State: to.Ptr("MA"),
		// 								},
		// 								Usage: []*string{
		// 									to.Ptr("Crypt"),
		// 									to.Ptr("sign"),
		// 									to.Ptr("auth")},
		// 								},
		// 								{
		// 									Name: to.Ptr("MikeSign Class 5"),
		// 									CryptoCertID: to.Ptr("c9c1466a-bef5-4883-872e-bc59375f5d89"),
		// 									Encoding: to.Ptr("PEM"),
		// 									ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-16T20:50:16.753Z"); return t}()),
		// 									FilePaths: []*string{
		// 										to.Ptr("this/is/a/path/by/Mike/but/isExpired/and/could/get/pretty/long"),
		// 										to.Ptr("/this/is/another/path")},
		// 										Fingerprint: to.Ptr("eb:04:cf:5e:b1:f3:9a:fa:76:2f:2b:b1:20:f2:96:cb:a5:20:c1:b9:7d:b1:58:95:65:b8:1c:b9:a1:7b:72:44"),
		// 										IsExpired: to.Ptr(armiotfirmwaredefense.IsExpiredFalse),
		// 										IsSelfSigned: to.Ptr(armiotfirmwaredefense.IsSelfSignedTrue),
		// 										IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeFalse),
		// 										IsWeakSignature: to.Ptr(armiotfirmwaredefense.IsWeakSignatureFalse),
		// 										IssuedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-16T20:50:16.753Z"); return t}()),
		// 										Issuer: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 											CommonName: to.Ptr("VeriSign Class 3"),
		// 											Country: to.Ptr("United States"),
		// 											Organization: to.Ptr("Verisign, Inc."),
		// 											OrganizationalUnit: to.Ptr("(c) 1999 Verisign inc."),
		// 											State: to.Ptr("NY"),
		// 										},
		// 										KeyAlgorithm: to.Ptr("RSA Encryption"),
		// 										KeySize: to.Ptr[int64](2048),
		// 										Role: to.Ptr("Root CA"),
		// 										SerialNumber: to.Ptr("206684696279472310254277870180966723415"),
		// 										SignatureAlgorithm: to.Ptr("SHA-1 with RSA Encryption"),
		// 										Subject: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 											CommonName: to.Ptr("MikeSign Class 5"),
		// 											Country: to.Ptr("United States"),
		// 											Organization: to.Ptr("Mikesign, Inc."),
		// 											OrganizationalUnit: to.Ptr("(c) 2021 Mikesign inc."),
		// 											State: to.Ptr("MD"),
		// 										},
		// 										Usage: []*string{
		// 											to.Ptr("Crypt"),
		// 											to.Ptr("sign"),
		// 											to.Ptr("auth")},
		// 										},
		// 										{
		// 											Name: to.Ptr("PeterSign Class 1000"),
		// 											CryptoCertID: to.Ptr("0b580a77-228b-4786-b623-518ec8cdd564"),
		// 											Encoding: to.Ptr("PEM"),
		// 											ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2030-03-16T20:50:16.753Z"); return t}()),
		// 											FilePaths: []*string{
		// 												to.Ptr("this/is/a/path/for/Peters/puzzlers"),
		// 												to.Ptr("/this/is/another/path")},
		// 												Fingerprint: to.Ptr("eb:04:cf:5e:b1:f3:9a:fa:76:2f:2b:b1:20:f2:96:cb:a5:20:c1:b9:7d:b1:58:95:65:b8:1c:b9:a1:7b:72:44"),
		// 												IsExpired: to.Ptr(armiotfirmwaredefense.IsExpiredFalse),
		// 												IsSelfSigned: to.Ptr(armiotfirmwaredefense.IsSelfSignedTrue),
		// 												IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeFalse),
		// 												IsWeakSignature: to.Ptr(armiotfirmwaredefense.IsWeakSignatureFalse),
		// 												IssuedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-16T20:50:16.753Z"); return t}()),
		// 												Issuer: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 													CommonName: to.Ptr("VeriSign Class 3"),
		// 													Country: to.Ptr("United States"),
		// 													Organization: to.Ptr("Verisign, Inc."),
		// 													OrganizationalUnit: to.Ptr("(c) 1999 Verisign inc."),
		// 													State: to.Ptr("NY"),
		// 												},
		// 												KeyAlgorithm: to.Ptr("RSA Encryption"),
		// 												KeySize: to.Ptr[int64](2048),
		// 												Role: to.Ptr("Standard"),
		// 												SerialNumber: to.Ptr("206684696279472310254277870180966723415"),
		// 												SignatureAlgorithm: to.Ptr("SHA-1 with RSA Encryption"),
		// 												Subject: &armiotfirmwaredefense.CryptoCertificateEntity{
		// 													CommonName: to.Ptr("PeterSign Class 1000"),
		// 													Country: to.Ptr("United States"),
		// 													Organization: to.Ptr("Petersign, Inc."),
		// 													OrganizationalUnit: to.Ptr("(c) 1999 Petersign inc."),
		// 													State: to.Ptr("MD"),
		// 												},
		// 												Usage: []*string{
		// 													to.Ptr("Crypt"),
		// 													to.Ptr("sign"),
		// 													to.Ptr("auth")},
		// 											}},
		// 										}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateCryptoCertificateList_MinimumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateCryptoCertificateListPager_firmwareListGenerateCryptoCertificateListMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateCryptoCertificateListPager("rgworkspaces-firmwares", "j5QE_", "wujtpcgypfpqseyrsebolarkspy", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CryptoCertificateList = armiotfirmwaredefense.CryptoCertificateList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateCryptoKeyList_MaximumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateCryptoKeyListPager_firmwareListGenerateCryptoKeyListMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateCryptoKeyListPager("FirmwareAnalysisRG", "default", "DECAFBAD-0000-0000-0000-BADBADBADBAD", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CryptoKeyList = armiotfirmwaredefense.CryptoKeyList{
		// 	Value: []*armiotfirmwaredefense.CryptoKey{
		// 		{
		// 			CryptoKeyID: to.Ptr("09c97cb7-0963-41ad-b9e2-0be7b10ac1bf"),
		// 			FilePaths: []*string{
		// 				to.Ptr("this/is/a/file/path"),
		// 				to.Ptr("this/is/another/file/path")},
		// 				IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeFalse),
		// 				KeyAlgorithm: to.Ptr("ECDSA"),
		// 				KeySize: to.Ptr[int64](256),
		// 				KeyType: to.Ptr("Public"),
		// 				PairedKey: &armiotfirmwaredefense.PairedKey{
		// 					Type: to.Ptr("Certificate"),
		// 					AdditionalProperties: map[string]any{
		// 						"displayName": "VeriSign Class 2",
		// 					},
		// 					ID: to.Ptr("09c97cb7-0963-41ad-b9e2-0be7b10ac1bf"),
		// 				},
		// 				Usage: []*string{
		// 				},
		// 			},
		// 			{
		// 				CryptoKeyID: to.Ptr("98ff3d6c-bb76-4037-b73e-89b3b47efd71"),
		// 				FilePaths: []*string{
		// 					to.Ptr("this/is/a/file/path_pub.pem")},
		// 					IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeFalse),
		// 					KeyAlgorithm: to.Ptr("RSA"),
		// 					KeySize: to.Ptr[int64](2048),
		// 					KeyType: to.Ptr("Public"),
		// 					PairedKey: &armiotfirmwaredefense.PairedKey{
		// 						Type: to.Ptr("Private Key"),
		// 						ID: to.Ptr("adfe0c4c-7d23-4f4f-a8bb-e65b8f455287"),
		// 					},
		// 					Usage: []*string{
		// 						to.Ptr("SSH")},
		// 					},
		// 					{
		// 						CryptoKeyID: to.Ptr("1beb6fac-1cfe-431c-9437-ea8cfa9e6aaa"),
		// 						FilePaths: []*string{
		// 						},
		// 						IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeTrue),
		// 						KeyAlgorithm: to.Ptr("ECDSA"),
		// 						KeySize: to.Ptr[int64](128),
		// 						KeyType: to.Ptr("Public"),
		// 						Usage: []*string{
		// 						},
		// 					},
		// 					{
		// 						CryptoKeyID: to.Ptr("adfe0c4c-7d23-4f4f-a8bb-e65b8f455287"),
		// 						FilePaths: []*string{
		// 							to.Ptr("this/is/a/file/path.pem")},
		// 							IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeFalse),
		// 							KeyAlgorithm: to.Ptr("RSA"),
		// 							KeySize: to.Ptr[int64](2048),
		// 							KeyType: to.Ptr("Private"),
		// 							PairedKey: &armiotfirmwaredefense.PairedKey{
		// 								Type: to.Ptr("Public Key"),
		// 								ID: to.Ptr("98ff3d6c-bb76-4037-b73e-89b3b47efd71"),
		// 							},
		// 							Usage: []*string{
		// 								to.Ptr("SSH")},
		// 							},
		// 							{
		// 								CryptoKeyID: to.Ptr("8c8d1003-efb2-4c54-83d6-16dc6a5bbfd5"),
		// 								FilePaths: []*string{
		// 								},
		// 								IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeTrue),
		// 								KeyAlgorithm: to.Ptr("RSA"),
		// 								KeySize: to.Ptr[int64](1024),
		// 								KeyType: to.Ptr("Private"),
		// 								Usage: []*string{
		// 								},
		// 							},
		// 							{
		// 								CryptoKeyID: to.Ptr("0b04fc4c-bfbd-491b-b4c8-e93b0b0b28e9"),
		// 								FilePaths: []*string{
		// 									to.Ptr("this/is/a/file/path"),
		// 									to.Ptr("this/is/another/file/path")},
		// 									IsShortKeySize: to.Ptr(armiotfirmwaredefense.IsShortKeySizeFalse),
		// 									KeyAlgorithm: to.Ptr("MD5"),
		// 									KeySize: to.Ptr[int64](256),
		// 									KeyType: to.Ptr("Private"),
		// 									Usage: []*string{
		// 									},
		// 							}},
		// 						}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/preview/2023-02-08-preview/examples/Firmware_ListGenerateCryptoKeyList_MinimumSet_Gen.json
func ExampleFirmwareClient_NewListGenerateCryptoKeyListPager_firmwareListGenerateCryptoKeyListMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwareClient().NewListGenerateCryptoKeyListPager("rgworkspaces-firmwares", "j5QE_", "wujtpcgypfpqseyrsebolarkspy", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CryptoKeyList = armiotfirmwaredefense.CryptoKeyList{
		// }
	}
}
