// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An action defines the tasks that the extension performs during the AppConfig
// workflow. Each action includes an action point such as
// ON_CREATE_HOSTED_CONFIGURATION , PRE_DEPLOYMENT , or ON_DEPLOYMENT . Each action
// also includes a name, a URI to an Lambda function, and an Amazon Resource Name
// (ARN) for an Identity and Access Management assume role. You specify the name,
// URI, and ARN for each action point defined in the extension. You can specify the
// following actions for an extension:
//   - PRE_CREATE_HOSTED_CONFIGURATION_VERSION
//   - PRE_START_DEPLOYMENT
//   - ON_DEPLOYMENT_START
//   - ON_DEPLOYMENT_STEP
//   - ON_DEPLOYMENT_BAKING
//   - ON_DEPLOYMENT_COMPLETE
//   - ON_DEPLOYMENT_ROLLED_BACK
type Action struct {

	// Information about the action.
	Description *string

	// The action name.
	Name *string

	// An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
	RoleArn *string

	// The extension URI associated to the action point in the extension definition.
	// The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda
	// function, an Amazon Simple Queue Service queue, an Amazon Simple Notification
	// Service topic, or the Amazon EventBridge default event bus.
	Uri *string

	noSmithyDocumentSerde
}

// An extension that was invoked as part of a deployment event.
type ActionInvocation struct {

	// The name of the action.
	ActionName *string

	// The error code when an extension invocation fails.
	ErrorCode *string

	// The error message when an extension invocation fails.
	ErrorMessage *string

	// The name, the ID, or the Amazon Resource Name (ARN) of the extension.
	ExtensionIdentifier *string

	// A system-generated ID for this invocation.
	InvocationId *string

	// An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
	RoleArn *string

	// The extension URI associated to the action point in the extension definition.
	// The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda
	// function, an Amazon Simple Queue Service queue, an Amazon Simple Notification
	// Service topic, or the Amazon EventBridge default event bus.
	Uri *string

	noSmithyDocumentSerde
}

type Application struct {

	// The description of the application.
	Description *string

	// The application ID.
	Id *string

	// The application name.
	Name *string

	noSmithyDocumentSerde
}

// An extension that was invoked during a deployment.
type AppliedExtension struct {

	// The system-generated ID for the association.
	ExtensionAssociationId *string

	// The system-generated ID of the extension.
	ExtensionId *string

	// One or more parameters for the actions called by the extension.
	Parameters map[string]string

	// The extension version number.
	VersionNumber int32

	noSmithyDocumentSerde
}

// Detailed information about the input that failed to satisfy the constraints
// specified by a call.
//
// The following types satisfy this interface:
//
//	BadRequestDetailsMemberInvalidConfiguration
type BadRequestDetails interface {
	isBadRequestDetails()
}

// Detailed information about the bad request exception error when creating a
// hosted configuration version.
type BadRequestDetailsMemberInvalidConfiguration struct {
	Value []InvalidConfigurationDetail

	noSmithyDocumentSerde
}

func (*BadRequestDetailsMemberInvalidConfiguration) isBadRequestDetails() {}

// A summary of a configuration profile.
type ConfigurationProfileSummary struct {

	// The application ID.
	ApplicationId *string

	// The ID of the configuration profile.
	Id *string

	// The URI location of the configuration.
	LocationUri *string

	// The name of the configuration profile.
	Name *string

	// The type of configurations contained in the profile. AppConfig supports feature
	// flags and freeform configurations. We recommend you create feature flag
	// configurations to enable or disable new features and freeform configurations to
	// distribute configurations to an application. When calling this API, enter one of
	// the following values for Type : AWS.AppConfig.FeatureFlags
	//     AWS.Freeform
	Type *string

	// The types of validators in the configuration profile.
	ValidatorTypes []ValidatorType

	noSmithyDocumentSerde
}

// An object that describes a deployment event.
type DeploymentEvent struct {

	// The list of extensions that were invoked as part of the deployment.
	ActionInvocations []ActionInvocation

	// A description of the deployment event. Descriptions include, but are not
	// limited to, the following:
	//   - The Amazon Web Services account or the Amazon CloudWatch alarm ARN that
	//   initiated a rollback.
	//   - The percentage of hosts that received the deployment.
	//   - A recommendation to attempt a new deployment (in the case of an internal
	//   error).
	Description *string

	// The type of deployment event. Deployment event types include the start, stop,
	// or completion of a deployment; a percentage update; the start or stop of a bake
	// period; and the start or completion of a rollback.
	EventType DeploymentEventType

	// The date and time the event occurred.
	OccurredAt *time.Time

	// The entity that triggered the deployment event. Events can be triggered by a
	// user, AppConfig, an Amazon CloudWatch alarm, or an internal error.
	TriggeredBy TriggeredBy

	noSmithyDocumentSerde
}

type DeploymentStrategy struct {

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes int32

	// The description of the deployment strategy.
	Description *string

	// The amount of time that AppConfig monitored for alarms before considering the
	// deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes int32

	// The percentage of targets that received a deployed configuration during each
	// interval.
	GrowthFactor *float32

	// The algorithm used to define how percentage grew over time.
	GrowthType GrowthType

	// The deployment strategy ID.
	Id *string

	// The name of the deployment strategy.
	Name *string

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo ReplicateTo

	noSmithyDocumentSerde
}

// Information about the deployment.
type DeploymentSummary struct {

	// Time the deployment completed.
	CompletedAt *time.Time

	// The name of the configuration.
	ConfigurationName *string

	// The version of the configuration.
	ConfigurationVersion *string

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes int32

	// The sequence number of the deployment.
	DeploymentNumber int32

	// The amount of time that AppConfig monitors for alarms before considering the
	// deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes int32

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	GrowthFactor *float32

	// The algorithm used to define how percentage grows over time.
	GrowthType GrowthType

	// The percentage of targets for which the deployment is available.
	PercentageComplete *float32

	// Time the deployment started.
	StartedAt *time.Time

	// The state of the deployment.
	State DeploymentState

	// A user-defined label for an AppConfig hosted configuration version.
	VersionLabel *string

	noSmithyDocumentSerde
}

type Environment struct {

	// The application ID.
	ApplicationId *string

	// The description of the environment.
	Description *string

	// The environment ID.
	Id *string

	// Amazon CloudWatch alarms monitored during the deployment.
	Monitors []Monitor

	// The name of the environment.
	Name *string

	// The state of the environment. An environment can be in one of the following
	// states: READY_FOR_DEPLOYMENT , DEPLOYING , ROLLING_BACK , or ROLLED_BACK
	State EnvironmentState

	noSmithyDocumentSerde
}

// Information about an association between an extension and an AppConfig resource
// such as an application, environment, or configuration profile. Call
// GetExtensionAssociation to get more information about an association.
type ExtensionAssociationSummary struct {

	// The system-generated Amazon Resource Name (ARN) for the extension.
	ExtensionArn *string

	// The extension association ID. This ID is used to call other ExtensionAssociation
	// API actions such as GetExtensionAssociation or DeleteExtensionAssociation .
	Id *string

	// The ARNs of applications, configuration profiles, or environments defined in
	// the association.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Information about an extension. Call GetExtension to get more information about
// an extension.
type ExtensionSummary struct {

	// The system-generated Amazon Resource Name (ARN) for the extension.
	Arn *string

	// Information about the extension.
	Description *string

	// The system-generated ID of the extension.
	Id *string

	// The extension name.
	Name *string

	// The extension version number.
	VersionNumber int32

	noSmithyDocumentSerde
}

// Information about the configuration.
type HostedConfigurationVersionSummary struct {

	// The application ID.
	ApplicationId *string

	// The configuration profile ID.
	ConfigurationProfileId *string

	// A standard MIME type describing the format of the configuration content. For
	// more information, see Content-Type (https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17)
	// .
	ContentType *string

	// A description of the configuration.
	Description *string

	// The Amazon Resource Name of the Key Management Service key that was used to
	// encrypt this specific version of the configuration data in the AppConfig hosted
	// configuration store.
	KmsKeyArn *string

	// A user-defined label for an AppConfig hosted configuration version.
	VersionLabel *string

	// The configuration version.
	VersionNumber int32

	noSmithyDocumentSerde
}

// Detailed information about the bad request exception error when creating a
// hosted configuration version.
type InvalidConfigurationDetail struct {

	// The invalid or out-of-range validation constraint in your JSON schema that
	// failed validation.
	Constraint *string

	// Location of the validation constraint in the configuration JSON schema that
	// failed validation.
	Location *string

	// The reason for an invalid configuration error.
	Reason *string

	// The type of error for an invalid configuration.
	Type *string

	// Details about an error with Lambda when a synchronous extension experiences an
	// error during an invocation.
	Value *string

	noSmithyDocumentSerde
}

// Amazon CloudWatch alarms to monitor during the deployment process.
type Monitor struct {

	// Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
	//
	// This member is required.
	AlarmArn *string

	// ARN of an Identity and Access Management (IAM) role for AppConfig to monitor
	// AlarmArn .
	AlarmRoleArn *string

	noSmithyDocumentSerde
}

// A value such as an Amazon Resource Name (ARN) or an Amazon Simple Notification
// Service topic entered in an extension when invoked. Parameter values are
// specified in an extension association. For more information about extensions,
// see Working with AppConfig extensions (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
type Parameter struct {

	// Information about the parameter.
	Description *string

	// A parameter value must be specified in the extension association.
	Required bool

	noSmithyDocumentSerde
}

// A validator provides a syntactic or semantic check to ensure the configuration
// that you want to deploy functions as intended. To validate your application
// configuration data, you provide a schema or an Amazon Web Services Lambda
// function that runs against the configuration. The configuration deployment or
// update can only proceed when the configuration data is valid.
type Validator struct {

	// Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda
	// function.
	//
	// This member is required.
	Content *string

	// AppConfig supports validators of type JSON_SCHEMA and LAMBDA
	//
	// This member is required.
	Type ValidatorType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isBadRequestDetails() {}
