// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"fmt"

	"code.forgejo.org/f3/gof3/v3/f3"
)

func NewMilestonePathString[T any](projectPath string, id T) string {
	return fmt.Sprintf("%s/milestones/%v", projectPath, id)
}

func NewMilestoneReference[T any](projectPath string, id T) *f3.Reference {
	return f3.NewReference(NewMilestonePathString(projectPath, id))
}

func NewIssueMilestoneReference[T any](id T) *f3.Reference {
	return f3.NewReference(NewMilestonePathString("../..", id))
}
