# FreeCol - Colonization Strategy Game

<!-- [![Coverity Scan Build Status](https://img.shields.io/coverity/scan/13524.svg)](https://scan.coverity.com/projects/freecol-freecol) -->
[![Weekly Downloads](https://img.shields.io/sourceforge/dw/freecol.svg)](https://sourceforge.net/projects/freecol/)
[![Total Downloads](https://img.shields.io/sourceforge/dt/freecol.svg)](https://sourceforge.net/projects/freecol/)


[![Latest Release](https://img.shields.io/github/release/FreeCol/freecol/all.svg)](https://github.com/FreeCol/freecol/releases) [![Latest Release Downloads](https://img.shields.io/github/downloads/FreeCol/freecol/total.svg)](https://github.com/FreeCol/freecol/releases)

FreeCol is a turn-based strategy game based on the old game
Colonization, and similar to Civilization. The objective of the game is
to create an independent nation.

You start with only a few colonists defying the stormy seas in their
search for new land. Will you guide them on the Colonization of a New
World?

## About FreeCol

**Website: [FreeCol.org](http://www.freecol.org/)**

The FreeCol team aims to create an Open Source version of Colonization
(released under the GPL). At first we'll try to make an exact clone of
Colonization. The visuals will be brought up to date with more recent
standards but will remain clean, simple and functional. Certain new
'features' will be implemented but the gameplay and the rules will be
exactly the same as the original game. Examples of modern features are:
an isometric map and multiplayer support.

This clone will be developed incrementally and result in FreeCol 1.0.0
which will be an almost exact Colonization clone. Incremental
development basically means that we'll add features one at a time. This
allows us to have a running program at all times and also to release an
unfinished but working game once in a while.

Once FreeCol 1.0.0 is finished we'll start working towards FreeCol
2.0.0. FreeCol 2 will go beyond the original Colonization and will have
many new features, it will be an implementation of our (and our users')
image of what Colonization 2 would have been.

## Downloads

#### Supports Mac OS X, Windows, and Linux

The latest binary releases are created weekly and contain Mac OS X, Windows, and Linux installers.

* See: [Weekly Releases](https://github.com/FreeCol/freecol/releases)

## Contributing

Ways you can contribute:

* Download the [latest nightly release](https://github.com/FreeCol/freecol/releases) and play the game.
* Report any bugs you find to our [Bug Tracker.](https://sourceforge.net/p/freecol/bugs/)
* Suggest features or improvements in our [Improvement Requests Tracker.](https://sourceforge.net/p/freecol/improvement-requests/)
* Discuss FreeCol on our [Forums.](https://sourceforge.net/p/freecol/discussion/)
* Contribute to our [code base](https://github.com/FreeCol/freecol) by Forking and submitting a Pull Request. See [Creating a pull request from a fork.](https://help.github.com/articles/creating-a-pull-request-from-a-fork/)

See [doc/developer.tex](doc/developer.tex) for more details on contributing to the FreeCol project.


## Building

Build the latest version of the code by running:

```sh
ant
```

Requires Java 11, Ant, and Java SDK to build.


## License

The source code is licensed under the GPL v2. Most of the content, like artwork, music and sound effects, are also licensed under GPL v2. Some of the content is licensed using CC BY 4.0. Please refer to the README file in the same directory as the included content for more details.

