/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.CigarArray;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Alignment
implements AlignmentI {
    protected Alignment dataset;
    protected Vector sequences;
    protected Vector groups = new Vector();
    protected char gapCharacter = (char)45;
    protected int type = 1;
    public static final int PROTEIN = 0;
    public static final int NUCLEOTIDE = 1;
    public AlignmentAnnotation[] annotations;
    HiddenSequences hiddenSequences = new HiddenSequences(this);
    public Hashtable alignmentProperties;
    int alignmentRefs = 0;
    AlignedCodonFrame[] codonFrameList = null;

    private void initAlignment(SequenceI[] seqs) {
        int i = 0;
        this.type = Comparison.isNucleotide(seqs) ? 1 : 0;
        this.sequences = new Vector();
        for (i = 0; i < seqs.length; ++i) {
            this.sequences.addElement(seqs[i]);
        }
    }

    public Alignment(SequenceI[] seqs) {
        this.initAlignment(seqs);
    }

    public Alignment(SeqCigar[] alseqs) {
        SequenceI[] seqs = SeqCigar.createAlignmentSequences(alseqs, this.gapCharacter, new ColumnSelection(), null);
        this.initAlignment(seqs);
    }

    public static AlignmentI createAlignment(CigarArray compactAlignment) {
        throw new Error("Alignment(CigarArray) not yet implemented");
    }

    public Vector getSequences() {
        return this.sequences;
    }

    public SequenceI[] getSequencesArray() {
        if (this.sequences == null) {
            return null;
        }
        SequenceI[] reply = new SequenceI[this.sequences.size()];
        for (int i = 0; i < this.sequences.size(); ++i) {
            reply[i] = (SequenceI)this.sequences.elementAt(i);
        }
        return reply;
    }

    public SequenceI getSequenceAt(int i) {
        if (i < this.sequences.size()) {
            return (SequenceI)this.sequences.elementAt(i);
        }
        return null;
    }

    public void addSequence(SequenceI snew) {
        if (this.dataset != null) {
            if (snew.getDatasetSequence() != null) {
                this.getDataset().addSequence(snew.getDatasetSequence());
            } else {
                SequenceI adding = snew.deriveSequence();
                this.getDataset().addSequence(adding.getDatasetSequence());
                snew = adding;
            }
        }
        if (this.sequences == null) {
            this.initAlignment(new SequenceI[]{snew});
        } else {
            this.sequences.addElement(snew);
        }
        if (this.hiddenSequences != null) {
            this.hiddenSequences.adjustHeightSequenceAdded();
        }
    }

    public void setSequenceAt(int i, SequenceI snew) {
        SequenceI oldseq = this.getSequenceAt(i);
        this.deleteSequence(oldseq);
        this.sequences.setElementAt(snew, i);
    }

    public Vector getGroups() {
        return this.groups;
    }

    public void finalize() {
        if (this.getDataset() != null) {
            this.getDataset().removeAlignmentRef();
        }
        this.dataset = null;
        this.sequences = null;
        this.groups = null;
        this.annotations = null;
        this.hiddenSequences = null;
    }

    private void removeAlignmentRef() {
        if (--this.alignmentRefs == 0) {
            this.finalize();
        }
    }

    public void deleteSequence(SequenceI s) {
        this.deleteSequence(this.findIndex(s));
    }

    public void deleteSequence(int i) {
        if (i > -1 && i < this.getHeight()) {
            this.sequences.removeElementAt(i);
            this.hiddenSequences.adjustHeightSequenceDeleted(i);
        }
    }

    public SequenceGroup findGroup(SequenceI s) {
        for (int i = 0; i < this.groups.size(); ++i) {
            SequenceGroup sg = (SequenceGroup)this.groups.elementAt(i);
            if (!sg.getSequences(null).contains(s)) continue;
            return sg;
        }
        return null;
    }

    public SequenceGroup[] findAllGroups(SequenceI s) {
        Vector<SequenceGroup> temp = new Vector<SequenceGroup>();
        int gSize = this.groups.size();
        for (int i = 0; i < gSize; ++i) {
            SequenceGroup sg = (SequenceGroup)this.groups.elementAt(i);
            if (sg == null || sg.getSequences(null) == null) {
                this.deleteGroup(sg);
                --gSize;
                continue;
            }
            if (!sg.getSequences(null).contains(s)) continue;
            temp.addElement(sg);
        }
        SequenceGroup[] ret = new SequenceGroup[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            ret[i] = (SequenceGroup)temp.elementAt(i);
        }
        return ret;
    }

    public void addGroup(SequenceGroup sg) {
        if (!this.groups.contains(sg)) {
            if (this.hiddenSequences.getSize() > 0) {
                int iSize = sg.getSize();
                for (int i = 0; i < iSize; ++i) {
                    if (this.sequences.contains(sg.getSequenceAt(i))) continue;
                    sg.deleteSequence(sg.getSequenceAt(i), false);
                    --iSize;
                    --i;
                }
                if (sg.getSize() < 1) {
                    return;
                }
            }
            this.groups.addElement(sg);
        }
    }

    public void deleteAllGroups() {
        this.groups.removeAllElements();
    }

    public void deleteGroup(SequenceGroup g) {
        if (this.groups.contains(g)) {
            this.groups.removeElement(g);
        }
    }

    public SequenceI findName(String name) {
        return this.findName(name, false);
    }

    public SequenceI findName(String token, boolean b) {
        return this.findName(null, token, b);
    }

    public SequenceI findName(SequenceI startAfter, String token, boolean b) {
        int i = 0;
        SequenceI sq = null;
        String sqname = null;
        if (startAfter != null) {
            boolean matched = false;
            while (i < this.sequences.size()) {
                if (this.getSequenceAt(i++) != startAfter) continue;
                matched = true;
                break;
            }
            if (!matched) {
                i = 0;
            }
        }
        while (i < this.sequences.size()) {
            sq = this.getSequenceAt(i);
            sqname = sq.getName();
            if (sqname.equals(token) || b && sqname.equalsIgnoreCase(token)) {
                return this.getSequenceAt(i);
            }
            ++i;
        }
        return null;
    }

    public SequenceI[] findSequenceMatch(String name) {
        int i;
        Vector<SequenceI> matches = new Vector<SequenceI>();
        for (i = 0; i < this.sequences.size(); ++i) {
            if (!this.getSequenceAt(i).getName().equals(name)) continue;
            matches.addElement(this.getSequenceAt(i));
        }
        SequenceI[] result = new SequenceI[matches.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (SequenceI)matches.elementAt(i);
        }
        return result;
    }

    public int findIndex(SequenceI s) {
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (s != this.getSequenceAt(i)) continue;
            return i;
        }
        return -1;
    }

    public int getHeight() {
        return this.sequences.size();
    }

    public int getWidth() {
        int maxLength = -1;
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (this.getSequenceAt(i).getLength() <= maxLength) continue;
            maxLength = this.getSequenceAt(i).getLength();
        }
        return maxLength;
    }

    public void setGapCharacter(char gc) {
        this.gapCharacter = gc;
        for (int i = 0; i < this.sequences.size(); ++i) {
            Sequence seq = (Sequence)this.sequences.elementAt(i);
            seq.setSequence(seq.getSequenceAsString().replace('.', gc).replace('-', gc).replace(' ', gc));
        }
    }

    public char getGapCharacter() {
        return this.gapCharacter;
    }

    public boolean isAligned() {
        int width = this.getWidth();
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (this.getSequenceAt(i).getLength() == width) continue;
            return false;
        }
        return true;
    }

    public boolean deleteAnnotation(AlignmentAnnotation aa) {
        int aSize = 1;
        if (this.annotations != null) {
            aSize = this.annotations.length;
        }
        if (aSize < 1) {
            return false;
        }
        AlignmentAnnotation[] temp = new AlignmentAnnotation[aSize - 1];
        boolean swap = false;
        int tIndex = 0;
        for (int i = 0; i < aSize; ++i) {
            if (this.annotations[i] == aa) {
                swap = true;
                continue;
            }
            if (tIndex >= temp.length) continue;
            temp[tIndex++] = this.annotations[i];
        }
        if (swap) {
            this.annotations = temp;
            if (aa.sequenceRef != null) {
                aa.sequenceRef.removeAlignmentAnnotation(aa);
            }
        }
        return swap;
    }

    public void addAnnotation(AlignmentAnnotation aa) {
        int aSize = 1;
        if (this.annotations != null) {
            aSize = this.annotations.length + 1;
        }
        AlignmentAnnotation[] temp = new AlignmentAnnotation[aSize];
        temp[aSize - 1] = aa;
        int i = 0;
        if (aSize > 1) {
            for (i = 0; i < aSize - 1; ++i) {
                temp[i] = this.annotations[i];
            }
        }
        this.annotations = temp;
    }

    public void setAnnotationIndex(AlignmentAnnotation aa, int index) {
        if (aa == null || this.annotations == null || this.annotations.length - 1 < index) {
            return;
        }
        int aSize = this.annotations.length;
        AlignmentAnnotation[] temp = new AlignmentAnnotation[aSize];
        temp[index] = aa;
        for (int i = 0; i < aSize; ++i) {
            if (i == index) continue;
            temp[i] = i < index ? this.annotations[i] : this.annotations[i - 1];
        }
        this.annotations = temp;
    }

    public AlignmentAnnotation[] getAlignmentAnnotation() {
        return this.annotations;
    }

    public void setNucleotide(boolean b) {
        this.type = b ? 1 : 0;
    }

    public boolean isNucleotide() {
        return this.type == 1;
    }

    public void setDataset(Alignment data) {
        if (this.dataset == null && data == null) {
            SequenceI[] seqs = new SequenceI[this.getHeight()];
            for (int i = 0; i < this.getHeight(); ++i) {
                SequenceI currentSeq = this.getSequenceAt(i);
                seqs[i] = currentSeq.getDatasetSequence() != null ? (Sequence)currentSeq.getDatasetSequence() : currentSeq.createDatasetSequence();
            }
            this.dataset = new Alignment(seqs);
        } else if (this.dataset == null && data != null) {
            this.dataset = data;
        }
        this.dataset.addAlignmentRef();
    }

    private void addAlignmentRef() {
        ++this.alignmentRefs;
    }

    public Alignment getDataset() {
        return this.dataset;
    }

    public boolean padGaps() {
        SequenceI current;
        boolean modified = false;
        int maxLength = -1;
        block0: for (int i = 0; i < this.sequences.size(); ++i) {
            current = this.getSequenceAt(i);
            for (int j = current.getLength(); j > maxLength; --j) {
                if (j <= maxLength || Comparison.isGap(current.getCharAt(j))) continue;
                maxLength = j;
                continue block0;
            }
        }
        ++maxLength;
        for (int i = 0; i < this.sequences.size(); ++i) {
            current = this.getSequenceAt(i);
            int cLength = current.getLength();
            if (cLength < maxLength) {
                current.insertCharAt(cLength, maxLength - cLength, this.gapCharacter);
                modified = true;
                continue;
            }
            if (current.getLength() <= maxLength) continue;
            current.deleteChars(maxLength, current.getLength());
        }
        return modified;
    }

    public HiddenSequences getHiddenSequences() {
        return this.hiddenSequences;
    }

    public CigarArray getCompactAlignment() {
        CigarSimple[] alseqs = new SeqCigar[this.sequences.size()];
        for (int i = 0; i < this.sequences.size(); ++i) {
            alseqs[i] = new SeqCigar((SequenceI)this.sequences.elementAt(i));
        }
        CigarArray cal = new CigarArray(alseqs);
        cal.addOperation('M', this.getWidth());
        return cal;
    }

    public void setProperty(Object key, Object value) {
        if (this.alignmentProperties == null) {
            this.alignmentProperties = new Hashtable();
        }
        this.alignmentProperties.put(key, value);
    }

    public Object getProperty(Object key) {
        if (this.alignmentProperties != null) {
            return this.alignmentProperties.get(key);
        }
        return null;
    }

    public Hashtable getProperties() {
        return this.alignmentProperties;
    }

    public void addCodonFrame(AlignedCodonFrame codons) {
        if (codons == null) {
            return;
        }
        if (this.codonFrameList == null) {
            this.codonFrameList = new AlignedCodonFrame[]{codons};
            return;
        }
        AlignedCodonFrame[] t = new AlignedCodonFrame[this.codonFrameList.length + 1];
        System.arraycopy(this.codonFrameList, 0, t, 0, this.codonFrameList.length);
        t[this.codonFrameList.length] = codons;
        this.codonFrameList = t;
    }

    public AlignedCodonFrame getCodonFrame(int index) {
        return this.codonFrameList[index];
    }

    public AlignedCodonFrame[] getCodonFrame(SequenceI seq) {
        if (seq == null || this.codonFrameList == null) {
            return null;
        }
        Vector<AlignedCodonFrame> cframes = new Vector<AlignedCodonFrame>();
        for (int f = 0; f < this.codonFrameList.length; ++f) {
            if (!this.codonFrameList[f].involvesSequence(seq)) continue;
            cframes.addElement(this.codonFrameList[f]);
        }
        if (cframes.size() == 0) {
            return null;
        }
        Object[] cfr = new AlignedCodonFrame[cframes.size()];
        cframes.copyInto(cfr);
        return cfr;
    }

    public AlignedCodonFrame[] getCodonFrames() {
        return this.codonFrameList;
    }

    public boolean removeCodonFrame(AlignedCodonFrame codons) {
        if (codons == null || this.codonFrameList == null) {
            return false;
        }
        boolean removed = false;
        int i = 0;
        int iSize = this.codonFrameList.length;
        while (i < iSize) {
            if (this.codonFrameList[i] == codons) {
                removed = true;
                if (i + 1 < iSize) {
                    System.arraycopy(this.codonFrameList, i + 1, this.codonFrameList, i, iSize - i - 1);
                }
                --iSize;
                continue;
            }
            ++i;
        }
        return removed;
    }

    public void append(AlignmentI toappend) {
        Vector sqs;
        boolean samegap = toappend.getGapCharacter() == this.getGapCharacter();
        char oldc = toappend.getGapCharacter();
        boolean hashidden = toappend.getHiddenSequences() != null && toappend.getHiddenSequences().hiddenSequences != null;
        Vector vector = sqs = hashidden ? toappend.getHiddenSequences().getFullAlignment().getSequences() : toappend.getSequences();
        if (sqs != null) {
            Enumeration sq = sqs.elements();
            while (sq.hasMoreElements()) {
                SequenceI addedsq = (SequenceI)sq.nextElement();
                if (!samegap) {
                    char[] oldseq = addedsq.getSequence();
                    for (int c = 0; c < oldseq.length; ++c) {
                        if (oldseq[c] != oldc) continue;
                        oldseq[c] = this.gapCharacter;
                    }
                }
                this.addSequence(addedsq);
            }
        }
        AlignmentAnnotation[] alan = toappend.getAlignmentAnnotation();
        for (int a = 0; alan != null && a < alan.length; ++a) {
            this.addAnnotation(alan[a]);
        }
        AlignedCodonFrame[] acod = toappend.getCodonFrames();
        for (int a = 0; acod != null && a < acod.length; ++a) {
            this.addCodonFrame(acod[a]);
        }
        Vector sg = toappend.getGroups();
        if (sg != null) {
            Enumeration el = sg.elements();
            while (el.hasMoreElements()) {
                this.addGroup((SequenceGroup)el.nextElement());
            }
        }
        if (toappend.getHiddenSequences() != null) {
            HiddenSequences hs = toappend.getHiddenSequences();
            if (this.hiddenSequences == null) {
                this.hiddenSequences = new HiddenSequences(this);
            }
            if (hs.hiddenSequences != null) {
                for (int s = 0; s < hs.hiddenSequences.length; ++s) {
                    if (hs.hiddenSequences[s] == null) continue;
                    this.hiddenSequences.hideSequence(hs.hiddenSequences[s]);
                }
            }
        }
        if (toappend.getProperties() != null) {
            Enumeration key = toappend.getProperties().keys();
            while (key.hasMoreElements()) {
                Object k = key.nextElement();
                Object ourval = this.getProperty(k);
                Object toapprop = toappend.getProperty(k);
                if (ourval != null) {
                    if (!ourval.getClass().equals(toapprop.getClass()) || ourval.equals(toapprop)) continue;
                    if (ourval instanceof String) {
                        this.setProperty(k, (String)ourval + "; " + (String)toapprop);
                        continue;
                    }
                    if (!(ourval instanceof Vector)) continue;
                    Enumeration theirv = ((Vector)toapprop).elements();
                    while (theirv.hasMoreElements()) {
                        ((Vector)ourval).addElement(theirv);
                    }
                    continue;
                }
                this.setProperty(k, toapprop);
            }
        }
    }
}

