/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.pict.ColorTable;
import com.kreative.rsrc.pict.PICTUtilities;
import com.kreative.rsrc.pict.PixMap;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class ColorIconResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1667851118;

    public static boolean isMyType(int type) {
        return type == 1667851118;
    }

    public ColorIconResource(short id, byte[] data) {
        super(1667851118, id, data);
    }

    public ColorIconResource(short id, String name, byte[] data) {
        super(1667851118, id, name, data);
    }

    public ColorIconResource(short id, byte attr, byte[] data) {
        super(1667851118, id, attr, data);
    }

    public ColorIconResource(short id, byte attr, String name, byte[] data) {
        super(1667851118, id, attr, name, data);
    }

    public ColorIconResource(int type, short id, byte[] data) {
        super(type, id, data);
    }

    public ColorIconResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
    }

    public ColorIconResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
    }

    public ColorIconResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
    }

    public Image getBWImage() {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data));
            PixMap iconpm = PixMap.read(in, true);
            PixMap maskbm = PixMap.read(in, true);
            PixMap iconbm = PixMap.read(in, true);
            in.readInt();
            byte[] maskbd = maskbm.readPixData(in, false);
            byte[] iconbd = iconbm.readPixData(in, false);
            ColorTable iconct = iconpm.hasColorTable() ? ColorTable.read(in) : null;
            byte[] iconpd = iconpm.readPixData(in, false);
            return PICTUtilities.pixmapToImage(iconbm, null, iconbd, -1, -16777216, false, false);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Image getMask() {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data));
            PixMap iconpm = PixMap.read(in, true);
            PixMap maskbm = PixMap.read(in, true);
            PixMap iconbm = PixMap.read(in, true);
            in.readInt();
            byte[] maskbd = maskbm.readPixData(in, false);
            byte[] iconbd = iconbm.readPixData(in, false);
            ColorTable iconct = iconpm.hasColorTable() ? ColorTable.read(in) : null;
            byte[] iconpd = iconpm.readPixData(in, false);
            return PICTUtilities.pixmapToImage(maskbm, null, maskbd, -1, -16777216, false, false);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Image getImage() {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data));
            PixMap iconpm = PixMap.read(in, true);
            PixMap maskbm = PixMap.read(in, true);
            PixMap iconbm = PixMap.read(in, true);
            in.readInt();
            byte[] maskbd = maskbm.readPixData(in, false);
            byte[] iconbd = iconbm.readPixData(in, false);
            ColorTable iconct = iconpm.hasColorTable() ? ColorTable.read(in) : null;
            byte[] iconpd = iconpm.readPixData(in, false);
            return PICTUtilities.pixmapToImage(iconpm, iconct, iconpd, -1, -16777216, false, false);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Image getBWComposite() {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data));
            PixMap iconpm = PixMap.read(in, true);
            PixMap maskbm = PixMap.read(in, true);
            PixMap iconbm = PixMap.read(in, true);
            in.readInt();
            byte[] maskbd = maskbm.readPixData(in, false);
            byte[] iconbd = iconbm.readPixData(in, false);
            ColorTable iconct = iconpm.hasColorTable() ? ColorTable.read(in) : null;
            byte[] iconpd = iconpm.readPixData(in, false);
            BufferedImage icn = PICTUtilities.pixmapToImage(iconbm, null, iconbd, -1, -16777216, false, false);
            BufferedImage msk = PICTUtilities.pixmapToImage(maskbm, null, maskbd, -1, -16777216, false, false);
            int[] icnpixels = new int[icn.getWidth() * icn.getHeight()];
            icn.getRGB(0, 0, icn.getWidth(), icn.getHeight(), icnpixels, 0, icn.getWidth());
            int[] mskpixels = new int[msk.getWidth() * msk.getHeight()];
            msk.getRGB(0, 0, msk.getWidth(), msk.getHeight(), mskpixels, 0, msk.getWidth());
            int i = 0;
            while (i < icnpixels.length && i < mskpixels.length) {
                if ((mskpixels[i] & 0xFFFFFF) >= 0x800000) {
                    icnpixels[i] = 0;
                }
                ++i;
            }
            BufferedImage cmp = new BufferedImage(icn.getWidth(), icn.getHeight(), 2);
            cmp.setRGB(0, 0, icn.getWidth(), icn.getHeight(), icnpixels, 0, icn.getWidth());
            return cmp;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Image getComposite() {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data));
            PixMap iconpm = PixMap.read(in, true);
            PixMap maskbm = PixMap.read(in, true);
            PixMap iconbm = PixMap.read(in, true);
            in.readInt();
            byte[] maskbd = maskbm.readPixData(in, false);
            byte[] iconbd = iconbm.readPixData(in, false);
            ColorTable iconct = iconpm.hasColorTable() ? ColorTable.read(in) : null;
            byte[] iconpd = iconpm.readPixData(in, false);
            BufferedImage icn = PICTUtilities.pixmapToImage(iconpm, iconct, iconpd, -1, -16777216, false, false);
            BufferedImage msk = PICTUtilities.pixmapToImage(maskbm, null, maskbd, -1, -16777216, false, false);
            int[] icnpixels = new int[icn.getWidth() * icn.getHeight()];
            icn.getRGB(0, 0, icn.getWidth(), icn.getHeight(), icnpixels, 0, icn.getWidth());
            int[] mskpixels = new int[msk.getWidth() * msk.getHeight()];
            msk.getRGB(0, 0, msk.getWidth(), msk.getHeight(), mskpixels, 0, msk.getWidth());
            int i = 0;
            while (i < icnpixels.length && i < mskpixels.length) {
                if ((mskpixels[i] & 0xFFFFFF) >= 0x800000) {
                    icnpixels[i] = 0;
                }
                ++i;
            }
            BufferedImage cmp = new BufferedImage(icn.getWidth(), icn.getHeight(), 2);
            cmp.setRGB(0, 0, icn.getWidth(), icn.getHeight(), icnpixels, 0, icn.getWidth());
            return cmp;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }
}

